/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.BrowserTools;
import ice.htmlbrowser.LexCacheCell;
import java.net.URL;
import java.util.Vector;

class LexCache {
    char[] cache;
    int[] nextCluster;
    int[] typeCluster;
    private Vector cacheCells;
    private int numClusters;
    private int cacheSize;
    static final int CLUSTER_SIZE = 8192;
    static final int TYPE_FREE = 0;
    static final int TYPE_LINK = 1;
    static final int TYPE_HEAD = 2;
    private int start;

    LexCache(int n) {
        this.cacheSize = n;
        this.numClusters = n / 8192;
        this.cache = new char[this.numClusters * 8192];
        this.nextCluster = new int[this.numClusters];
        this.typeCluster = new int[this.numClusters];
        int n2 = 0;
        while (n2 < this.numClusters) {
            this.nextCluster[n2] = -1;
            this.typeCluster[n2] = 0;
            ++n2;
        }
        this.cacheCells = new Vector();
    }

    int getSize() {
        return this.cacheSize;
    }

    void removeCachedLocation(String string) {
        try {
            URL uRL = new URL(string);
            String string2 = uRL.getProtocol();
            if (!string2.equals("http")) {
                return;
            }
            int n = 0;
            while (n < this.cacheCells.size()) {
                LexCacheCell lexCacheCell = (LexCacheCell)this.cacheCells.elementAt(n);
                if (BrowserTools.sameFile(lexCacheCell.url, uRL) && !lexCacheCell.inuse) {
                    LexCache lexCache = this;
                    synchronized (lexCache) {
                        this.cacheCells.removeElementAt(n);
                        int n2 = lexCacheCell.firstCluster;
                        while (n2 >= 0) {
                            this.typeCluster[n2] = 0;
                            int n3 = this.nextCluster[n2];
                            this.nextCluster[n2] = -1;
                            n2 = n3;
                        }
                        return;
                    }
                }
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    synchronized LexCacheCell getCachedURL(URL uRL) {
        String string = uRL.getProtocol();
        if (!string.equals("http")) {
            return null;
        }
        int n = 0;
        while (n < this.cacheCells.size()) {
            LexCacheCell lexCacheCell = (LexCacheCell)this.cacheCells.elementAt(n);
            if (BrowserTools.sameFile(uRL, lexCacheCell.url) && !lexCacheCell.inuse) {
                lexCacheCell.initReader();
                return lexCacheCell;
            }
            ++n;
        }
        return null;
    }

    synchronized LexCacheCell beginCaching(URL uRL, String string) {
        String string2 = uRL.getProtocol();
        if (!string2.equals("http")) {
            return null;
        }
        int n = this.findFreeCluster();
        this.typeCluster[n] = 2;
        LexCacheCell lexCacheCell = new LexCacheCell(this, uRL, string, n);
        this.cacheCells.addElement(lexCacheCell);
        lexCacheCell.inuse = true;
        return lexCacheCell;
    }

    private synchronized int findFreeCluster() {
        int n = this.start;
        while (this.start < this.numClusters) {
            if (this.typeCluster[this.start] == 0) {
                return this.start;
            }
            ++this.start;
        }
        this.start = 0;
        while (this.start < n) {
            if (this.typeCluster[this.start] == 0) {
                return this.start;
            }
            ++this.start;
        }
        LexCacheCell lexCacheCell = null;
        int n2 = 0;
        n2 = 0;
        while (n2 < this.cacheCells.size()) {
            lexCacheCell = (LexCacheCell)this.cacheCells.elementAt(n2);
            if (!lexCacheCell.inuse) {
                this.cacheCells.removeElementAt(n2);
                break;
            }
            ++n2;
        }
        int n3 = this.start = lexCacheCell.firstCluster;
        while (n3 >= 0) {
            this.typeCluster[n3] = 0;
            n = this.nextCluster[n3];
            this.nextCluster[n3] = -1;
            n3 = n;
        }
        return this.start;
    }

    int allocCluster(int n) {
        int n2 = this.findFreeCluster();
        int n3 = n;
        while (this.nextCluster[n3] >= 0) {
            n3 = this.nextCluster[n3];
        }
        this.nextCluster[n3] = n2;
        this.typeCluster[n2] = 1;
        return n2;
    }

    int countClusters(int n) {
        int n2 = n;
        int n3 = 0;
        while (n2 != -1) {
            ++n3;
            n2 = this.nextCluster[n2];
        }
        return n3;
    }
}

