/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.ascii;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.wizardx.ascii.AbstractUpdate;
import com.installshield.wizardx.ascii.AsciiFileUpdateSupport;
import com.installshield.wizardx.ascii.ModifyFile;
import com.installshield.wizardx.ascii.Update;
import java.util.Vector;

public class SearchLine
extends AbstractUpdate
implements Update,
Cloneable,
PropertyAccessible {
    private String[] tokens = new String[0];
    private boolean respectCase = false;
    private int occurrenceFrequency = 0;
    private int returnPosition = 0;
    private int tokensNotFound = 2;
    private boolean ignoreCommentLines = true;
    public static final String TYPE_DESCRIPTION = "Search Line/Text";

    public Object clone() {
        SearchLine searchLine = (SearchLine)super.clone();
        searchLine.tokens = this.tokens;
        searchLine.respectCase = this.respectCase;
        searchLine.occurrenceFrequency = this.occurrenceFrequency;
        searchLine.returnPosition = this.returnPosition;
        searchLine.tokensNotFound = this.tokensNotFound;
        searchLine.ignoreCommentLines = this.ignoreCommentLines;
        return searchLine;
    }

    public boolean execute(ModifyFile modifyFile) {
        if (this.getTokens() == null || !this.validTokens()) {
            modifyFile.getLogAdd().addElement("Search Line/Text requires Tokens contain at least one valid token.");
        } else {
            modifyFile.setMatch(this.getResolvedTokens(modifyFile));
            modifyFile.setCaseSensitive(this.getRespectCase());
            modifyFile.setOccurrenceFrequency(this.getOccurrenceFrequency());
            modifyFile.setReturnPosition(this.getReturnPosition());
            modifyFile.setTokensNotFound(this.getTokensNotFound());
            modifyFile.setIgnoreCommentLines(this.getIgnoreCommentLines());
            modifyFile.searchMultipleStrings();
        }
        return false;
    }

    private String formatTokens() {
        String[] stringArray = this.getTokens();
        if (stringArray == null || stringArray.length <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 30;
        int n2 = 0;
        while (n > 0 && n2 < stringArray.length) {
            String string;
            if (n2 > 0) {
                stringBuffer.append(", ");
            }
            if ((string = stringArray[n2]).length() > n) {
                stringBuffer.append(String.valueOf(string.substring(0, n)) + "...");
            } else {
                stringBuffer.append(string);
            }
            n -= string.length();
            ++n2;
        }
        return stringBuffer.toString();
    }

    public boolean getIgnoreCommentLines() {
        return this.ignoreCommentLines;
    }

    public int getOccurrenceFrequency() {
        return this.occurrenceFrequency;
    }

    private Vector getResolvedTokens(ModifyFile modifyFile) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.getTokens().length) {
            if (this.getTokens()[n] != null && this.getTokens()[n].length() > 0) {
                vector.addElement(modifyFile.resolveString(this.getTokens()[n]));
            }
            ++n;
        }
        return vector;
    }

    public boolean getRespectCase() {
        return this.respectCase;
    }

    public int getReturnPosition() {
        return this.returnPosition;
    }

    public String getShortDescription() {
        return "Search for: " + this.formatTokens();
    }

    public String[] getTokens() {
        return this.tokens;
    }

    public int getTokensNotFound() {
        return this.tokensNotFound;
    }

    public String getTypeDescription() {
        return TYPE_DESCRIPTION;
    }

    public void setIgnoreCommentLines(boolean bl) {
        this.ignoreCommentLines = bl;
    }

    public void setOccurrenceFrequency(int n) {
        this.occurrenceFrequency = n;
    }

    public void setRespectCase(boolean bl) {
        this.respectCase = bl;
    }

    public void setReturnPosition(int n) {
        this.returnPosition = n;
    }

    public void setTokens(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("tokens cannot be null");
        }
        this.tokens = stringArray;
    }

    public void setTokensNotFound(int n) {
        this.tokensNotFound = n;
    }

    private boolean validTokens() {
        int n = 0;
        while (n < this.getTokens().length) {
            if (this.getTokens()[n] != null && this.getTokens()[n].length() > 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void verify(AsciiFileUpdateSupport asciiFileUpdateSupport) {
        if (this.getTokens() == null || !this.validTokens()) {
            asciiFileUpdateSupport.logEvent(this, "wrn", "Search Line/Text requires Tokens contain at least one valid token.");
        }
    }
}

