/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.ascii;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.wizardx.ascii.AbstractUpdate;
import com.installshield.wizardx.ascii.AsciiFileUpdateSupport;
import com.installshield.wizardx.ascii.ModifyFile;
import com.installshield.wizardx.ascii.SearchResult;
import com.installshield.wizardx.ascii.Update;

public class AddLine
extends AbstractUpdate
implements Update,
Cloneable,
PropertyAccessible {
    private int addOption = 0;
    private String[] textLines = new String[0];
    private int location = 1;
    public static final int LINE = 0;
    public static final int TEXT = 1;
    public static final int COMMENT = 2;
    public static final int COMMENT_LINE = 3;
    public static final int START_FILE = 0;
    public static final int END_FILE = 1;
    public static final int CURRENT = 2;
    public static final String TYPE_DESCRIPTION = "Add Line/Text/Comment";

    public Object clone() {
        AddLine addLine = (AddLine)super.clone();
        addLine.addOption = this.addOption;
        addLine.textLines = this.textLines;
        addLine.location = this.location;
        return addLine;
    }

    public boolean execute(ModifyFile modifyFile) {
        boolean bl = false;
        if (this.getAddOption() != 2 && (this.getTextLines() == null || this.getTextLines().length == 0 || this.getTextLines().length == 1 && this.getTextLines()[0].length() == 0)) {
            modifyFile.getLogAdd().addElement("Add Line/Text/Comment requires Text Lines unless adding a comment.");
        } else {
            if (this.getLocation() == 0) {
                modifyFile.setASCIISearchResults(new SearchResult[]{modifyFile.startOfFile()});
            } else if (this.getLocation() == 1) {
                modifyFile.setASCIISearchResults(new SearchResult[]{modifyFile.endOfFile()});
            }
            if (modifyFile.getASCIISearchResults() != null && modifyFile.getASCIISearchResults().length > 0) {
                if (this.getAddOption() == 2) {
                    modifyFile.addComment();
                } else {
                    String[] stringArray = new String[this.getTextLines().length];
                    int n = 0;
                    while (n < this.getTextLines().length) {
                        stringArray[n] = modifyFile.resolveString(this.getTextLines()[n]);
                        ++n;
                    }
                    if (this.getAddOption() == 1) {
                        modifyFile.addText(stringArray);
                    } else if (this.getAddOption() == 0) {
                        modifyFile.addLine(stringArray);
                    } else {
                        modifyFile.addCommentLine(stringArray);
                    }
                }
                bl = true;
                modifyFile.setASCIISearchResults(null);
            }
        }
        return bl;
    }

    private String formatTextLines() {
        String[] stringArray = this.getTextLines();
        if (stringArray == null || stringArray.length <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 30;
        int n2 = 0;
        while (n > 0 && n2 < stringArray.length) {
            String string;
            if (n2 > 0) {
                stringBuffer.append(", ");
            }
            if ((string = stringArray[n2]).length() > n) {
                stringBuffer.append(String.valueOf(string.substring(0, n)) + "...");
            } else {
                stringBuffer.append(string);
            }
            n -= string.length();
            ++n2;
        }
        return stringBuffer.toString();
    }

    public int getAddOption() {
        return this.addOption;
    }

    public int getLocation() {
        return this.location;
    }

    public String getShortDescription() {
        String string = this.getAddOption() == 0 ? "Line(s): " : (this.getAddOption() == 1 ? "Text: " : (this.getAddOption() == 2 ? "Comment Chars" : "Comment Line(s): "));
        String string2 = "Add " + string;
        if (this.getAddOption() == 2) {
            return string2;
        }
        return String.valueOf(string2) + this.formatTextLines();
    }

    public String[] getTextLines() {
        return this.textLines;
    }

    public String getTypeDescription() {
        return TYPE_DESCRIPTION;
    }

    public void setAddOption(int n) {
        this.addOption = n;
    }

    public void setLocation(int n) {
        this.location = n;
    }

    public void setTextLines(String[] stringArray) {
        this.textLines = stringArray;
    }

    public void verify(AsciiFileUpdateSupport asciiFileUpdateSupport) {
        if (this.getAddOption() != 2 && (this.getTextLines() == null || this.getTextLines().length == 0 || this.getTextLines().length == 1 && this.getTextLines()[0].length() == 0)) {
            asciiFileUpdateSupport.logEvent(this, "wrn", "Add Line/Text/Comment requires Text Lines unless adding a comment.");
        }
    }
}

