/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32;

import com.installshield.product.service.desktop.DesktopServiceImplementor;
import com.installshield.product.service.desktop.PureJavaDesktopServiceImpl;
import com.installshield.util.FileAttributes;
import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.win32.Win32Platform;
import com.installshield.wizard.platform.win32.Win32Utils;
import com.installshield.wizard.service.ServiceException;
import java.util.Properties;

public class Win32DesktopServiceImpl
extends PureJavaDesktopServiceImpl
implements DesktopServiceImplementor {
    public static final String ALL_USERS_START_MENU = "$AllUsersStartMenu$";
    public static final String ALL_USERS_PROGRAMS = "$AllUsersPrograms$";
    public static final String ALL_USERS_DESKTOP = "$AllUsersDesktop$";
    public static final String CURRENT_USER_START_MENU = "$UserStartMenu$";
    public static final String CURRENT_USER_PROGRAMS = "$UserPrograms$";
    public static final String CURRENT_USER_DESKTOP = "$UserDesktop$";

    public void createDesktopFolder(String string) throws ServiceException {
        String[] stringArray = this.parseFolderName(string);
        this.createDesktopFolder(stringArray[0], stringArray[1]);
    }

    public native void createDesktopFolder(String var1, String var2) throws ServiceException;

    public void createDesktopItem(String string, String string2, String string3, String string4, String string5, String string6) throws ServiceException {
        String[] stringArray = this.parseFolderName(string);
        this.createDesktopItem(stringArray[0], stringArray[1], string2, string3, string4, string5, string6);
    }

    private native void createDesktopItem(String var1, String var2, String var3, String var4, String var5, String var6, String var7) throws ServiceException;

    public void createDesktopItem(String string, String string2, String string3, String string4, String string5, String string6, String string7, Properties properties) throws ServiceException {
        this.createDesktopItem(string, string2, string3, string4, string5, string6, string7);
    }

    public FileAttributes getDesktopFolderAttributes(String string) throws ServiceException {
        String[] stringArray = this.parseFolderName(string);
        return this.getDesktopFolderAttributes(stringArray[0], stringArray[1]);
    }

    public native FileAttributes getDesktopFolderAttributes(String var1, String var2) throws ServiceException;

    public String getDesktopFolderOwner(String string) throws ServiceException {
        String[] stringArray = this.parseFolderName(string);
        return this.getDesktopFolderOwner(stringArray[0], stringArray[1]);
    }

    public native String getDesktopFolderOwner(String var1, String var2) throws ServiceException;

    public String getDesktopFolderOwnerGroup(String string) throws ServiceException {
        String[] stringArray = this.parseFolderName(string);
        return this.getDesktopFolderOwnerGroup(stringArray[0], stringArray[1]);
    }

    public native String getDesktopFolderOwnerGroup(String var1, String var2) throws ServiceException;

    public FileAttributes getDesktopItemAttributes(String string, String string2) throws ServiceException {
        String[] stringArray = this.parseFolderName(string);
        return this.getDesktopItemAttributes(stringArray[0], stringArray[1], string2);
    }

    public native FileAttributes getDesktopItemAttributes(String var1, String var2, String var3) throws ServiceException;

    public String getDesktopItemOwner(String string, String string2) throws ServiceException {
        String[] stringArray = this.parseFolderName(string);
        return this.getDesktopItemOwner(stringArray[0], stringArray[1], string2);
    }

    public native String getDesktopItemOwner(String var1, String var2, String var3) throws ServiceException;

    public String getDesktopItemOwnerGroup(String string, String string2) throws ServiceException {
        String[] stringArray = this.parseFolderName(string);
        return this.getDesktopItemOwnerGroup(stringArray[0], stringArray[1], string2);
    }

    public native String getDesktopItemOwnerGroup(String var1, String var2, String var3) throws ServiceException;

    public String getPlatformId() {
        return "win32ppk";
    }

    public int getSystemCompatibility() {
        int n = 0;
        try {
            if (Win32Platform.isCompatibleWith(1, 1)) {
                n = 5;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    protected void initialized() {
        super.initialized();
        try {
            Win32Utils.loadDLL(this.getResource(Win32Utils.getJNIDLLResourceName()), Win32Utils.getJNIDLLName());
        }
        catch (Exception exception) {
            System.out.println(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "serviceCannotLoadJniDll", new String[]{"desktopService", Win32Utils.getJNIDLLName()}));
            exception.printStackTrace();
        }
    }

    public boolean isContextOwnershipSupported(String string) throws ServiceException {
        return true;
    }

    private String[] parseFolderName(String string) {
        String string2 = FileUtils.normalizeFileName(string);
        int n = string2.indexOf("\\");
        String string3 = "";
        String string4 = "";
        if (n > 0) {
            string3 = string2.substring(0, n);
            if (!(string3.equals(CURRENT_USER_PROGRAMS) || string3.equals(ALL_USERS_PROGRAMS) || string3.equals(CURRENT_USER_START_MENU) || string3.equals(ALL_USERS_START_MENU) || string3.equals(CURRENT_USER_DESKTOP) || string3.equals(ALL_USERS_DESKTOP))) {
                string3 = "";
                string4 = string2;
            } else {
                string4 = string2.substring(n + 1);
            }
        } else {
            string4 = string2;
        }
        return new String[]{string3, string4};
    }

    public void removeDesktopFolder(String string) throws ServiceException {
        String[] stringArray = this.parseFolderName(string);
        this.removeDesktopFolder(stringArray[0], stringArray[1]);
    }

    public native void removeDesktopFolder(String var1, String var2) throws ServiceException;

    public void removeDesktopItem(String string, String string2) throws ServiceException {
        String[] stringArray = this.parseFolderName(string);
        this.removeDesktopItem(stringArray[0], stringArray[1], string2);
    }

    public native void removeDesktopItem(String var1, String var2, String var3) throws ServiceException;

    public void setDesktopFolderAttributes(String string, FileAttributes fileAttributes) throws ServiceException {
        String[] stringArray = this.parseFolderName(string);
        this.setDesktopFolderAttributes(stringArray[0], stringArray[1], fileAttributes);
    }

    public native void setDesktopFolderAttributes(String var1, String var2, FileAttributes var3) throws ServiceException;

    public void setDesktopFolderOwner(String string, String string2) throws ServiceException {
        String[] stringArray = this.parseFolderName(string);
        this.setDesktopFolderOwner(stringArray[0], stringArray[1], string2);
    }

    public native void setDesktopFolderOwner(String var1, String var2, String var3) throws ServiceException;

    public void setDesktopFolderOwnerGroup(String string, String string2) throws ServiceException {
        String[] stringArray = this.parseFolderName(string);
        this.setDesktopFolderOwnerGroup(stringArray[0], stringArray[1], string2);
    }

    public native void setDesktopFolderOwnerGroup(String var1, String var2, String var3) throws ServiceException;

    public void setDesktopItemAttributes(String string, String string2, FileAttributes fileAttributes) throws ServiceException {
        String[] stringArray = this.parseFolderName(string);
        this.setDesktopItemAttributes(stringArray[0], stringArray[1], string2, fileAttributes);
    }

    public native void setDesktopItemAttributes(String var1, String var2, String var3, FileAttributes var4) throws ServiceException;

    public void setDesktopItemOwner(String string, String string2, String string3) throws ServiceException {
        String[] stringArray = this.parseFolderName(string);
        this.setDesktopItemOwner(stringArray[0], stringArray[1], string2, string3);
    }

    public native void setDesktopItemOwner(String var1, String var2, String var3, String var4) throws ServiceException;

    public void setDesktopItemOwnerGroup(String string, String string2, String string3) throws ServiceException {
        String[] stringArray = this.parseFolderName(string);
        this.setDesktopItemOwnerGroup(stringArray[0], stringArray[1], string2, string3);
    }

    public native void setDesktopItemOwnerGroup(String var1, String var2, String var3, String var4) throws ServiceException;
}

