/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.wizardbeans;

import com.installshield.product.Product;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductFeature;
import com.installshield.product.ProductTree;
import com.installshield.product.ProductTreeIterator;
import com.installshield.product.ProductTreeIteratorFactory;
import com.installshield.product.wizardbeans.FeaturePanel;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.TTYDisplay;
import com.installshield.wizard.console.DefaultConsoleWizardPanelImpl;
import com.installshield.wizard.service.ServiceException;
import java.util.Stack;
import java.util.Vector;

public class FeaturePanelConsoleImpl
extends DefaultConsoleWizardPanelImpl {
    private boolean beanHasChildren(ProductBean productBean) {
        ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createChildIterator(productBean);
        ProductBean productBean2 = productTreeIterator.getNext(productTreeIterator.begin());
        while (productBean2 != productTreeIterator.end()) {
            if (this.canDisplayBean(productBean2)) {
                return true;
            }
            productBean2 = productTreeIterator.getNext(productBean2);
        }
        return false;
    }

    private boolean canDisplayBean(ProductBean productBean) {
        return (productBean instanceof ProductFeature || productBean instanceof Product) && this.getFP().isBeanVisible(productBean.getBeanId());
    }

    protected void consoleInteraction(TTYDisplay tTYDisplay) {
        try {
            ProductTree productTree = this.getFP().getProductTree();
            ProductBean productBean = productTree.getRoot();
            while (true) {
                tTYDisplay.setBaseIndent(0);
                super.consoleInteraction(tTYDisplay);
                if (productBean != productTree.getRoot() || !this.isRootSelectable()) {
                    this.printContext(tTYDisplay, productTree, productBean);
                } else {
                    this.printSelectableRoot(tTYDisplay, productBean);
                }
                tTYDisplay.printLine();
                ProductBean[] productBeanArray = this.printFeatures(tTYDisplay, productTree, productBean);
                tTYDisplay.printLine();
                this.printOtherOptions(tTYDisplay, productTree, productBean);
                tTYDisplay.printLine();
                int n = tTYDisplay.promptInt(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "FeaturePanel.consoleChooseAction"), 0, productTree.getParent(productBean) != null || this.isRootSelectable() ? -1 : 0, productBeanArray.length);
                tTYDisplay.printLine();
                boolean bl = false;
                ProductBean productBean2 = null;
                if (n >= 1) {
                    productBean2 = productBeanArray[n - 1];
                    if (this.beanHasChildren(productBean2)) {
                        tTYDisplay.printLine();
                        this.printFeatureSelectOptions(tTYDisplay, productBean2);
                        tTYDisplay.printLine();
                        n = tTYDisplay.promptInt(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "FeaturePanel.consoleChooseAction"), 1, 0, 2);
                        tTYDisplay.printLine();
                        if (n == 1) {
                            bl = true;
                        } else if (n == 2) {
                            productBean = productBean2;
                        }
                    } else {
                        bl = true;
                    }
                } else {
                    if (n != -1) {
                        tTYDisplay.setBaseIndent(0);
                        break;
                    }
                    if (productBean != productTree.getRoot()) {
                        productBean = productTree.getParent(productBean);
                    } else {
                        productBean2 = productBean;
                        bl = true;
                    }
                }
                if (bl) {
                    this.getFP().setBeanActive(productBean2.getBeanId(), this.getFP().isBeanActive(productBean2.getBeanId()) ^ true);
                    productTree = this.getFP().getProductTree();
                    productBean = productTree.getBean(productBean.getBeanId());
                }
                tTYDisplay.printLine();
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
    }

    private String formatOption(int n) {
        if (n >= 10) {
            return " " + n;
        }
        if (n >= 0) {
            return "  " + n;
        }
        return " " + n;
    }

    protected String getContinueOption() {
        return LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "FeaturePanel.continueInstalling");
    }

    private FeaturePanel getFP() {
        return (FeaturePanel)this.getPanel();
    }

    protected String getNodeCaption(String string, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        if (bl) {
            stringBuffer.append(" ");
            stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "FeaturePanel.requiredLabel"));
        }
        if (bl2) {
            stringBuffer.append(" ");
            stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "FeaturePanel.installedLabel"));
        }
        return stringBuffer.toString();
    }

    protected String getSelectOption(String string) {
        return LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "FeaturePanel.selectFeature", new String[]{string});
    }

    protected boolean isRootSelectable() {
        return false;
    }

    private void printContext(TTYDisplay tTYDisplay, ProductTree productTree, ProductBean productBean) {
        Stack<ProductBean> stack = new Stack<ProductBean>();
        ProductBean productBean2 = productBean;
        while (productBean2 != null) {
            stack.push(productBean2);
            productBean2 = productTree.getParent(productBean2);
        }
        while (!stack.empty()) {
            ProductBean productBean3 = (ProductBean)stack.pop();
            String string = this.resolveString(productBean3.getDisplayName());
            if (productTree.getParent(productBean3) == null) {
                tTYDisplay.printLine("   " + string);
            } else {
                tTYDisplay.printLine(" - " + string);
            }
            tTYDisplay.setBaseIndent(tTYDisplay.getBaseIndent() + 3);
        }
    }

    private void printFeatureSelectOptions(TTYDisplay tTYDisplay, ProductBean productBean) {
        String string = this.resolveString(productBean.getDisplayName());
        if (this.getFP().isBeanActive(productBean.getBeanId())) {
            tTYDisplay.printLine(" 1. " + LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "FeaturePanel.deselectFeature", new String[]{string}));
        } else {
            tTYDisplay.printLine(" 1. " + this.getSelectOption(string));
        }
        tTYDisplay.printLine(" 2. " + LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "FeaturePanel.viewSubfeatures", new String[]{string}));
    }

    private ProductBean[] printFeatures(TTYDisplay tTYDisplay, ProductTree productTree, ProductBean productBean) {
        Object object;
        int n = 1;
        ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createChildIterator(productBean);
        boolean bl = false;
        Vector<ProductBean> vector = new Vector<ProductBean>();
        ProductBean productBean2 = productTreeIterator.getNext(productTreeIterator.begin());
        while (productBean2 != productTreeIterator.end()) {
            if (this.canDisplayBean(productBean2)) {
                if (!bl) {
                    tTYDisplay.printLine(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "FeaturePanel.consoleFeatureOptions"));
                    tTYDisplay.printLine();
                    bl = true;
                }
                object = new StringBuffer();
                ((StringBuffer)object).append(this.formatOption(n++));
                ((StringBuffer)object).append(".");
                if (this.beanHasChildren(productBean2)) {
                    ((StringBuffer)object).append(" +");
                } else {
                    ((StringBuffer)object).append("  ");
                }
                boolean bl2 = this.getFP().isBeanRequired(productBean2.getBeanId());
                if (bl2 || this.getFP().isBeanActive(productBean2.getBeanId())) {
                    ((StringBuffer)object).append("[x] ");
                } else {
                    ((StringBuffer)object).append("[ ] ");
                }
                ((StringBuffer)object).append(this.getNodeCaption(this.resolveString(productBean2.getDisplayName()), bl2, this.getFP().isBeanInstalled(productBean2.getBeanId())));
                tTYDisplay.printLine(((StringBuffer)object).toString());
                vector.addElement(productBean2);
            }
            productBean2 = productTreeIterator.getNext(productBean2);
        }
        object = new ProductBean[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    private void printOtherOptions(TTYDisplay tTYDisplay, ProductTree productTree, ProductBean productBean) {
        boolean bl = productTree.getParent(productBean) != null;
        tTYDisplay.printLine(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "FeaturePanel.consoleOtherOptions"));
        tTYDisplay.printLine();
        if (bl) {
            tTYDisplay.printLine(String.valueOf(this.formatOption(-1)) + ". " + LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "FeaturePanel.viewFeaturesParent"));
        } else if (productBean == productTree.getRoot() && this.isRootSelectable()) {
            String string = this.resolveString(productBean.getDisplayName());
            if (this.getFP().isBeanActive(productBean.getBeanId())) {
                tTYDisplay.printLine(String.valueOf(this.formatOption(-1)) + ". " + LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "FeaturePanel.deselectFeature", new String[]{string}));
            } else {
                tTYDisplay.printLine(String.valueOf(this.formatOption(-1)) + ". " + this.getSelectOption(string));
            }
        }
        tTYDisplay.printLine(String.valueOf(this.formatOption(0)) + ". " + this.getContinueOption());
    }

    private void printSelectableRoot(TTYDisplay tTYDisplay, ProductBean productBean) {
        tTYDisplay.printLine("   [" + (this.getFP().isBeanActive(productBean.getBeanId()) ? "x" : " ") + "] " + this.resolveString(productBean.getDisplayName()));
        tTYDisplay.setBaseIndent(tTYDisplay.getBaseIndent() + 3);
    }
}

