/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.service.product;

import com.installshield.archive.ArchiveResourceWriterFactory;
import com.installshield.archive.ArchiveWriter;
import com.installshield.archive.ArchiveWriterEntry;
import com.installshield.archive.ArchiveWriterZipOutputStream;
import com.installshield.archive.StandardResourceReaderFactory;
import com.installshield.archive.index.ResourceIndexRange;
import com.installshield.beans.ISIntrospector;
import com.installshield.product.DynamicSuite;
import com.installshield.product.FilteredProductTreeIterator;
import com.installshield.product.GenericSoftwareObject;
import com.installshield.product.Product;
import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductBeanPlaceHolder;
import com.installshield.product.ProductComponent;
import com.installshield.product.ProductComponentReference;
import com.installshield.product.ProductException;
import com.installshield.product.ProductFeature;
import com.installshield.product.ProductTree;
import com.installshield.product.ProductTreeIterator;
import com.installshield.product.ProductTreeIteratorFactory;
import com.installshield.product.RequiredBytesTable;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectKey;
import com.installshield.product.SoftwareObjectReference;
import com.installshield.product.SoftwareObjectUtils;
import com.installshield.product.SoftwareVersion;
import com.installshield.product.StandardProductTreeIterator;
import com.installshield.product.StaticSuite;
import com.installshield.product.UninstallProductAction;
import com.installshield.product.actions.UninstallerArchive;
import com.installshield.product.actions.UninstallerLauncher;
import com.installshield.product.iterators.ActiveProductTreeIterator;
import com.installshield.product.iterators.ChildrenProductTreeIterator;
import com.installshield.product.iterators.ConditionalProductTreeIterator;
import com.installshield.product.iterators.ImmutableConditionalProductTreeIterator;
import com.installshield.product.iterators.ProductActionTreeIterator;
import com.installshield.product.iterators.ProductTypeTreeIterator;
import com.installshield.product.iterators.RequiredTreeIterator;
import com.installshield.product.iterators.SelectedLocalesIterator;
import com.installshield.product.iterators.SoftwareObjectTreeIterator;
import com.installshield.product.service.product.InstallCheck;
import com.installshield.product.service.product.InstallableObjectVisitor;
import com.installshield.product.service.product.ProductPropertyAssignmentHandler;
import com.installshield.product.service.product.ProductServiceImplementor;
import com.installshield.product.service.product.ProductTreeSource;
import com.installshield.product.service.product.RequiredBytes;
import com.installshield.product.service.product.RequiredResourceIndices;
import com.installshield.product.service.product.TimeToInstall;
import com.installshield.product.service.registry.RegistryService;
import com.installshield.qjml.PropertyAccessible;
import com.installshield.qjml.QJML;
import com.installshield.util.CommandLineTokenizer;
import com.installshield.util.DefaultPropertyAssignmentHandler;
import com.installshield.util.FileUtils;
import com.installshield.util.LocaleUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.Log;
import com.installshield.util.LogListener;
import com.installshield.util.OperationRejectedException;
import com.installshield.util.PropertyAssignmentParser;
import com.installshield.util.PropertyReadParser;
import com.installshield.wizard.NonsecureWizardInf;
import com.installshield.wizard.WizardLoader;
import com.installshield.wizard.service.AbstractServiceImplementor;
import com.installshield.wizard.service.AsynchronousOperation;
import com.installshield.wizard.service.MutableOperationState;
import com.installshield.wizard.service.OperationKey;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.ServiceFactory;
import com.installshield.wizard.service.WizardLog;
import com.installshield.wizard.service.WizardServices;
import com.installshield.wizard.service.WizardServicesImpl;
import com.installshield.wizard.service.exitcode.ExitCodeService;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizard.service.log.LogService;
import com.installshield.wizard.service.system.SystemUtilService;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import java.util.zip.ZipException;

public class PureJavaProductServiceImpl
extends AbstractServiceImplementor
implements ProductServiceImplementor,
Log {
    private Hashtable redirectedProductSources = new Hashtable();
    private Hashtable retainedProductBeanProperties = new Hashtable();
    private Hashtable retainedProductTreeProperties = new Hashtable();
    private RegistryService registryService = null;
    protected static final String REPLACE_NEWER = "InstallProduct_replaceNewerSO";
    protected static final String REPLACE_EXISTING = "InstallProduct_replaceExistingSO";
    protected static final String YES = "$L(com.installshield.wizard.i18n.WizardResources, yesWithMn)";
    protected static final String YES_TO_ALL = "$L(com.installshield.wizard.i18n.WizardResources, yesToAllWithMn)";
    protected static final String NO = "$L(com.installshield.wizard.i18n.WizardResources, noWithMn)";
    protected static final String NO_TO_ALL = "$L(com.installshield.wizard.i18n.WizardResources, noToAllWithMn)";
    protected static final String YES_RESPONSE = "yes";
    protected static final String YES_TO_ALL_RESPONSE = "yesToAll";
    protected static final String NO_RESPONSE = "no";
    protected static final String NO_TO_ALL_RESPONSE = "noToAll";
    static /* synthetic */ Class class$com$installshield$qjml$PropertyAccessible;
    static /* synthetic */ Class class$com$installshield$product$ProductTree;
    static /* synthetic */ Class class$com$installshield$product$Product;
    static /* synthetic */ Class class$com$installshield$product$ProductFeature;

    private void addLogSummary(LogSummary logSummary, int n, String string) throws ServiceException {
        this.getServices().setValue(this.createLogSummaryKey(n, string), logSummary);
    }

    private String appendLogFileToMsg(String string) {
        String string2 = new String(string);
        try {
            LogService logService = (LogService)this.getServices().getService("logService");
            String string3 = logService.getLogOutput();
            if (string3 != null && string3.length() > 0) {
                string2 = String.valueOf(string2) + "  ";
                string2 = String.valueOf(string2) + LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.seeLogFile", new String[]{string3});
            }
        }
        catch (ServiceException serviceException) {}
        return string2;
    }

    private boolean canContinueInstall(int n) {
        return n == 0 || n == 1;
    }

    protected boolean canDeleteUninstaller(ProductTree productTree) {
        SoftwareObject softwareObject = (SoftwareObject)((Object)productTree.getRoot());
        return softwareObject.getInstallStatus() == 4;
    }

    public void checkNext(ProductBean productBean) throws OperationRejectedException {
        boolean bl = false;
        ProductTree productTree = productBean.getProductTree();
        if (productBean instanceof ProductComponent || productBean instanceof ProductComponentReference) {
            productTree.removeAllChildren(productBean);
            bl = true;
        }
        while (!bl) {
            int n = 0;
            while (n < productTree.getChildCount(productBean)) {
                ProductBean productBean2 = productTree.getChild(productBean, n);
                this.checkNext(productBean2);
                ++n;
            }
            bl = true;
        }
    }

    private boolean childrenInstalled(SoftwareObject softwareObject, ProductTree productTree) {
        boolean bl = false;
        boolean bl2 = false;
        SoftwareObject softwareObject2 = null;
        SoftwareObjectReference softwareObjectReference = null;
        ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createChildComponentIterator((ProductBean)((Object)softwareObject), true, false);
        ProductBean productBean = productTreeIterator.getNext(productTreeIterator.begin());
        while (!bl && productBean != productTreeIterator.end()) {
            if (productBean instanceof SoftwareObject) {
                softwareObject2 = (SoftwareObject)((Object)productBean);
            } else if (productBean instanceof SoftwareObjectReference) {
                softwareObjectReference = (SoftwareObjectReference)productBean;
                softwareObject2 = productTree.resolveKey(softwareObjectReference.getKey());
            }
            if (softwareObject2 != null) {
                boolean bl3 = bl = softwareObject2.getInstallStatus() == 3;
                if (!bl2) {
                    bl2 = softwareObject2.getInstallStatus() != 0;
                }
            }
            productBean = productTreeIterator.getNext(productBean);
        }
        return bl2 ? bl : true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private int compareKeyVersions(SoftwareObject softwareObject, SoftwareObject softwareObject2) throws OperationRejectedException {
        return softwareObject.getKey().getVersion().compareTo(softwareObject2.getKey().getVersion());
    }

    private int compareKeys(SoftwareObject softwareObject, SoftwareObject softwareObject2) throws OperationRejectedException {
        return softwareObject.getKey().compareTo(softwareObject2.getKey());
    }

    protected void configureUninstallerForCreation(ProductTree productTree) {
        UninstallerArchive uninstallerArchive = productTree.getUninstallerArchive();
        String string = productTree.getInstallLocation(uninstallerArchive);
        File file = new File(string);
        String string2 = uninstallerArchive.getInstallLocation();
        int n = 2;
        while (file.exists() && file.isDirectory()) {
            file = new File(String.valueOf(string) + n);
            string2 = String.valueOf(uninstallerArchive.getInstallLocation()) + n;
            ++n;
        }
        uninstallerArchive.setInstallLocation(string2);
    }

    protected void configureWizardLogForInstall(ProductTree productTree) {
        if (productTree.getLogFile() != null && productTree.getLogFile().trim().length() > 0) {
            WizardLog wizardLog = this.getServices().getWizardLog();
            String string = FileUtils.createFileName(productTree.getInstallLocation(productTree.getRoot()), productTree.getLogFile());
            wizardLog.copyLogOutput(string, true);
            wizardLog.setLogOutput(string);
        }
    }

    private void copyProductBeanProperty(ProductBean productBean, ProductBean productBean2, String string) throws ServiceException {
        Object object = this.getProductBeanProperty(productBean, string);
        if (object == null) {
            return;
        }
        Object object2 = null;
        boolean bl = false;
        Class<?> clazz = object.getClass();
        Method method = null;
        try {
            method = clazz.getMethod("clone", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (object instanceof Cloneable && method != null) {
            try {
                object2 = method.invoke(object, null);
                bl = true;
            }
            catch (Exception exception) {}
        }
        if (!bl && object instanceof PropertyAccessible) {
            try {
                object2 = QJML.clone(object, class$com$installshield$qjml$PropertyAccessible != null ? class$com$installshield$qjml$PropertyAccessible : (class$com$installshield$qjml$PropertyAccessible = PureJavaProductServiceImpl.class$("com.installshield.qjml.PropertyAccessible")));
                bl = true;
            }
            catch (Exception exception) {
                throw new ServiceException(315, "Unable to clone property " + string + " - " + exception);
            }
        }
        if (!bl) {
            object2 = object;
        }
        try {
            this.setInternalProductBeanProperty(productBean2, string, object2);
        }
        catch (Exception exception) {
            throw new ServiceException(315, "Unable to set a property value while copying the product tree - " + exception);
        }
    }

    private void createActiveNodeTable(ProductBean productBean, ProductTree productTree, Hashtable hashtable, Vector vector, ProductActionSupport productActionSupport, int n) throws ServiceException {
        StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(productBean, true);
        SoftwareObjectTreeIterator softwareObjectTreeIterator = new SoftwareObjectTreeIterator(standardProductTreeIterator);
        ProductBean productBean2 = softwareObjectTreeIterator.getNext(softwareObjectTreeIterator.begin());
        while (productBean2 != null && productBean2 != softwareObjectTreeIterator.end()) {
            if (this.installStatusMet(productBean2, n)) {
                SoftwareObject softwareObject = null;
                SoftwareObjectReference softwareObjectReference = null;
                if (productBean2 instanceof SoftwareObject) {
                    softwareObject = (SoftwareObject)((Object)productBean2);
                } else if (productBean2 instanceof SoftwareObjectReference && (softwareObject = productTree.resolveKey((softwareObjectReference = (SoftwareObjectReference)productBean2).getKey())) != null && !hashtable.containsKey(softwareObject.getKey())) {
                    this.createActiveNodeTable((ProductBean)((Object)softwareObject), productTree, hashtable, vector, productActionSupport, n);
                }
                if (softwareObject != null && !hashtable.containsKey(softwareObject.getKey())) {
                    hashtable.put(softwareObject.getKey(), new Node((ProductBean)((Object)softwareObject)));
                    vector.addElement(softwareObject.getKey());
                }
            }
            productBean2 = softwareObjectTreeIterator.getNext(productBean2);
        }
    }

    private InstallCheck[] createChecks(String string) {
        DiskSpaceCheck diskSpaceCheck = new DiskSpaceCheck();
        DependenciesCheck dependenciesCheck = new DependenciesCheck();
        UpdateCheck updateCheck = new UpdateCheck();
        PatchCheck patchCheck = new PatchCheck();
        PatchTargetCheck patchTargetCheck = new PatchTargetCheck();
        InstallCheck[] installCheckArray = this.getAdditionalChecks(string);
        if (installCheckArray == null) {
            installCheckArray = new InstallCheck[]{};
        }
        InstallCheck[] installCheckArray2 = new InstallCheck[installCheckArray.length + 5];
        installCheckArray2[0] = diskSpaceCheck;
        installCheckArray2[1] = dependenciesCheck;
        installCheckArray2[2] = updateCheck;
        installCheckArray2[3] = patchCheck;
        installCheckArray2[4] = patchTargetCheck;
        int n = 0;
        while (n < installCheckArray.length) {
            installCheckArray2[n + 5] = installCheckArray[n];
            ++n;
        }
        return installCheckArray2;
    }

    private String createLogSummaryKey(int n, String string) {
        return "productService.logSummary(" + n + ", " + string;
    }

    protected ProductActionSupport createProductActionSupport(ArchiveWriter archiveWriter, MutableOperationState mutableOperationState, UninstallerArchive uninstallerArchive) {
        return new ProductActionSupport(archiveWriter, mutableOperationState, uninstallerArchive);
    }

    private Hashtable createRequiredBeansTable(ProductTree productTree) {
        Hashtable hashtable = new Hashtable();
        StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(productTree);
        ProductBean productBean = standardProductTreeIterator.getNext(standardProductTreeIterator.begin());
        while (productBean != null && productBean != standardProductTreeIterator.end()) {
            if (productBean instanceof SoftwareObject) {
                boolean bl;
                try {
                    bl = this.isInstalled(productBean);
                }
                catch (Exception exception) {
                    if (System.getProperty("is.debug") != null) {
                        exception.printStackTrace();
                    }
                    boolean bl2 = bl = ((SoftwareObject)((Object)productBean)).getInstallStatus() == 3;
                }
                if (bl) {
                    SoftwareObject softwareObject = (SoftwareObject)((Object)productBean);
                    SoftwareObjectReference[] softwareObjectReferenceArray = softwareObject.getRequired();
                    int n = 0;
                    while (n < softwareObjectReferenceArray.length) {
                        SoftwareObjectKey softwareObjectKey = softwareObjectReferenceArray[n].getKey();
                        SoftwareObject softwareObject2 = productTree.resolveKey(softwareObjectKey);
                        if (softwareObject2 != null && softwareObject2 instanceof GenericSoftwareObject) {
                            String string = ((GenericSoftwareObject)softwareObject2).getBeanId();
                            if (!hashtable.containsKey(string)) {
                                hashtable.put(string, new Hashtable());
                            }
                            Hashtable hashtable2 = (Hashtable)hashtable.get(string);
                            hashtable2.put(productBean.getBeanId(), new Boolean(softwareObject.isActiveForUninstall()));
                        }
                        ++n;
                    }
                }
            }
            productBean = standardProductTreeIterator.getNext(productBean);
        }
        return hashtable;
    }

    protected boolean deleteUninstaller(ProductTree productTree) {
        String string = ((GenericSoftwareObject)productTree.getRoot()).getUninstaller();
        try {
            SystemUtilService systemUtilService = (SystemUtilService)this.getServices().getService("systemUtilService");
            systemUtilService.deleteFileOnExit(string);
            return true;
        }
        catch (ServiceException serviceException) {
            return false;
        }
    }

    protected void executeCheck(InstallCheck installCheck, String string, WizardServices wizardServices, LogSummary logSummary) {
        WizardServicesLog wizardServicesLog = new WizardServicesLog(this.getServices());
        this.getServices().addLogListener(logSummary);
        installCheck.execute(string, wizardServices, wizardServicesLog);
        this.getServices().removeLogListener(logSummary);
    }

    public Properties executeChecks(String string, String[] stringArray, String string2) {
        InstallCheck[] installCheckArray;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = 0;
        while (n < stringArray.length) {
            hashtable.put(stringArray[n], "");
            ++n;
        }
        LogSummary logSummary = new LogSummary(" ");
        try {
            installCheckArray = this.getChecksForProduct(string);
            int n2 = 0;
            while (n2 < installCheckArray.length) {
                if (hashtable.containsKey(installCheckArray[n2].getName())) {
                    this.executeCheck(installCheckArray[n2], string, this.getServices(), logSummary);
                }
                ++n2;
            }
        }
        catch (ServiceException serviceException) {
            installCheckArray = new InstallCheck[]{};
            logSummary.eventLogged(this, "err", serviceException);
        }
        Properties properties = new Properties();
        ((Hashtable)properties).put("summary.msg", this.getLogSummaryMsg(logSummary, string, string2, 1));
        ((Hashtable)properties).put("summary.error.count", String.valueOf(logSummary.errorCount()));
        ((Hashtable)properties).put("summary.warning.count", String.valueOf(logSummary.warningCount()));
        ((Hashtable)properties).put("summary.message.count", String.valueOf(logSummary.messageCount()));
        int n3 = 0;
        while (n3 < installCheckArray.length) {
            ((Hashtable)properties).put(String.valueOf(installCheckArray[n3].getName()) + "." + "passed", new Integer(installCheckArray[n3].getStatus()));
            ++n3;
        }
        return properties;
    }

    protected boolean featureIsVisible(ProductFeature productFeature) {
        boolean bl = productFeature.isVisible();
        if (bl) {
            boolean bl2 = false;
            ProductBean productBean = productFeature;
            while (bl && !bl2) {
                ProductBean productBean2 = productBean.getProductTree().getParent(productBean);
                if (productBean2 != null && productBean2 instanceof ProductFeature) {
                    bl = ((ProductFeature)productBean2).isVisible();
                } else if (productBean2 != null && productBean2 instanceof Product) {
                    bl = ((Product)productBean2).isVisible();
                } else {
                    bl2 = true;
                }
                productBean = productBean2;
            }
        }
        return bl;
    }

    private ProductBean findProductBean(ProductBean productBean, String string) {
        ProductBean productBean2 = null;
        StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(productBean);
        ProductBean productBean3 = standardProductTreeIterator.getNext(standardProductTreeIterator.begin());
        while (productBean2 == null && productBean3 != standardProductTreeIterator.end()) {
            if (productBean3.getBeanId().equals(string)) {
                productBean2 = productBean3;
            }
            productBean3 = standardProductTreeIterator.getNext(productBean3);
        }
        return productBean2;
    }

    private String getAbsoluteInstallLocation(ProductBean productBean) {
        return productBean.getProductTree().getInstallLocation(productBean);
    }

    protected InstallCheck[] getAdditionalChecks(String string) {
        return null;
    }

    private ProductTreeSet getCachedProductTreeSet(String string) {
        return (ProductTreeSet)this.getServices().getValue(string);
    }

    private InstallCheck[] getChecksForProduct(String string) throws ServiceException {
        InstallCheck[] installCheckArray;
        Hashtable<String, InstallCheck[]> hashtable = (Hashtable<String, InstallCheck[]>)this.getServices().getValue("checks");
        if (hashtable == null) {
            hashtable = new Hashtable<String, InstallCheck[]>();
            this.getServices().setValue("checks", hashtable);
        }
        if ((installCheckArray = (InstallCheck[])hashtable.get(string)) == null) {
            installCheckArray = this.createChecks(string);
            hashtable.put(string, installCheckArray);
        }
        return installCheckArray;
    }

    public SoftwareObject[] getCurrentSoftwareObjectInstallSequence(String string) throws ServiceException {
        ProductTree productTree = this.getProductTree(string);
        Hashtable hashtable = InstallableObjectVisitor.createVirtualActiveStates(productTree.getRoot(), null, this.getRegistryService(), null, false);
        ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createVirtualInstallableComponentIterator(productTree.getRoot(), null, null, false, false, hashtable);
        Vector<SoftwareObject> vector = new Vector<SoftwareObject>();
        ProductBean productBean = productTreeIterator.getNext(productTreeIterator.begin());
        while (productBean != null && productBean != productTreeIterator.end()) {
            if (productBean instanceof SoftwareObject) {
                vector.addElement((SoftwareObject)((Object)productBean));
            }
            productBean = productTreeIterator.getNext(productBean);
        }
        Object[] objectArray = new SoftwareObject[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private Class getFilterClass(Properties properties) {
        String string = (String)((Hashtable)properties).get("filter.class");
        if (string != null) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    public String[] getInstallCheckNames(String string) throws ServiceException {
        InstallCheck[] installCheckArray = this.getChecksForProduct(string);
        String[] stringArray = new String[installCheckArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = installCheckArray[n].getName();
            ++n;
        }
        return stringArray;
    }

    private LogSummary getLogSummary(int n, String string) throws ServiceException {
        return (LogSummary)this.getServices().getValue(this.createLogSummaryKey(n, string));
    }

    private String getLogSummaryMsg(LogSummary logSummary, String string, String string2, int n) {
        Object object;
        if (logSummary == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.noSummary"));
            if (string2.equals("html")) {
                stringBuffer.append("<p>");
            } else if (string2.equals("html")) {
                stringBuffer.append("\n\n");
            }
            stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.invalidSummaryRequest"));
            return stringBuffer.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (logSummary.hasErrors()) {
            object = n == 4 ? "uninstallationError" : "installationError";
            stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", (String)object));
            if (string2.equals("html")) {
                stringBuffer.append("<ul>");
            } else if (string2.equals("text")) {
                stringBuffer.append("\n\n");
            }
            Enumeration enumeration = logSummary.errors();
            while (enumeration.hasMoreElements()) {
                if (string2.equals("html")) {
                    stringBuffer.append("<li>");
                } else if (string2.equals("text")) {
                    stringBuffer.append(" - ");
                }
                stringBuffer.append(enumeration.nextElement());
                if (!string2.equals("text")) continue;
                stringBuffer.append("\n");
            }
            if (string2.equals("html")) {
                stringBuffer.append("</ul>");
            }
        } else if (n == 5) {
            stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.installedWithoutErrorsContinueWizard", new String[]{"$P(displayName)"}));
        } else if (n == 6) {
            stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.uninstalledWithoutErrorsContinueWizard", new String[]{"$P(displayName)"}));
        } else {
            stringBuffer.append(logSummary.getDescription());
        }
        if (logSummary.hasWarnings()) {
            if (!logSummary.hasErrors() && n != 1) {
                stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.warningGeneratedH"));
            } else {
                if (string2.equals("text")) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.warningGenerated"));
            }
            if (string2.equals("html")) {
                stringBuffer.append("<ul>");
            } else if (string2.equals("text")) {
                stringBuffer.append("\n\n");
            }
            object = logSummary.warnings();
            while (object.hasMoreElements()) {
                if (string2.equals("html")) {
                    stringBuffer.append("<li>");
                } else if (string2.equals("text")) {
                    stringBuffer.append(" - ");
                }
                stringBuffer.append(object.nextElement());
                if (!string2.equals("text")) continue;
                stringBuffer.append("\n");
            }
            if (string2.equals("html")) {
                stringBuffer.append("</ul>");
            }
        }
        if (logSummary.hasMessages()) {
            if (!logSummary.hasErrors() && !logSummary.hasWarnings()) {
                stringBuffer.append(" ");
            } else if (string2.equals("text")) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.warningGenerated"));
            if (string2.equals("html")) {
                stringBuffer.append("<ul>");
            } else if (string2.equals("text")) {
                stringBuffer.append("\n\n");
            }
            object = logSummary.messages();
            while (object.hasMoreElements()) {
                if (string2.equals("html")) {
                    stringBuffer.append("<li>");
                } else if (string2.equals("text")) {
                    stringBuffer.append(" - ");
                }
                stringBuffer.append(object.nextElement());
                if (!string2.equals("text")) continue;
                stringBuffer.append("\n");
            }
            if (string2.equals("html")) {
                stringBuffer.append("</ul>");
            }
        }
        return stringBuffer.toString();
    }

    private String getMemoryDebugMessage(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JVM memory ");
        stringBuffer.append(string);
        stringBuffer.append(": free=");
        stringBuffer.append(Runtime.getRuntime().freeMemory());
        stringBuffer.append(" total=");
        stringBuffer.append(Runtime.getRuntime().totalMemory());
        return stringBuffer.toString();
    }

    private SoftwareObject getNewestSoftwareObject(SoftwareObject softwareObject, SoftwareObject softwareObject2) {
        SoftwareObject softwareObject3;
        block7: {
            softwareObject3 = softwareObject;
            if (softwareObject.getInstallStatus() == 3) break block7;
            try {
                RegistryService registryService = (RegistryService)this.getServices().getService("registryService");
                SoftwareObject softwareObject4 = softwareObject2 == null ? softwareObject : softwareObject2;
                boolean bl = false;
                SoftwareObject softwareObject5 = registryService.getNewestSoftwareObject(softwareObject.getKey().getUID());
                while (softwareObject5 != null && !bl) {
                    if (this.compareKeyVersions(softwareObject5, softwareObject4) == 0) {
                        if (softwareObject2 == null) {
                            bl = true;
                            continue;
                        }
                        softwareObject5 = registryService.getNextNewestSoftwareObject(softwareObject5);
                        continue;
                    }
                    if (this.compareKeyVersions(softwareObject5, softwareObject4) > 0) {
                        softwareObject5 = registryService.getNextNewestSoftwareObject(softwareObject5);
                        continue;
                    }
                    bl = true;
                }
                if (softwareObject5 != null) {
                    softwareObject3 = softwareObject5;
                }
            }
            catch (Exception exception) {
                this.logEvent(this, "err", exception);
            }
        }
        return softwareObject3;
    }

    protected AsynchronousOperation getOperation(OperationKey operationKey) throws ServiceException {
        return super.getOperation(operationKey);
    }

    protected Properties getPostInstallSummary(String string, String string2, int n) throws ServiceException {
        Properties properties = new Properties();
        ((Hashtable)properties).put("summary.msg", this.getLogSummaryMsg(this.getLogSummary(2, string), string, string2, n));
        return properties;
    }

    protected Properties getPostUninstallSummary(String string, String string2, int n) throws ServiceException {
        Properties properties = new Properties();
        ((Hashtable)properties).put("summary.msg", this.getLogSummaryMsg(this.getLogSummary(4, string), string, string2, n));
        return properties;
    }

    protected Properties getPreInstallSummary(String string, String string2) throws ServiceException {
        Properties properties = new Properties();
        ProductTree productTree = this.getProductTree(string);
        if (productTree.getRoot() instanceof Product) {
            ((Hashtable)properties).put("summary.msg", this.getProductInstallSummary(string, (Product)productTree.getRoot(), string2));
        }
        return properties;
    }

    protected Properties getPreUninstallSummary(String string, String string2) throws ServiceException {
        Properties properties = new Properties();
        ProductTree productTree = this.getProductTree(string);
        if (productTree.getRoot() instanceof Product) {
            ((Hashtable)properties).put("summary.msg", this.getProductUninstallSummary((Product)productTree.getRoot(), string2));
        }
        return properties;
    }

    protected ProductBean getProductBean(String string, String string2) throws ServiceException {
        ProductBean productBean = null;
        ProductTree productTree = this.getProductTree(string);
        if (string2 == null) {
            productBean = productTree.getRoot();
        } else {
            productBean = this.findProductBean(productTree.getRoot(), string2);
            if (productBean == null && productTree.getRoot() instanceof StaticSuite) {
                StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(productTree);
                ProductTypeTreeIterator productTypeTreeIterator = new ProductTypeTreeIterator((ProductTreeIterator)standardProductTreeIterator, class$com$installshield$product$Product != null ? class$com$installshield$product$Product : (class$com$installshield$product$Product = PureJavaProductServiceImpl.class$("com.installshield.product.Product")));
                ProductBean productBean2 = productTypeTreeIterator.getNext(productTypeTreeIterator.begin());
                while (productBean == null && productBean2 != productTypeTreeIterator.end()) {
                    String string3;
                    if (productBean2 != null && productBean2 instanceof Product && (string3 = StaticSuite.getSubProductReferenceId((Product)productBean2)) != null) {
                        productBean = this.findProductBean(productBean2, StaticSuite.resolveReferencedBeanId(string3, string2));
                    }
                    productBean2 = productTypeTreeIterator.getNext(productBean2);
                }
            }
        }
        if (productBean != null) {
            return productBean;
        }
        throw new ServiceException(315, "product bean " + string2 + " does not exist");
    }

    private Properties[] getProductBeanChildren(ProductTree productTree, String string, String[] stringArray, Properties properties) throws ServiceException {
        Class clazz;
        ProductTreeIterator productTreeIterator = string != null ? new StandardProductTreeIterator(productTree.getBean(string)) : new StandardProductTreeIterator(productTree);
        productTreeIterator = new ChildrenProductTreeIterator((FilteredProductTreeIterator)productTreeIterator);
        if (properties == null) {
            properties = new Properties();
        }
        if (this.useActiveFilter(properties)) {
            productTreeIterator = new ActiveProductTreeIterator((FilteredProductTreeIterator)productTreeIterator);
        }
        if (this.useConditionFilter(properties)) {
            productTreeIterator = new ConditionalProductTreeIterator((FilteredProductTreeIterator)productTreeIterator);
        }
        if ((clazz = this.getFilterClass(properties)) != null) {
            productTreeIterator = new ProductTypeTreeIterator(productTreeIterator, clazz);
        }
        ProductBean productBean = productTreeIterator.getNext(productTreeIterator.begin());
        Vector<ProductBean> vector = new Vector<ProductBean>();
        while (productBean != productTreeIterator.end()) {
            vector.addElement(productBean);
            productBean = productTreeIterator.getNext(productBean);
        }
        Object[] objectArray = new ProductBean[vector.size()];
        if (vector.size() > 0) {
            vector.copyInto(objectArray);
        }
        return this.getPropertiesFromProductBeans((ProductBean[])objectArray, stringArray);
    }

    public Properties[] getProductBeanChildren(String string, String string2, String[] stringArray, Properties properties) throws ServiceException {
        ProductTree productTree = this.getProductTree(string);
        return this.getProductBeanChildren(productTree, string2, stringArray, properties);
    }

    private String getProductBeanDisplayName(ProductBean productBean) {
        String string;
        if (productBean instanceof GenericSoftwareObject && (string = ((GenericSoftwareObject)productBean).getLocalizedDisplayName()) != null && string.trim().length() > 0) {
            return string;
        }
        return productBean.getDisplayName();
    }

    private Object getProductBeanProperty(ProductBean productBean, String string) throws ServiceException {
        Object object = this.getSpecialProductBeanProperty(productBean, string);
        if (object == null) {
            try {
                object = PropertyReadParser.processReadExpression(productBean, string);
            }
            catch (Exception exception) {
                throw new ServiceException(315, "could not read property " + string + " for bean " + productBean.getBeanId() + " because the following error occurred: " + exception);
            }
        }
        return object;
    }

    public Object getProductBeanProperty(String string, String string2, String string3) throws ServiceException {
        ProductBean productBean = this.getProductBean(string, string2);
        return this.getProductBeanProperty(productBean, string3);
    }

    protected String getProductInstallSummary(String string, Product product, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        SoftwareObject[] softwareObjectArray = null;
        int n = 0;
        stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.beInstalledInDir", new String[]{this.getProductBeanDisplayName(product)}));
        if (string2.equals("html")) {
            stringBuffer.append("<blockquote>");
        } else if (string2.equals("text")) {
            stringBuffer.append("\n\n   ");
        }
        stringBuffer.append(product.getProductTree().getInstallLocation(product));
        if (string2.equals("html")) {
            stringBuffer.append("</blockquote>");
        }
        ProductTreeIterator productTreeIterator = null;
        ProductBean productBean = null;
        if (product instanceof DynamicSuite) {
            bl = true;
        }
        if (bl) {
            productTreeIterator = ProductTreeIteratorFactory.createInstallableProductIterator(product, new ProductTreeSource(this.getServices()), this);
            productBean = productTreeIterator.getNext(productTreeIterator.begin());
        } else {
            try {
                softwareObjectArray = this.getCurrentSoftwareObjectInstallSequence(string);
                n = softwareObjectArray.length;
            }
            catch (ServiceException serviceException) {
                this.getServices().logEvent(this, "err", serviceException);
            }
        }
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        while (bl && productBean != productTreeIterator.end() || n2 < n) {
            if (!bl) {
                productBean = (ProductBean)((Object)softwareObjectArray[n2]);
            }
            if ((bl && productBean instanceof Product || !bl && (productBean instanceof ProductFeature || productBean instanceof Product && productBean != productBean.getProductTree().getRoot())) && (!(productBean instanceof ProductFeature) && !(productBean instanceof Product) || productBean instanceof ProductFeature && this.featureIsVisible((ProductFeature)productBean) || productBean instanceof Product && this.productIsVisible((Product)productBean))) {
                int n3;
                if (!bl2) {
                    if (string2.equals("text")) {
                        stringBuffer.append("\n\n");
                    }
                    stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.withFeatures"));
                    if (string2.equals("html")) {
                        stringBuffer.append("<blockquote>");
                    }
                    bl2 = true;
                }
                if (bl3) {
                    if (string2.equals("html")) {
                        stringBuffer.append("<br>");
                    } else if (string2.equals("text")) {
                        stringBuffer.append("\n");
                    }
                }
                if (string2.equals("text")) {
                    stringBuffer.append("   ");
                }
                int n4 = product.getProductTree().getLevel(productBean);
                if (string2.equals("html")) {
                    n3 = 1;
                    while (n3 < n4) {
                        stringBuffer.append("&nbsp;&nbsp;&nbsp;");
                        ++n3;
                    }
                    stringBuffer.append(this.getProductBeanDisplayName(productBean));
                } else if (string2.equals("text")) {
                    n3 = 1;
                    while (n3 < n4) {
                        stringBuffer.append("\t");
                        ++n3;
                    }
                    stringBuffer.append(this.getProductBeanDisplayName(productBean));
                }
                bl3 = true;
            }
            if (bl) {
                productBean = productTreeIterator.getNext(productBean);
                continue;
            }
            ++n2;
        }
        if (!bl2) {
            if (string2.equals("text")) {
                stringBuffer.append("\n\n");
            } else if (string2.equals("html")) {
                stringBuffer.append("<blockquote>");
            }
            bl2 = true;
        }
        if (bl2) {
            if (string2.equals("html")) {
                stringBuffer.append("</blockquote>");
            } else if (string2.equals("text")) {
                stringBuffer.append("\b\n");
            }
        }
        stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.forTotalSize"));
        if (string2.equals("html")) {
            stringBuffer.append("<blockquote>");
        } else if (string2.equals("text")) {
            stringBuffer.append("\n\n   ");
        }
        try {
            RequiredBytesTable requiredBytesTable = new RequiredBytes().getEstimatedRequiredBytes(product, product.getProductTree(), new ProductTreeSource(this.getServices()), this.getRegistryService(), this);
            String string3 = FileUtils.formatSizeAsBytes(requiredBytesTable.getTotalBytes());
            stringBuffer.append(string3);
        }
        catch (ServiceException serviceException) {
            if (serviceException.getErrorCode() == 305) {
                this.getServices().logEvent(this, "wrn", "Total size required is not supported by current file service implementation.");
            } else {
                this.getServices().logEvent(this, "err", serviceException);
            }
            stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.totalSizeNotSupported"));
        }
        if (string2.equals("html")) {
            stringBuffer.append("</blockquote>");
        }
        return stringBuffer.toString();
    }

    public String[] getProductLocales(String string) throws ServiceException {
        Object object;
        Vector<Object[]> vector = new Vector<Object[]>();
        ProductBean productBean = this.getProductTree(string).getRoot();
        ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createFindLocalesTreeIterator(productBean);
        ProductBean productBean2 = productTreeIterator.getNext(productTreeIterator.begin());
        while (productBean2 != productTreeIterator.end()) {
            SoftwareObject softwareObject;
            object = null;
            if (productBean2 instanceof SoftwareObject) {
                object = ((SoftwareObject)((Object)productBean2)).getLocale();
            } else if (productBean2 instanceof SoftwareObjectReference && (softwareObject = productBean2.getProductTree().resolveKey(((SoftwareObjectReference)productBean2).getKey())) != null) {
                object = softwareObject.getLocale();
            }
            if (object != null && !vector.contains(object)) {
                vector.addElement((Object[])object);
            }
            productBean2 = productTreeIterator.getNext(productBean2);
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public Properties getProductSummary(String string, int n, String string2) throws ServiceException {
        if (n == 1) {
            return this.getPreInstallSummary(string, string2);
        }
        if (n == 2 || n == 5) {
            return this.getPostInstallSummary(string, string2, n);
        }
        if (n == 3) {
            return this.getPreUninstallSummary(string, string2);
        }
        if (n == 4 || n == 6) {
            return this.getPostUninstallSummary(string, string2, n);
        }
        throw new ServiceException(399, "illegal summary type " + n);
    }

    public ProductTree getProductTree(String string) throws ServiceException {
        ProductTreeSet productTreeSet = this.getCachedProductTreeSet(string);
        if (productTreeSet == null) {
            try {
                productTreeSet = new ProductTreeSet(this.loadProductTree(string, false));
                ProductTree productTree = productTreeSet.getInstallTree();
                GenericSoftwareObject genericSoftwareObject = (GenericSoftwareObject)productTree.getRoot();
                SoftwareObject softwareObject = this.getNewestSoftwareObject(genericSoftwareObject, null);
                boolean bl = softwareObject.getKey().equalsWithInstance(genericSoftwareObject.getKey());
                while (!(bl || softwareObject.getKey().equalsWithInstance(genericSoftwareObject.getKey()) || this.isUninstallerInfoCurrent(productTreeSet.getUninstallTree(), softwareObject.getKey()))) {
                    UninstallerInfo uninstallerInfo = this.getUninstallerInfo(softwareObject.getKey());
                    if (uninstallerInfo.getUninstallerStatus() == 3) {
                        this.obtainUninstaller(uninstallerInfo);
                    }
                    if (uninstallerInfo.getUninstallerStatus() == 2) {
                        String string2 = null;
                        try {
                            this.obtainDataResourceLocation(uninstallerInfo);
                            string2 = uninstallerInfo.getAbsoluteDataResourceLocation();
                            this.getServices().putResourceLocation(string2);
                            ProductTree productTree2 = this.loadProductTree(string, true);
                            this.redirectedProductSources.put(string, string2);
                            this.updateUninstaller(productTree2, uninstallerInfo);
                            productTreeSet.setUninstallTree(productTree2);
                            genericSoftwareObject.setInstallLocation(softwareObject.getInstallLocation());
                            bl = true;
                        }
                        catch (Exception exception) {
                            this.logEvent(this, "err", exception);
                            if (string2 != null) {
                                this.getServices().removeResourceLocation(string2);
                            }
                            this.redirectedProductSources.remove(string);
                            softwareObject = this.getNewestSoftwareObject(genericSoftwareObject, softwareObject);
                        }
                        continue;
                    }
                    softwareObject = this.getNewestSoftwareObject(genericSoftwareObject, softwareObject);
                }
                this.setCachedProductTreeSet(string, productTreeSet);
                this.restoreProductTreeProperties(string);
                this.restoreProductBeanProperties(string);
            }
            catch (IOException iOException) {
                throw new ServiceException(315, "cannot load product " + string + ": " + iOException);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new ServiceException(exception);
            }
        }
        return productTreeSet.getInstallTree();
    }

    public Object getProductTreeProperty(String string, String string2) throws ServiceException {
        ProductTree productTree = this.getProductTree(string);
        try {
            return PropertyReadParser.processReadExpression(productTree, string2);
        }
        catch (Exception exception) {
            throw new ServiceException(315, "could not read property " + string2 + " for product tree " + "because the following error occurred: " + exception);
        }
    }

    public String getProductTreeRoot(String string) throws ServiceException {
        ProductTree productTree = this.getProductTree(string);
        return productTree.getRoot().getBeanId();
    }

    protected String getProductUninstallSummary(Product product, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.beUninstalledFromDir", new String[]{this.getProductBeanDisplayName(product)}));
        if (string.equals("html")) {
            stringBuffer.append("<blockquote>");
        } else if (string.equals("text")) {
            stringBuffer.append("\n\n   ");
        }
        stringBuffer.append(product.getProductTree().getInstallLocation(product));
        if (string.equals("html")) {
            stringBuffer.append("</blockquote>");
        }
        StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(product);
        ProductTypeTreeIterator productTypeTreeIterator = new ProductTypeTreeIterator((ProductTreeIterator)standardProductTreeIterator, new Class[]{class$com$installshield$product$Product != null ? class$com$installshield$product$Product : (class$com$installshield$product$Product = PureJavaProductServiceImpl.class$("com.installshield.product.Product")), class$com$installshield$product$ProductFeature != null ? class$com$installshield$product$ProductFeature : (class$com$installshield$product$ProductFeature = PureJavaProductServiceImpl.class$("com.installshield.product.ProductFeature"))}, true);
        ProductBean productBean = productTypeTreeIterator.getNext(productTypeTreeIterator.begin());
        boolean bl = false;
        while (productBean != productTypeTreeIterator.end()) {
            if ((productBean instanceof ProductFeature || productBean instanceof Product && productBean != productBean.getProductTree().getRoot()) && this.installStatusMet(productBean, 3) && this.isActiveForUninstall(productBean) && (!(productBean instanceof ProductFeature) && !(productBean instanceof Product) || productBean instanceof ProductFeature && this.featureIsVisible((ProductFeature)productBean) || productBean instanceof Product && this.productIsVisible((Product)productBean))) {
                int n;
                if (!bl) {
                    if (string.equals("text")) {
                        stringBuffer.append("\n\n");
                    }
                    stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.withFeatures"));
                    if (string.equals("html")) {
                        stringBuffer.append("<blockquote>");
                    }
                    bl = true;
                }
                ProductTree productTree = product.getProductTree();
                int n2 = productTree.getLevel(productBean);
                if (string.equals("html")) {
                    n = 1;
                    while (n < n2) {
                        stringBuffer.append("&nbsp;&nbsp;&nbsp;");
                        ++n;
                    }
                    stringBuffer.append(this.getProductBeanDisplayName(productBean));
                } else if (string.equals("text")) {
                    n = 1;
                    while (n < n2) {
                        stringBuffer.append("\t");
                        ++n;
                    }
                    stringBuffer.append(this.getProductBeanDisplayName(productBean));
                }
                if (string.equals("html")) {
                    stringBuffer.append("<br>");
                } else if (string.equals("text")) {
                    stringBuffer.append("\n");
                }
            }
            productBean = productTypeTreeIterator.getNext(productBean);
        }
        if (bl && string.equals("html")) {
            stringBuffer.append("</blockquote>");
        }
        return stringBuffer.toString();
    }

    private Properties[] getPropertiesFromProductBeans(ProductBean[] productBeanArray, String[] stringArray) {
        Properties[] propertiesArray = new Properties[productBeanArray.length];
        int n = 0;
        while (n < productBeanArray.length) {
            propertiesArray[n] = new Properties();
            ProductBean productBean = productBeanArray[n];
            int n2 = 0;
            while (n2 < stringArray.length) {
                try {
                    Object object = this.getProductBeanProperty(productBean, stringArray[n2]);
                    if (object != null) {
                        ((Hashtable)propertiesArray[n]).put(stringArray[n2], object);
                    }
                }
                catch (ServiceException serviceException) {
                    this.logEvent(this, "err", "Could not read bean property " + stringArray[n2] + " of bean " + productBean + ": " + serviceException.getMessage());
                }
                ++n2;
            }
            ++n;
        }
        return propertiesArray;
    }

    private PropertyDescriptor getPropertyDescriptor(Object object, String string) throws IntrospectionException, ServiceException {
        BeanInfo beanInfo = ISIntrospector.getBeanInfo(object.getClass());
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n = 0;
        while (n < propertyDescriptorArray.length) {
            if (propertyDescriptorArray[n].getName().equals(string)) {
                return propertyDescriptorArray[n];
            }
            ++n;
        }
        throw new ServiceException(315, String.valueOf(object.toString()) + " does not have a property named " + string + " (note that property names are case sensitive)");
    }

    private Method getReadMethod(ProductBean productBean, String string) throws IntrospectionException, ServiceException {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(productBean, string);
        if (propertyDescriptor != null) {
            return propertyDescriptor.getReadMethod();
        }
        return null;
    }

    private RegistryService getRegistryService() throws ServiceException {
        if (this.registryService == null) {
            this.registryService = (RegistryService)this.getServices().getService("registryService");
        }
        return this.registryService;
    }

    public Properties[] getRequiredByFeatures(String string, String string2, boolean bl) throws ServiceException {
        Object object;
        ProductTree productTree = this.getProductTree(string);
        ProductBean productBean = this.getProductBean(string, string2);
        ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createRequiringSoftwareObjectIterator(productTree.getRoot(), (GenericSoftwareObject)productBean, bl);
        ProductBean productBean2 = productTreeIterator.getNext(productTreeIterator.begin());
        Vector<Object> vector = new Vector<Object>();
        while (productBean2 != productTreeIterator.end()) {
            if (productBean2 instanceof ProductFeature && !vector.contains(productBean2)) {
                vector.addElement(productBean2);
            } else if ((productBean2 instanceof ProductComponent || productBean2 instanceof ProductComponentReference) && (object = productTree.getParent(productBean2)) instanceof ProductFeature && !vector.contains(object)) {
                vector.addElement(object);
            }
            productBean2 = productTreeIterator.getNext(productBean2);
        }
        object = new ProductBean[vector.size()];
        if (vector.size() > 0) {
            vector.copyInto((Object[])object);
        }
        return this.getPropertiesFromProductBeans((ProductBean[])object, new String[]{"beanId", "displayName", "active", "installStatus"});
    }

    protected RequiredBytesTable getRequiredBytes(ProductTree productTree, ProductBean productBean) throws ServiceException {
        return new RequiredBytes().getEstimatedRequiredBytes(productBean, productTree, new ProductTreeSource(this.getServices()), this.getRegistryService(), this);
    }

    public RequiredBytesTable getRequiredBytes(String string, String string2) throws ServiceException {
        ProductBean productBean = null;
        productBean = this.getProductBean(string, string2);
        if (productBean == null) {
            return new RequiredBytesTable();
        }
        return this.getRequiredBytes(this.getProductTree(string), productBean);
    }

    private void getRequiredFeatures(ProductTree productTree, ProductBean productBean, Vector vector, boolean bl) {
        ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createFeaturesRequiredBySoftwareObjectIterator((GenericSoftwareObject)productBean, bl);
        ProductBean productBean2 = productTreeIterator.getNext(productTreeIterator.begin());
        while (productBean2 != productTreeIterator.end()) {
            SoftwareObject softwareObject;
            ProductFeature productFeature = null;
            if (productBean2 instanceof ProductFeature) {
                productFeature = (ProductFeature)productBean2;
            } else if (productBean2 instanceof SoftwareObjectReference && (softwareObject = productTree.resolveKey(((SoftwareObjectReference)productBean2).getKey())) instanceof ProductFeature) {
                productFeature = (ProductFeature)softwareObject;
            }
            if (productFeature != null && !vector.contains(productFeature)) {
                vector.addElement(productFeature);
            }
            productBean2 = productTreeIterator.getNext(productBean2);
        }
    }

    public Properties[] getRequiredFeatures(String string, String string2, boolean bl) throws ServiceException {
        Object object;
        ProductTree productTree = this.getProductTree(string);
        ProductBean productBean = this.getProductBean(string, string2);
        Vector vector = new Vector();
        boolean bl2 = true;
        if (productBean instanceof Product) {
            bl2 = false;
        }
        ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createSoftwareObjectIterator(productBean);
        ProductBean productBean2 = productTreeIterator.getNext(productTreeIterator.begin());
        while (productBean2 != productTreeIterator.end()) {
            if (productBean2 instanceof SoftwareObjectReference) {
                object = productTree.resolveKey(((SoftwareObjectReference)productBean2).getKey());
                if (object instanceof GenericSoftwareObject) {
                    this.getRequiredFeatures(productTree, (GenericSoftwareObject)object, vector, bl);
                }
            } else if (bl2 || !(productBean2 instanceof ProductFeature)) {
                this.getRequiredFeatures(productTree, productBean2, vector, bl);
            }
            productBean2 = productTreeIterator.getNext(productBean2);
        }
        object = new ProductBean[vector.size()];
        if (vector.size() > 0) {
            vector.copyInto((Object[])object);
        }
        return this.getPropertiesFromProductBeans((ProductBean[])object, new String[]{"beanId", "displayName", "active", "installStatus"});
    }

    public ProductTree getSoftwareObjectTree(String string) throws ServiceException {
        try {
            ProductTree productTree = (ProductTree)QJML.clone(this.getProductTree(string), class$com$installshield$product$ProductTree != null ? class$com$installshield$product$ProductTree : (class$com$installshield$product$ProductTree = PureJavaProductServiceImpl.class$("com.installshield.product.ProductTree")));
            PureJavaProductServiceImpl.initializeTree(productTree, this.getServices(), false);
            this.checkNext(productTree.getRoot());
            return productTree;
        }
        catch (Exception exception) {
            throw new ServiceException(exception);
        }
    }

    public ProductTree getSoftwareObjectTree(String string, String[] stringArray) throws ServiceException {
        ProductTree productTree = new ProductTree();
        ProductTree productTree2 = this.getProductTree(string);
        StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(productTree2);
        ImmutableConditionalProductTreeIterator immutableConditionalProductTreeIterator = new ImmutableConditionalProductTreeIterator(standardProductTreeIterator);
        SelectedLocalesIterator selectedLocalesIterator = new SelectedLocalesIterator(immutableConditionalProductTreeIterator, LocaleUtils.parseLocales(productTree2.getSelectedLocales()));
        SoftwareObjectTreeIterator softwareObjectTreeIterator = new SoftwareObjectTreeIterator(selectedLocalesIterator);
        Stack<ProductComponent> stack = new Stack<ProductComponent>();
        ProductBean productBean = softwareObjectTreeIterator.getNext(softwareObjectTreeIterator.begin());
        while (productBean != null && productBean != softwareObjectTreeIterator.end()) {
            ProductBean productBean2 = null;
            if (productBean instanceof ProductComponent) {
                productBean2 = new ProductComponent();
            } else if (productBean instanceof ProductComponentReference) {
                productBean2 = new ProductComponentReference();
            } else if (productBean instanceof ProductFeature) {
                productBean2 = new ProductFeature();
            } else if (productBean instanceof StaticSuite) {
                productBean2 = new StaticSuite();
            } else if (productBean instanceof Product) {
                productBean2 = new Product();
            }
            if (productBean2 != null) {
                productBean2.setBeanId(productBean.getBeanId());
                if (stringArray != null) {
                    int n = 0;
                    while (n < stringArray.length) {
                        this.copyProductBeanProperty(productBean, productBean2, stringArray[n]);
                        ++n;
                    }
                }
                ProductBean productBean3 = null;
                ProductBean productBean4 = productTree2.getParent(productBean);
                if (productBean4 != null) {
                    productBean3 = (ProductBean)stack.peek();
                    while (productBean3 != null && !productBean3.getBeanId().equals(productBean4.getBeanId())) {
                        stack.pop();
                        productBean3 = (ProductBean)stack.peek();
                    }
                }
                try {
                    if (productBean4 == null) {
                        productTree.setRoot(productBean2);
                    } else {
                        productTree.add(productBean3, productBean2);
                    }
                }
                catch (OperationRejectedException operationRejectedException) {
                    operationRejectedException.printStackTrace();
                    throw new ServiceException(315, "unable to clone product tree " + string + " - " + operationRejectedException);
                }
                stack.push((ProductComponent)productBean2);
            }
            productBean = softwareObjectTreeIterator.getNext(productBean);
        }
        return productTree;
    }

    protected Object getSpecialProductBeanProperty(ProductBean productBean, String string) throws ServiceException {
        if (string.equals("absoluteInstallLocation")) {
            return this.getAbsoluteInstallLocation(productBean);
        }
        if (string.equals("installed")) {
            return new Boolean(this.isInstalled(productBean));
        }
        if (string.equals("displayName")) {
            return this.getProductBeanDisplayName(productBean);
        }
        return null;
    }

    private String getSummaryTypeDesc(int n) {
        if (n == 1 || n == 2) {
            return LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.installedWithoutErrors", new String[]{"$P(displayName)"});
        }
        if (n == 3 || n == 4) {
            return LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.uninstalledWithoutErrors", new String[]{"$P(displayName)"});
        }
        throw new Error();
    }

    public int getSystemCompatibility() {
        return 1;
    }

    protected UninstallerInfo getUninstallerInfo(SoftwareObjectKey softwareObjectKey) throws ServiceException {
        UninstallerInfo uninstallerInfo = new UninstallerInfo();
        RegistryService registryService = (RegistryService)this.getServices().getService("registryService");
        SoftwareObject softwareObject = registryService.getSoftwareObject(softwareObjectKey);
        if (softwareObject != null) {
            uninstallerInfo.decodeRegistryValue(softwareObject.getUninstaller());
            uninstallerInfo.setProductInstallLocation(softwareObject.getInstallLocation());
            FileService fileService = (FileService)this.getServices().getService("fileService");
            if (fileService.fileExists(uninstallerInfo.getAbsoluteDataFileName())) {
                uninstallerInfo.setUninstallerStatus(2);
            }
        }
        return uninstallerInfo;
    }

    private Method getWriteMethod(Object object, String string) {
        try {
            PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(object, string);
            if (propertyDescriptor != null) {
                return propertyDescriptor.getWriteMethod();
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static void initializeActiveForUninstallStates(ProductTree productTree) {
        StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(productTree);
        ProductBean productBean = standardProductTreeIterator.getNext(standardProductTreeIterator.begin());
        while (productBean != standardProductTreeIterator.end()) {
            if (productBean instanceof SoftwareObject) {
                ((SoftwareObject)((Object)productBean)).setActiveForUninstall(true);
            }
            productBean = standardProductTreeIterator.getNext(productBean);
        }
    }

    private void initializeActiveNodeTable(Hashtable hashtable, ProductActionSupport productActionSupport, Vector vector) throws ServiceException {
        Vector vector2 = (Vector)vector.clone();
        while (!vector2.isEmpty()) {
            Vector<SoftwareObjectKey> vector3 = new Vector<SoftwareObjectKey>();
            int n = 0;
            while (n < vector2.size()) {
                SoftwareObjectKey softwareObjectKey = (SoftwareObjectKey)vector2.elementAt(n);
                Node node = (Node)hashtable.get(softwareObjectKey);
                SoftwareObject softwareObject = this.getRegistryService().getSoftwareObject(softwareObjectKey);
                if (softwareObject != null) {
                    SoftwareObjectKey[] softwareObjectKeyArray = softwareObject.getParents();
                    int n2 = 0;
                    while (n2 < softwareObjectKeyArray.length) {
                        Node node2 = (Node)hashtable.get(softwareObjectKeyArray[n2]);
                        if (node2 == null) {
                            SoftwareObject softwareObject2 = this.getRegistryService().getSoftwareObject(softwareObjectKeyArray[n2]);
                            if (softwareObject2 != null) {
                                node2 = new Node((ProductBean)((Object)softwareObject2));
                                hashtable.put(softwareObject2.getKey(), node2);
                                vector3.addElement(softwareObject2.getKey());
                            } else {
                                this.getServices().logEvent(this, "wrn", "Parent Component with UID = " + softwareObjectKeyArray[n2].getUID() + " of installed Component with displayName = " + this.getProductBeanDisplayName((ProductBean)((Object)softwareObject)) + " was not found in the VPD.");
                            }
                        }
                        if (node2 != null) {
                            node2.children.addElement(node);
                            node.parents.addElement(node2);
                        }
                        ++n2;
                    }
                } else {
                    this.getServices().logEvent(this, "wrn", "Installed Component with UID = " + softwareObjectKey.getUID() + " was not found in the VPD.");
                }
                ++n;
            }
            vector2 = (Vector)vector3.clone();
        }
    }

    private void initializeInstallStatus(ProductTree productTree) throws ServiceException {
        StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(productTree);
        ProductBean productBean = standardProductTreeIterator.getNext(standardProductTreeIterator.begin());
        while (productBean != standardProductTreeIterator.end()) {
            if (productBean instanceof SoftwareObject) {
                SoftwareObject softwareObject = (SoftwareObject)((Object)productBean);
                String string = productTree.getInstallLocation(productBean);
                SoftwareObject softwareObject2 = this.getRegistryService().getSoftwareObject(softwareObject.getKey().getUID(), string);
                if (softwareObject2 != null && softwareObject2.getKey().getVersion().equals(softwareObject.getKey().getVersion())) {
                    softwareObject.setInstallStatus(3);
                }
            }
            productBean = standardProductTreeIterator.getNext(productBean);
        }
    }

    protected static void initializeTree(ProductTree productTree, WizardServices wizardServices, boolean bl) throws ProductException {
        if (wizardServices == null) {
            throw new IllegalStateException("product service not initialized -- cannot initialize tree");
        }
        productTree.getUninstallerArchive().initialize(wizardServices);
        productTree.getUninstallerArchive().setUninstallerResId(wizardServices.getId());
        productTree.getUninstallerJVMResolution().initialize(wizardServices);
        productTree.getUninstallerLauncher().initialize(wizardServices);
        StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(productTree);
        ProductBean productBean = standardProductTreeIterator.getNext(standardProductTreeIterator.begin());
        while (productBean != standardProductTreeIterator.end()) {
            if (!bl && productBean instanceof ProductBeanPlaceHolder) {
                throw new ProductException(401, ((ProductBeanPlaceHolder)productBean).getPlaceHolderMessage());
            }
            productBean.initialize(wizardServices);
            productBean = standardProductTreeIterator.getNext(productBean);
        }
    }

    public OperationKey installProduct(String string) throws ServiceException {
        Installer installer = new Installer(string, this);
        this.startOperation(installer);
        return installer.getKey();
    }

    protected void installProductAction(ProductAction productAction, ProductActionSupport productActionSupport) throws ProductException {
        if (this.isDebugEventLogged("install")) {
            this.logDebugEvent("install", this.getMemoryDebugMessage("before installing " + productAction));
        }
        this.logEvent(this, "msg1", "installing " + productAction);
        productAction.install(productActionSupport);
        if (this.isDebugEventLogged("install")) {
            this.logDebugEvent("install", this.getMemoryDebugMessage("after installing " + productAction));
        }
    }

    private boolean installStatusMet(ProductBean productBean, int n) {
        boolean bl = true;
        SoftwareObject softwareObject = null;
        if (productBean instanceof SoftwareObject) {
            softwareObject = (SoftwareObject)((Object)productBean);
        } else if (productBean instanceof SoftwareObjectReference) {
            SoftwareObjectReference softwareObjectReference = (SoftwareObjectReference)productBean;
            softwareObject = productBean.getProductTree().resolveKey(softwareObjectReference.getKey());
        }
        if (softwareObject != null) {
            bl = softwareObject.getInstallStatus() == n;
        }
        return bl;
    }

    private void invalidateChecksForProduct(String string) throws ServiceException {
        InstallCheck[] installCheckArray = this.getChecksForProduct(string);
        int n = 0;
        while (n < installCheckArray.length) {
            installCheckArray[n].invalidate();
            ++n;
        }
    }

    private boolean isActiveForUninstall(ProductBean productBean) {
        boolean bl = true;
        if (productBean instanceof ProductComponentReference) {
            ProductBean productBean2 = productBean.getProductTree().getParent(productBean);
            if (productBean2 != null && productBean2 instanceof SoftwareObject) {
                bl = ((SoftwareObject)((Object)productBean2)).isActiveForUninstall();
            }
        } else if (productBean instanceof SoftwareObjectReference) {
            SoftwareObjectReference softwareObjectReference = (SoftwareObjectReference)productBean;
            SoftwareObject softwareObject = productBean.getProductTree().resolveKey(softwareObjectReference.getKey());
            if (softwareObject != null) {
                bl = softwareObject.isActiveForUninstall();
            }
        } else if (productBean instanceof SoftwareObject) {
            bl = ((SoftwareObject)((Object)productBean)).isActiveForUninstall();
        }
        return bl;
    }

    protected boolean isDebugEventLogged(String string) {
        return this.isEventLogged(WizardLog.subclassEvent("dbg", string));
    }

    private boolean isInstalled(ProductBean productBean) throws ServiceException {
        boolean bl = false;
        if (productBean instanceof SoftwareObject) {
            SoftwareObject softwareObject;
            SoftwareObject softwareObject2 = (SoftwareObject)((Object)productBean);
            bl = softwareObject2.getInstallStatus() == 3;
            ProductTree productTree = productBean.getProductTree().getUninstallTree();
            if (productTree != null && (softwareObject = productTree.findSoftwareObject(softwareObject2.getKey().getUID(), productBean.getProductTree().getInstallLocation(productBean))) != null && softwareObject.getKey().getVersion().equals(softwareObject2.getKey().getVersion())) {
                bl = softwareObject.getInstallStatus() == 3;
            }
        } else if (productBean instanceof ProductAction) {
            bl = ((ProductAction)productBean).getTransientInstallState();
        }
        return bl;
    }

    protected boolean isUninstallerInfoCurrent(ProductTree productTree, SoftwareObjectKey softwareObjectKey) {
        boolean bl = false;
        if (productTree != null) {
            SoftwareObjectKey softwareObjectKey2 = ((SoftwareObject)((Object)productTree.getRoot())).getKey();
            bl = softwareObjectKey2.getUID().equals(softwareObjectKey.getUID()) && softwareObjectKey2.getVersion().equals(softwareObjectKey.getVersion()) && softwareObjectKey2.getInstance() == softwareObjectKey.getInstance();
        }
        return bl;
    }

    private ProductTree loadProductTree(String string, boolean bl) throws IOException, ProductException {
        URL uRL = this.getResource(string);
        if (uRL == null) {
            throw new IOException("invalid product tree source: " + string);
        }
        ProductTree productTree = (ProductTree)QJML.read(uRL, class$com$installshield$product$ProductTree != null ? class$com$installshield$product$ProductTree : (class$com$installshield$product$ProductTree = PureJavaProductServiceImpl.class$("com.installshield.product.ProductTree")));
        PureJavaProductServiceImpl.initializeTree(productTree, this.getServices(), bl);
        PureJavaProductServiceImpl.initializeActiveForUninstallStates(productTree);
        return productTree;
    }

    protected void logDebugEvent(String string, String string2) {
        this.logEvent(this, WizardLog.subclassEvent("dbg", string), string2);
    }

    public void logEvent(Object object, String string, Object object2) {
        super.logEvent(object, string, object2);
    }

    private void markNodesInactive(ProductTree productTree, Hashtable hashtable, Vector vector) throws ServiceException {
        ProductBean productBean = productTree.getRoot();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            node.checkAncestors(vector, productBean, new Vector());
        }
    }

    private void markProductBeanInstalled(ProductBean productBean, ProductTree productTree, ProductActionSupport productActionSupport) throws ServiceException {
        boolean bl = ProductTree.isReplaceInstall(productBean);
        ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createRegisteredComponentIterator(productBean, new int[]{6, 2, 3});
        ProductBean productBean2 = productTreeIterator.getPrevious(productTreeIterator.end());
        while (productBean2 != productTreeIterator.begin()) {
            this.markSoftwareObjectInstalled(productTree, productBean2, productActionSupport);
            if (bl && productBean2 instanceof SoftwareObject) {
                ProductTree productTree2 = productTree.getUninstallTree();
                SoftwareObject softwareObject = (SoftwareObject)((Object)productBean2);
                String string = productTree.getInstallLocation(productBean2);
                SoftwareObject softwareObject2 = productTree2.findSoftwareObject(softwareObject.getKey().getUID(), string);
                if (softwareObject2 != null && softwareObject2 instanceof GenericSoftwareObject) {
                    softwareObject2.setInstallStatus(softwareObject.getInstallStatus());
                }
            }
            productBean2 = productTreeIterator.getPrevious(productBean2);
        }
    }

    private void markSoftwareObjectInstalled(ProductTree productTree, ProductBean productBean, ProductActionSupport productActionSupport) throws ServiceException {
        SoftwareObjectReference softwareObjectReference;
        SoftwareObject softwareObject = null;
        SoftwareObjectKey softwareObjectKey = null;
        if (productBean instanceof SoftwareObject) {
            softwareObject = (SoftwareObject)((Object)productBean);
            if (softwareObject.getInstallStatus() != 3) {
                if (softwareObject instanceof ProductComponent || this.childrenInstalled(softwareObject, productTree)) {
                    softwareObject.setInstallStatus(3);
                    this.setSoftwareObject(softwareObject);
                } else {
                    softwareObject.setInstallStatus(5);
                    this.getRegistryService().removeSoftwareObject(softwareObject.getKey());
                }
            }
        } else if (productBean instanceof SoftwareObjectReference && (softwareObject = productTree.resolveKey(softwareObjectKey = (softwareObjectReference = (SoftwareObjectReference)productBean).getKey())) != null) {
            this.markProductBeanInstalled((ProductBean)((Object)softwareObject), productTree, productActionSupport);
        }
    }

    private String normalizePath(String string) {
        return this.getServices().resolveString(FileUtils.normalizeFileName(string));
    }

    private void obtainDataResourceLocation(UninstallerInfo uninstallerInfo) throws IOException {
        String string = uninstallerInfo.getAbsoluteArchiveFileName();
        NonsecureWizardInf nonsecureWizardInf = WizardLoader.createNonsecureWizardInf(string);
        uninstallerInfo.setUninstallerResId(nonsecureWizardInf.getResId());
    }

    protected void obtainUninstaller(UninstallerInfo uninstallerInfo) {
    }

    public void overrideChecks(String string, String[] stringArray) throws ServiceException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = 0;
        while (n < stringArray.length) {
            hashtable.put(stringArray[n], "");
            ++n;
        }
        InstallCheck[] installCheckArray = this.getChecksForProduct(string);
        int n2 = 0;
        while (n2 < installCheckArray.length) {
            if (hashtable.containsKey(installCheckArray[n2].getName())) {
                installCheckArray[n2].override();
            }
            ++n2;
        }
    }

    protected void postInstallProduct(ProductTree productTree, ProductActionSupport productActionSupport) throws ServiceException {
    }

    protected void postInstallProductComponent(ProductBean productBean, ProductActionSupport productActionSupport) throws ServiceException {
    }

    protected void postUninstallProduct(ProductActionSupport productActionSupport, String string) throws ServiceException {
    }

    protected void preInstallProduct(ProductTree productTree, ProductActionSupport productActionSupport) throws ServiceException {
    }

    protected boolean preInstallProductComponent(ProductBean productBean, ProductActionSupport productActionSupport) throws ServiceException {
        return true;
    }

    protected void preUninstallProduct(ProductActionSupport productActionSupport, String string) throws ServiceException {
    }

    private void printTree(ProductTree productTree) {
        System.out.println("\n\nContents of Product Tree\n\n");
        StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(productTree);
        ProductBean productBean = standardProductTreeIterator.getNext(standardProductTreeIterator.begin());
        while (productBean != standardProductTreeIterator.end()) {
            System.out.println("PureJava - beanId = " + productBean.getBeanId() + " : name = " + productBean.getDisplayName() + " activeState: " + productBean.isActive());
            productBean = standardProductTreeIterator.getNext(productBean);
        }
    }

    private void processActiveForUninstallStateChange(ProductTree productTree, ProductBean productBean, boolean bl) throws ServiceException {
        Hashtable hashtable = new Hashtable();
        this.setSoftwareObjectVirtualActiveForUninstall(productTree, productBean, bl, hashtable, true, true);
        this.verifyVirtualActiveForUninstallStates(productTree, hashtable, this.getRegistryService());
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ProductBean productBean2 = productTree.getBean(string);
            if (productBean2 == null || !(productBean2 instanceof SoftwareObject)) continue;
            ((SoftwareObject)((Object)productBean2)).setActiveForUninstall((Boolean)hashtable.get(string));
        }
    }

    private void processActiveStateChange(ProductTree productTree, ProductBean productBean, boolean bl) throws ServiceException {
        productBean.setActive(bl);
        if (productBean instanceof Product || productBean instanceof ProductFeature) {
            Object object;
            if (bl) {
                object = productTree.getParent(productBean);
                while (object != null) {
                    if (object instanceof Product || object instanceof ProductFeature) {
                        ((ProductBean)object).setActive(true);
                    }
                    object = productTree.getParent((ProductBean)object);
                }
            }
            object = ProductTreeIteratorFactory.createSoftwareObjectIterator(productBean);
            ProductBean productBean2 = object.getNext(object.begin());
            while (productBean2 != object.end()) {
                if (productBean2 instanceof Product || productBean2 instanceof ProductFeature) {
                    productBean2.setActive(bl);
                }
                productBean2 = object.getNext(productBean2);
            }
        }
    }

    public void processProductBeanPropertiesOption(String string, String string2) throws ServiceException {
        String string3;
        String string4 = null;
        int n = string2.indexOf(".");
        int n2 = string2.indexOf("=");
        if (n != -1 && n2 != -1 && n < n2) {
            string4 = string2.substring(0, n);
            string3 = string2.substring(n + 1);
        } else {
            string3 = string2;
        }
        ProductBean productBean = this.getProductBean(string, string4);
        if (productBean == null) {
            throw new ServiceException(399, "could not find bean " + string4);
        }
        try {
            PropertyAssignmentParser.processAssignmentExpression(productBean, string3, new ProductPropertyAssignmentHandler());
        }
        catch (Exception exception) {
            throw new ServiceException(399, exception.getMessage());
        }
    }

    private boolean processSpecialProductBeanProperty(String string, ProductBean productBean, String string2, Object object) throws ServiceException {
        ProductTree productTree;
        if (string2.equals("installLocation")) {
            ProductTree productTree2 = this.getProductTree(string);
            if (productBean == productTree2.getRoot()) {
                this.verifyProductSourceChange(string, (GenericSoftwareObject)productBean, object.toString());
                return true;
            }
        } else if (string2.equals("activeForUninstall")) {
            ProductTree productTree3;
            if (object instanceof Boolean && !((productTree3 = this.getProductTree(string)).getRoot() instanceof DynamicSuite)) {
                this.processActiveForUninstallStateChange(productTree3, productBean, (Boolean)object);
                return true;
            }
        } else if (string2.equals("active") && object instanceof Boolean && !((productTree = this.getProductTree(string)).getRoot() instanceof DynamicSuite)) {
            this.processActiveStateChange(productTree, productBean, (Boolean)object);
            return true;
        }
        return false;
    }

    protected boolean productIsVisible(Product product) {
        boolean bl = product.isVisible();
        if (bl) {
            boolean bl2 = false;
            ProductBean productBean = product;
            while (bl && !bl2) {
                ProductBean productBean2 = productBean.getProductTree().getParent(productBean);
                if (productBean2 != null && productBean2 instanceof Product) {
                    bl = ((Product)productBean2).isVisible();
                } else {
                    bl2 = true;
                }
                productBean = productBean2;
            }
        }
        return bl;
    }

    protected void registerUninstaller(ProductTree productTree) throws ServiceException {
    }

    protected void replaceProductAction(ProductAction productAction, ProductAction productAction2, ProductActionSupport productActionSupport) throws ProductException {
        productAction.replace(productAction2, productActionSupport);
    }

    private void restoreProductBeanProperties(String string) throws ServiceException {
        if (this.retainedProductBeanProperties.containsKey(string)) {
            Hashtable hashtable = (Hashtable)this.retainedProductBeanProperties.get(string);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = string2.substring(0, string2.indexOf("."));
                String string4 = string2.substring(string2.indexOf(".") + 1);
                Object v = hashtable.get(string2);
                try {
                    this.setProductBeanProperty(string, string3, string4, v);
                }
                catch (ServiceException serviceException) {
                    throw new ServiceException(315, "Exception thrown while restoring ProductBean properties: \n" + serviceException.getMessage());
                }
            }
        }
    }

    private void restoreProductTreeProperties(String string) throws ServiceException {
        if (this.retainedProductTreeProperties.containsKey(string)) {
            Hashtable hashtable = (Hashtable)this.retainedProductTreeProperties.get(string);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Object v = hashtable.get(string2);
                try {
                    this.setProductTreeProperty(string, string2, v);
                }
                catch (ServiceException serviceException) {
                    throw new ServiceException(315, "Exception thrown while restoring ProductTree properties: \n" + serviceException.getMessage());
                }
            }
        }
    }

    private void retainProductBeanProperty(String string, String string2, String string3, Object object) {
        if (!this.retainedProductBeanProperties.containsKey(string)) {
            this.retainedProductBeanProperties.put(string, new Hashtable());
        }
        String string4 = String.valueOf(string2) + "." + string3;
        Hashtable hashtable = (Hashtable)this.retainedProductBeanProperties.get(string);
        if (object != null) {
            hashtable.put(string4, object);
        } else if (hashtable.containsKey(string4)) {
            hashtable.remove(string4);
        }
    }

    private void retainProductTreeProperty(String string, String string2, Object object) {
        if (!this.retainedProductTreeProperties.containsKey(string)) {
            this.retainedProductTreeProperties.put(string, new Hashtable());
        }
        Hashtable hashtable = (Hashtable)this.retainedProductTreeProperties.get(string);
        if (object != null) {
            hashtable.put(string2, object);
        } else if (hashtable.containsKey(string2)) {
            hashtable.remove(string2);
        }
    }

    private void rollbackProductComponent(ProductComponent productComponent) throws ServiceException {
        SoftwareObject softwareObject = this.getRegistryService().getSoftwareObject(productComponent.getKey());
        if (softwareObject != null) {
            SoftwareObjectKey[] softwareObjectKeyArray = softwareObject.getParents();
            SoftwareObjectKey softwareObjectKey = (SoftwareObjectKey)softwareObject.getKey().clone();
            softwareObjectKey.setInstance(0);
            int n = 0;
            while (n < softwareObjectKeyArray.length) {
                this.getRegistryService().updateRequiredSoftwareObject(softwareObjectKeyArray[n], softwareObjectKey);
                ++n;
            }
            this.getRegistryService().removeSoftwareObject(softwareObject.getKey());
        }
    }

    private Hashtable setActiveStateForUninstallation(ProductTree productTree, ProductActionSupport productActionSupport, int n) throws ServiceException {
        Hashtable hashtable = new Hashtable();
        Vector vector = new Vector();
        this.createActiveNodeTable(productTree.getRoot(), productTree, hashtable, vector, productActionSupport, n);
        this.initializeActiveNodeTable(hashtable, productActionSupport, vector);
        this.markNodesInactive(productTree, hashtable, vector);
        return hashtable;
    }

    private void setCachedProductTreeSet(String string, ProductTreeSet productTreeSet) {
        this.getServices().setValue(string, productTreeSet);
    }

    public void setChildrenActiveState(String string, ProductBean productBean, boolean bl) throws ServiceException {
        ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createChildIterator(productBean);
        ProductBean productBean2 = productTreeIterator.getNext(productTreeIterator.begin());
        String string2 = new String();
        while (productBean2 != productTreeIterator.end()) {
            if (productBean2 instanceof ProductAction) {
                productBean2.setActive(bl);
                string2 = productBean2.getBeanId();
                try {
                    this.setProductBeanProperty(string, string2, "active", new Boolean(bl));
                }
                catch (ServiceException serviceException) {
                    serviceException.printStackTrace();
                    throw new ServiceException(serviceException);
                }
            }
            productBean2 = productTreeIterator.getNext(productBean2);
        }
    }

    private void setExitCode(int n) {
        try {
            ExitCodeService exitCodeService = (ExitCodeService)this.getServices().getService("exitCodeService");
            exitCodeService.setExitCode(n);
        }
        catch (Exception exception) {}
    }

    private void setInternalProductBeanProperty(ProductBean productBean, String string, Object object) throws Exception {
        if (object instanceof String) {
            new DefaultPropertyAssignmentHandler().writeProperty((Object)productBean, string, (String)object);
        } else {
            new DefaultPropertyAssignmentHandler().writeProperty((Object)productBean, string, object);
        }
    }

    public void setProductBeanProperty(String string, String string2, String string3, Object object) throws ServiceException {
        ProductBean productBean = this.getProductBean(string, string2);
        if (!this.processSpecialProductBeanProperty(string, productBean, string3, object)) {
            try {
                this.setInternalProductBeanProperty(productBean, string3, object);
                this.invalidateChecksForProduct(string);
            }
            catch (Exception exception) {
                throw new ServiceException(315, "could not write property " + string3 + " for bean " + string2 + "because the following error occurred: " + exception);
            }
        }
    }

    public void setProductTreeProperty(String string, String string2, Object object) throws ServiceException {
        ProductTree productTree = this.getProductTree(string);
        try {
            Method method = this.getWriteMethod(productTree, string2);
            if (method == null) {
                throw new ServiceException(315, "property " + string2 + " cannot be written for product trees");
            }
            if (method.getParameterTypes().length > 1) {
                throw new ServiceException(315, "property " + string2 + " takes more than one parameter for product trees ");
            }
            method.invoke((Object)productTree, object);
        }
        catch (Exception exception) {
            throw new ServiceException(315, "could not write property " + string2 + " for product tree " + "because the following error occurred: " + exception);
        }
        this.invalidateChecksForProduct(string);
    }

    protected void setProductUninstaller(ProductTree productTree) {
        UninstallerInfo uninstallerInfo = new UninstallerInfo();
        uninstallerInfo.setInstallLocation(productTree.getUninstallerArchive().getInstallLocation());
        uninstallerInfo.setArchiveFileName(productTree.getUninstallerArchive().getArchiveName());
        uninstallerInfo.setDataFileName(productTree.getUninstallerArchive().getResourcesFileName());
        if (productTree.getUninstallerLauncher().isActive() && productTree.getUninstallerLauncher().getInstalledFileName() != null) {
            uninstallerInfo.setLauncherFileName(productTree.getUninstallerLauncher().getInstalledFileName());
        }
        ((GenericSoftwareObject)productTree.getRoot()).setUninstaller(uninstallerInfo.encodeRegistryValue());
    }

    public void setRetainedProductBeanProperty(String string, String string2, String string3, Object object) throws ServiceException {
        this.setProductBeanProperty(string, string2, string3, object);
        ProductBean productBean = this.getProductBean(string, string2);
        if (this.verifyRetainedProductBeanProperty(string, productBean, string3, object)) {
            this.retainProductBeanProperty(string, productBean.getBeanId(), string3, object);
        }
    }

    public void setRetainedProductTreeProperty(String string, String string2, Object object) throws ServiceException {
        this.setProductTreeProperty(string, string2, object);
        this.retainProductTreeProperty(string, string2, object);
    }

    private SoftwareObjectKey setSoftwareObject(SoftwareObject softwareObject) throws ServiceException {
        SoftwareObject softwareObject2;
        if (softwareObject instanceof GenericSoftwareObject && (softwareObject2 = this.getRegistryService().getSoftwareObject(softwareObject.getKey())) != null) {
            ((GenericSoftwareObject)softwareObject).setParents(softwareObject2.getParents());
            ((GenericSoftwareObject)softwareObject).setRequired(softwareObject2.getRequired());
        }
        return this.getRegistryService().setSoftwareObject(softwareObject);
    }

    private void setSoftwareObjectVirtualActiveForUninstall(ProductTree productTree, ProductBean productBean, boolean bl, Hashtable hashtable, boolean bl2, boolean bl3) throws ServiceException {
        if (productBean instanceof SoftwareObject) {
            Object object;
            if (!hashtable.containsKey(productBean.getBeanId())) {
                hashtable.put(productBean.getBeanId(), new Boolean(bl));
            }
            Enumeration enumeration = productTree.children(productBean);
            while (enumeration.hasMoreElements()) {
                object = (ProductBean)enumeration.nextElement();
                if (!bl3 && !(object instanceof ProductComponent)) continue;
                this.setSoftwareObjectVirtualActiveForUninstall(productTree, (ProductBean)object, bl, hashtable, false, bl3);
            }
            if (!bl) {
                if (bl2 && (object = productTree.getParent(productBean)) != null) {
                    this.setSoftwareObjectVirtualActiveForUninstall(productTree, (ProductBean)object, false, hashtable, true, false);
                }
                object = new RequiredTreeIterator((GenericSoftwareObject)productBean);
                ProductBean productBean2 = ((RequiredTreeIterator)object).getNext(((RequiredTreeIterator)object).begin());
                while (productBean2 != ((RequiredTreeIterator)object).end()) {
                    GenericSoftwareObject genericSoftwareObject = null;
                    if (productBean2 instanceof SoftwareObjectReference) {
                        SoftwareObject softwareObject = productBean.getProductTree().resolveKey(((SoftwareObjectReference)productBean2).getKey());
                        if (softwareObject instanceof GenericSoftwareObject) {
                            genericSoftwareObject = (GenericSoftwareObject)softwareObject;
                        }
                    } else if (productBean2 instanceof GenericSoftwareObject) {
                        genericSoftwareObject = (GenericSoftwareObject)productBean2;
                    }
                    if (genericSoftwareObject != null) {
                        this.setSoftwareObjectVirtualActiveForUninstall(productTree, genericSoftwareObject, false, hashtable, false, false);
                    }
                    productBean2 = ((RequiredTreeIterator)object).getNext(productBean2);
                }
            }
        }
    }

    protected OperationKey uninstallProduct(ProductTree productTree, ProductActionSupport productActionSupport) throws ServiceException {
        Uninstaller uninstaller = new Uninstaller(productTree, productActionSupport);
        this.startOperation(uninstaller);
        return uninstaller.getKey();
    }

    public OperationKey uninstallProduct(String string) throws ServiceException {
        Uninstaller uninstaller = new Uninstaller(string);
        this.startOperation(uninstaller);
        return uninstaller.getKey();
    }

    protected void uninstallProductAction(ProductAction productAction, ProductActionSupport productActionSupport) throws ProductException {
        this.logEvent(this, "msg1", "uninstalling " + productAction);
        productAction.uninstall(productActionSupport);
    }

    private void uninstallProductBean(ProductBean productBean, ProductTree productTree, Hashtable hashtable, ProductActionSupport productActionSupport, int n) throws ServiceException {
        ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createUninstallerComponentIterator(productBean, n);
        ProductBean productBean2 = productTreeIterator.getPrevious(productTreeIterator.end());
        while (productBean2 != productTreeIterator.begin()) {
            if (this.isActiveForUninstall(productBean2)) {
                this.uninstallSoftwareObject(productTree, productBean2, hashtable, productActionSupport, n);
            }
            productBean2 = productTreeIterator.getPrevious(productBean2);
        }
    }

    protected void uninstallProductComponent(ProductBean productBean, ProductActionSupport productActionSupport, int n) throws ServiceException {
        StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(productBean);
        ProductActionTreeIterator productActionTreeIterator = new ProductActionTreeIterator(standardProductTreeIterator);
        ProductBean productBean2 = productActionTreeIterator.getPrevious(productActionTreeIterator.end());
        while (productBean2 != productActionTreeIterator.begin()) {
            ProductAction productAction = (ProductAction)productBean2;
            if (productAction.getTransientInstallState() || productAction.isActive()) {
                try {
                    this.uninstallProductAction(productAction, productActionSupport);
                }
                catch (ProductException productException) {
                    String string = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.uninstallationFailed");
                    string = this.appendLogFileToMsg(string);
                    productActionSupport.logEvent(this, "err", string);
                    this.getServices().logEvent(this, "err", string);
                    this.getServices().logEvent(productAction, "err", productException);
                }
            }
            productBean2 = productActionTreeIterator.getPrevious(productBean2);
        }
    }

    private void uninstallSoftwareObject(ProductTree productTree, ProductBean productBean, Hashtable hashtable, ProductActionSupport productActionSupport, int n) throws ServiceException {
        ProductBean productBean2;
        SoftwareObject softwareObject = null;
        SoftwareObjectKey softwareObjectKey = null;
        if (productBean instanceof SoftwareObjectReference) {
            productBean2 = (SoftwareObjectReference)productBean;
            softwareObjectKey = productBean2.getKey();
            softwareObject = productTree.resolveKey(productBean2.getKey());
            if (softwareObject == null) {
                softwareObject = this.getRegistryService().getSoftwareObject(softwareObjectKey);
            } else {
                softwareObjectKey = softwareObject.getKey();
                this.uninstallProductBean((ProductBean)((Object)softwareObject), productTree, hashtable, productActionSupport, n);
            }
        } else if (productBean instanceof SoftwareObject) {
            softwareObject = (SoftwareObject)((Object)productBean);
            softwareObjectKey = softwareObject.getKey();
        }
        if (softwareObject == null) {
            this.getServices().logEvent(this, "wrn", "Installed Component with UID = " + softwareObjectKey.getUID() + " was not found in the VPD.");
        } else if (softwareObject.getInstallStatus() != 4) {
            Object object;
            productBean2 = productBean.getProductTree().getParent(productBean);
            Node node = null;
            SoftwareObjectKey softwareObjectKey2 = null;
            if (productBean2 != null && productBean2 instanceof SoftwareObject) {
                softwareObjectKey2 = ((SoftwareObject)((Object)productBean2)).getKey();
                node = (Node)hashtable.get(softwareObjectKey2);
            }
            if (node != null && node.getActive()) {
                this.getRegistryService().removeParentSoftwareObjects(softwareObjectKey, new SoftwareObjectKey[]{softwareObjectKey2});
                object = (SoftwareObjectKey)softwareObjectKey.clone();
                ((SoftwareObjectKey)object).setInstance(0);
                this.getRegistryService().updateRequiredSoftwareObject(softwareObjectKey2, (SoftwareObjectKey)object);
            }
            if ((object = (Node)hashtable.get(softwareObjectKey)) != null && ((Node)object).getActive()) {
                SoftwareObject softwareObject2 = this.getRegistryService().getSoftwareObject(softwareObjectKey);
                if (softwareObject2 != null) {
                    if (softwareObject2.getParents().length == 0) {
                        if (softwareObject instanceof ProductComponent) {
                            this.uninstallProductComponent((ProductBean)((Object)softwareObject), productActionSupport, n);
                        }
                        if (softwareObject instanceof GenericSoftwareObject) {
                            Object object2;
                            Object object3;
                            GenericSoftwareObject genericSoftwareObject = (GenericSoftwareObject)softwareObject;
                            int n2 = genericSoftwareObject.getProductTree().getChildCount(genericSoftwareObject);
                            int n3 = 0;
                            while (n3 < n2) {
                                object3 = genericSoftwareObject.getProductTree().getChild(genericSoftwareObject, n3);
                                SoftwareObject softwareObject3 = null;
                                if (object3 instanceof SoftwareObject) {
                                    softwareObject3 = (SoftwareObject)object3;
                                } else if (object3 instanceof SoftwareObjectReference) {
                                    object2 = ((SoftwareObjectReference)object3).getKey();
                                    softwareObject3 = genericSoftwareObject.getProductTree().resolveKey((SoftwareObjectKey)object2);
                                }
                                if (softwareObject3 != null && !softwareObject3.isActiveForUninstall()) {
                                    try {
                                        this.getRegistryService().removeParentSoftwareObjects(softwareObject3.getKey(), new SoftwareObjectKey[]{softwareObject.getKey()});
                                    }
                                    catch (Exception exception) {}
                                }
                                ++n3;
                            }
                            object3 = softwareObject.getRequired();
                            int n4 = 0;
                            while (n4 < ((SoftwareObjectReference[])object3).length) {
                                object2 = genericSoftwareObject.getProductTree().resolveKey(object3[n4].getKey());
                                if (object2 != null && !object2.isActiveForUninstall()) {
                                    try {
                                        this.getRegistryService().removeParentSoftwareObjects(object2.getKey(), new SoftwareObjectKey[]{softwareObject.getKey()});
                                    }
                                    catch (Exception exception) {}
                                }
                                ++n4;
                            }
                        }
                        this.getRegistryService().removeSoftwareObject(softwareObjectKey);
                        softwareObject.setInstallStatus(4);
                    } else if (productBean instanceof ProductFeature) {
                        this.getRegistryService().removeSoftwareObject(softwareObjectKey);
                        softwareObject.setInstallStatus(4);
                    } else if (softwareObject2.getParents().length == 1 && softwareObjectKey.equals(softwareObject2.getParents()[0])) {
                        boolean bl = true;
                        Enumeration enumeration = productTree.children(productBean);
                        while (bl && enumeration.hasMoreElements()) {
                            ProductBean productBean3 = (ProductBean)enumeration.nextElement();
                            SoftwareObject softwareObject4 = null;
                            if (productBean3 instanceof SoftwareObject) {
                                softwareObject4 = (SoftwareObject)((Object)productBean3);
                            } else if (productBean3 instanceof SoftwareObjectReference) {
                                SoftwareObjectReference softwareObjectReference = (SoftwareObjectReference)productBean3;
                                softwareObject4 = productTree.resolveKey(softwareObjectReference.getKey());
                            }
                            if (softwareObject4 == null) continue;
                            boolean bl2 = bl = softwareObject4.getInstallStatus() != 3 && softwareObject4.getInstallStatus() != 2;
                        }
                        if (bl) {
                            this.getRegistryService().removeSoftwareObject(softwareObjectKey);
                            softwareObject.setInstallStatus(4);
                        }
                    }
                } else {
                    if (softwareObject instanceof ProductComponent) {
                        this.uninstallProductComponent((ProductBean)((Object)softwareObject), productActionSupport, n);
                    }
                    softwareObject.setInstallStatus(4);
                }
            }
        }
    }

    protected void unregisterUninstaller(ProductTree productTree) throws ServiceException {
    }

    protected void updateProductUninstaller(ProductTree productTree, ProductTree productTree2) {
        String string = ((GenericSoftwareObject)productTree2.getRoot()).getUninstaller();
        ((GenericSoftwareObject)productTree.getRoot()).setUninstaller(string);
    }

    public void updateSoftwareObjectTree(String string, ProductTree productTree) throws ServiceException {
        boolean bl = false;
        try {
            ProductTree productTree2 = this.loadProductTree(string, false);
            StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(productTree);
            ProductBean productBean = standardProductTreeIterator.getNext(standardProductTreeIterator.begin());
            while (productBean != standardProductTreeIterator.end()) {
                String string2 = productBean.getBeanId();
                boolean bl2 = productBean.isActive();
                ProductBean productBean2 = productTree2.getBean(string2);
                String string3 = productBean2.getBeanId();
                productBean2.setActive(bl2);
                this.setProductBeanProperty(string, string3, "active", new Boolean(bl2));
                this.setChildrenActiveState(string, productBean2, bl2);
                productBean = standardProductTreeIterator.getNext(productBean);
            }
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ServiceException(exception);
        }
    }

    private void updateUninstaller(ProductTree productTree, UninstallerInfo uninstallerInfo) {
        UninstallerArchive uninstallerArchive = productTree.getUninstallerArchive();
        UninstallerLauncher uninstallerLauncher = productTree.getUninstallerLauncher();
        uninstallerArchive.setArchiveName(uninstallerInfo.getArchiveFileName());
        uninstallerArchive.setResourcesFileName(uninstallerInfo.getDataFileName());
        uninstallerArchive.setInstallLocation(uninstallerInfo.getInstallLocation());
        uninstallerArchive.setUninstallerResId(uninstallerInfo.getUninstallerResId());
        uninstallerLauncher.setInstalledFileName(uninstallerInfo.getLauncherFileName());
    }

    private boolean useActiveFilter(Properties properties) {
        return ((Hashtable)properties).get("filter.active") != null;
    }

    private boolean useConditionFilter(Properties properties) {
        return ((Hashtable)properties).get("filter.condition") != null;
    }

    private void verifyChecksForProduct(String string, LogSummary logSummary) throws ServiceException {
        InstallCheck[] installCheckArray = this.getChecksForProduct(string);
        int n = 0;
        while (n < installCheckArray.length) {
            if (!installCheckArray[n].isValid()) {
                this.executeCheck(installCheckArray[n], string, this.getServices(), logSummary);
            }
            if (!installCheckArray[n].isPassed() && !installCheckArray[n].isOverridden()) {
                throw new ServiceException(315, LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.installCheckFailedError", new String[]{installCheckArray[n].getName()}));
            }
            ++n;
        }
    }

    private void verifyProductSourceChange(String string, GenericSoftwareObject genericSoftwareObject, String string2) {
        block8: {
            try {
                ProductTree productTree;
                ProductTreeSet productTreeSet;
                block9: {
                    FileService fileService = (FileService)this.getServices().getService("fileService");
                    string2 = FileUtils.createFileName(new File("").getAbsolutePath(), string2);
                    if (fileService.comparePaths(genericSoftwareObject.getProductTree().getInstallLocation(genericSoftwareObject), string2)) break block8;
                    String string3 = (String)this.redirectedProductSources.get(string);
                    if (string3 != null) {
                        this.getServices().removeResourceLocation(string3);
                        this.redirectedProductSources.remove(string);
                    }
                    productTreeSet = new ProductTreeSet(this.loadProductTree(string, false));
                    productTree = productTreeSet.getInstallTree();
                    this.setCachedProductTreeSet(string, productTreeSet);
                    this.restoreProductTreeProperties(string);
                    this.restoreProductBeanProperties(string);
                    RegistryService registryService = (RegistryService)this.getServices().getService("registryService");
                    SoftwareObject softwareObject = registryService.getSoftwareObject(genericSoftwareObject.getKey().getUID(), string2);
                    if (softwareObject != null) {
                        UninstallerInfo uninstallerInfo = this.getUninstallerInfo(softwareObject.getKey());
                        if (uninstallerInfo.getUninstallerStatus() == 3) {
                            this.obtainUninstaller(uninstallerInfo);
                        }
                        if (uninstallerInfo.getUninstallerStatus() == 2) {
                            String string4 = null;
                            try {
                                this.obtainDataResourceLocation(uninstallerInfo);
                                string4 = uninstallerInfo.getAbsoluteDataResourceLocation();
                                this.getServices().putResourceLocation(string4);
                                ProductTree productTree2 = this.loadProductTree(string, true);
                                ((GenericSoftwareObject)productTree2.getRoot()).setInstallLocation(string2);
                                this.redirectedProductSources.put(string, string4);
                                this.updateUninstaller(productTree2, uninstallerInfo);
                                productTreeSet.setUninstallTree(productTree2);
                            }
                            catch (Exception exception) {
                                this.logEvent(this, "err", exception);
                                if (string4 == null) break block9;
                                this.getServices().removeResourceLocation(string4);
                            }
                        }
                    }
                }
                ((GenericSoftwareObject)productTree.getRoot()).setInstallLocation(string2);
                genericSoftwareObject.setInstallLocation(string2);
                this.setCachedProductTreeSet(string, productTreeSet);
                this.restoreProductTreeProperties(string);
                this.restoreProductBeanProperties(string);
            }
            catch (Exception exception) {
                this.logEvent(this, "err", exception);
            }
        }
    }

    private boolean verifyRetainedProductBeanProperty(String string, ProductBean productBean, String string2, Object object) throws ServiceException {
        ProductTree productTree;
        boolean bl = true;
        if (string2.equals("installLocation") && productBean == (productTree = this.getProductTree(string)).getRoot()) {
            bl = false;
        }
        return bl;
    }

    private void verifyVirtualActiveForUninstallStates(ProductTree productTree, Hashtable hashtable, RegistryService registryService) throws ServiceException {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        Hashtable hashtable2 = this.createRequiredBeansTable(productTree);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            boolean bl2 = (Boolean)hashtable.get(string);
            ProductBean productBean = productTree.getBean(string);
            if (!bl2 || !hashtable2.containsKey(productBean.getBeanId())) continue;
            Hashtable hashtable3 = (Hashtable)hashtable2.get(productBean.getBeanId());
            Enumeration enumeration2 = hashtable3.keys();
            while (enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                boolean bl3 = true;
                bl3 = hashtable.containsKey(string2) ? ((Boolean)hashtable.get(string2)).booleanValue() : ((Boolean)hashtable3.get(string2)).booleanValue();
                if (bl3) continue;
                if (bl) {
                    stringBuffer.append("\n");
                }
                bl = true;
                String string3 = this.getServices().resolveString("$L(com.installshield.product.i18n.ProductResources, PureJavaProductServiceImpl.invalidActiveForUninstallState, " + productBean.getDisplayName() + ", " + productTree.getBean(string2).getDisplayName() + ")");
                stringBuffer.append(string3);
            }
        }
        if (bl) {
            throw new ServiceException(315, stringBuffer.toString());
        }
    }

    public void writeProductTree(String string, String string2) throws ServiceException {
        ProductTree productTree = this.getProductTree(string);
        try {
            QJML.write((Object)productTree, class$com$installshield$product$ProductTree != null ? class$com$installshield$product$ProductTree : (class$com$installshield$product$ProductTree = PureJavaProductServiceImpl.class$("com.installshield.product.ProductTree")), string2);
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException);
        }
    }

    private class Node {
        ProductBean bean = null;
        Vector parents = new Vector();
        Vector children = new Vector();
        boolean active = true;

        Node(ProductBean productBean) {
            this.bean = productBean;
        }

        void checkAncestors(Vector vector, ProductBean productBean, Vector vector2) {
            if (!vector2.contains(this)) {
                vector2.addElement(this);
                Enumeration enumeration = this.parents.elements();
                while (this.active && enumeration.hasMoreElements()) {
                    Node node = (Node)enumeration.nextElement();
                    SoftwareObjectKey softwareObjectKey = ((SoftwareObject)((Object)node.bean)).getKey();
                    if (!node.getActive()) {
                        this.active = false;
                        continue;
                    }
                    if (!vector.contains(softwareObjectKey)) {
                        if (this.bean instanceof ProductFeature && ((ProductFeature)this.bean).isActiveForUninstall()) {
                            this.active = true;
                            continue;
                        }
                        this.active = false;
                        continue;
                    }
                    if (node.equals(this)) {
                        if (this.bean.equals(productBean)) continue;
                        this.active = false;
                        continue;
                    }
                    node.checkAncestors(vector, productBean, vector2);
                    this.active = node.getActive();
                }
            }
        }

        boolean getActive() {
            return this.active;
        }

        void setActive(boolean bl) {
            this.active = bl;
        }
    }

    private class WizardServicesLog
    implements Log {
        WizardServices services;

        WizardServicesLog(WizardServices wizardServices) {
            this.services = wizardServices;
        }

        public void logEvent(Object object, String string, Object object2) {
            this.services.logEvent(object, string, object2);
        }
    }

    protected class LogSummary
    implements LogListener {
        private String description;
        private Vector errors = new Vector();
        private Vector warnings = new Vector();
        private Vector messages = new Vector();

        public LogSummary(String string) {
            this.description = string;
        }

        public int errorCount() {
            return this.errors.size();
        }

        public Enumeration errors() {
            return this.errors.elements();
        }

        public void eventLogged(Object object, String string, Object object2) {
            if (string.equals("err")) {
                this.errors.addElement(object2);
            } else if (string.equals("wrn")) {
                this.warnings.addElement(object2);
            } else if (string.equals("msg1") || string.equals("msg2")) {
                this.messages.addElement(object2);
            }
        }

        public String getDescription() {
            return this.description;
        }

        public boolean hasErrors() {
            return this.errors.size() > 0;
        }

        public boolean hasMessages() {
            return this.messages.size() > 0;
        }

        public boolean hasWarnings() {
            return this.warnings.size() > 0;
        }

        public int messageCount() {
            return this.messages.size();
        }

        public Enumeration messages() {
            return this.messages.elements();
        }

        public int warningCount() {
            return this.warnings.size();
        }

        public Enumeration warnings() {
            return this.warnings.elements();
        }
    }

    private class Installer
    extends AsynchronousOperation {
        private String source;

        Installer(String string, AbstractServiceImplementor abstractServiceImplementor) {
            super("Installer for " + string, abstractServiceImplementor);
            this.source = string;
        }

        public void execute() {
            LogSummary logSummary = new LogSummary(PureJavaProductServiceImpl.this.getSummaryTypeDesc(2));
            try {
                PureJavaProductServiceImpl.this.addLogSummary(logSummary, 2, this.source);
                ProductTree productTree = PureJavaProductServiceImpl.this.getProductTree(this.source);
                this.setStatusDescription(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.Installer.installing", new String[]{PureJavaProductServiceImpl.this.getProductBeanDisplayName(productTree.getRoot())}));
                PureJavaProductServiceImpl.this.verifyChecksForProduct(this.source, logSummary);
                if (productTree.getRoot() instanceof DynamicSuite) {
                    ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createDynamicSuiteProductIterator(productTree, new ProductTreeSource(PureJavaProductServiceImpl.this.getServices()), PureJavaProductServiceImpl.this);
                    ProductBean productBean = productTreeIterator.getNext(productTreeIterator.begin());
                    int n = 1;
                    while (PureJavaProductServiceImpl.this.canContinueInstall(n) && productBean != productTreeIterator.end()) {
                        if (productBean != productTree.getRoot()) {
                            n = new InstallProduct().install(productBean.getProductTree(), this, logSummary);
                        }
                        productBean = productTreeIterator.getNext(productBean);
                    }
                } else {
                    new InstallProduct().install(productTree, this, logSummary);
                }
            }
            catch (Exception exception) {
                PureJavaProductServiceImpl.this.getServices().logEvent(this, "err", exception);
                logSummary.eventLogged(this, "err", exception.getMessage());
            }
        }
    }

    private class Uninstaller
    extends AsynchronousOperation {
        private ProductTree tree;
        private String source;
        private ProductActionSupport support;
        private int installState;

        Uninstaller(ProductTree productTree, ProductActionSupport productActionSupport) {
            super("Uninstaller for " + productTree, PureJavaProductServiceImpl.this);
            this.tree = productTree;
            this.support = productActionSupport;
            this.installState = 2;
        }

        Uninstaller(String string) {
            super("Uninstaller for " + string, PureJavaProductServiceImpl.this);
            this.source = string;
            this.installState = 3;
        }

        private boolean canUninstallProduct(Product product) {
            boolean bl = PureJavaProductServiceImpl.this.isActiveForUninstall(product);
            if (bl) {
                ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createFeatureIterator(product);
                ProductBean productBean = productTreeIterator.getNext(productTreeIterator.begin());
                while (bl && productBean != null && productBean != productTreeIterator.end()) {
                    if (PureJavaProductServiceImpl.this.installStatusMet(productBean, 3)) {
                        bl = false;
                    }
                    productBean = productTreeIterator.getNext(productBean);
                }
            }
            return bl;
        }

        private Hashtable createComponentReferenceTable(ProductTree productTree) {
            Hashtable hashtable = new Hashtable();
            StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(productTree, true);
            SoftwareObjectTreeIterator softwareObjectTreeIterator = new SoftwareObjectTreeIterator(standardProductTreeIterator);
            ProductBean productBean = softwareObjectTreeIterator.getNext(softwareObjectTreeIterator.begin());
            while (productBean != null && productBean != softwareObjectTreeIterator.end()) {
                ProductBean productBean2;
                SoftwareObject softwareObject = null;
                if (productBean instanceof SoftwareObject) {
                    softwareObject = (SoftwareObject)((Object)productBean);
                } else if (productBean instanceof SoftwareObjectReference) {
                    productBean2 = (SoftwareObjectReference)productBean;
                    softwareObject = productBean.getProductTree().resolveKey(((SoftwareObjectReference)productBean2).getKey());
                }
                if (softwareObject != null && softwareObject instanceof ProductComponent) {
                    Vector vector;
                    productBean2 = (ProductComponent)softwareObject;
                    if (!hashtable.containsKey(productBean2.getBeanId())) {
                        hashtable.put(productBean2.getBeanId(), new Vector());
                    }
                    if (!(vector = (Vector)hashtable.get(productBean2.getBeanId())).contains(productBean)) {
                        vector.addElement(productBean);
                    }
                }
                productBean = softwareObjectTreeIterator.getNext(productBean);
            }
            return hashtable;
        }

        public void execute() {
            LogSummary logSummary = new LogSummary(PureJavaProductServiceImpl.this.getSummaryTypeDesc(4));
            try {
                ProductBean productBean;
                Object object;
                PureJavaProductServiceImpl.this.addLogSummary(logSummary, 4, this.source);
                if (this.tree == null) {
                    this.tree = PureJavaProductServiceImpl.this.getProductTree(this.source);
                }
                this.setStatusDescription(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.Uninstaller.uninstalling", new String[]{PureJavaProductServiceImpl.this.getServices().resolveString(PureJavaProductServiceImpl.this.getProductBeanDisplayName(this.tree.getRoot()))}));
                UninstallResources uninstallResources = null;
                String string = null;
                if (this.support == null) {
                    string = FileUtils.createTempFile();
                    class Com_installshield_product_service_product_PureJavaProductServiceImpl$1 {
                        /* synthetic */ Com_installshield_product_service_product_PureJavaProductServiceImpl$1() {
                        }
                    }
                    uninstallResources = new UninstallResources(null, string, PureJavaProductServiceImpl.this.getServices().getId());
                    this.support = PureJavaProductServiceImpl.this.createProductActionSupport(uninstallResources, this, this.tree.getUninstallerArchive());
                }
                this.support.addLogListener(logSummary);
                PureJavaProductServiceImpl.this.preUninstallProduct(this.support, this.source);
                Hashtable hashtable = PureJavaProductServiceImpl.this.setActiveStateForUninstallation(this.tree, this.support, this.installState);
                if (System.getProperty("is.debug.order") != null) {
                    this.support.logEvent(this, "wrn", "Uninstalling Components:");
                }
                Hashtable hashtable2 = this.createComponentReferenceTable(this.tree);
                ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createOrderedComponentIterator(this.tree.getRoot());
                ProductBean productBean2 = productTreeIterator.getPrevious(productTreeIterator.end());
                while (productBean2 != null && productBean2 != productTreeIterator.begin()) {
                    object = (Vector)hashtable2.get(productBean2.getBeanId());
                    int n = ((Vector)object).size() - 1;
                    while (n >= 0) {
                        productBean = (ProductBean)((Vector)object).elementAt(n);
                        if (PureJavaProductServiceImpl.this.installStatusMet(productBean, this.installState) && PureJavaProductServiceImpl.this.isActiveForUninstall(productBean)) {
                            if (System.getProperty("is.debug.order") != null) {
                                this.support.logEvent(this, "wrn", "Uninstall:  id = " + productBean.getBeanId() + " ; " + "name = " + productBean.getDisplayName());
                            }
                            PureJavaProductServiceImpl.this.uninstallSoftwareObject(this.tree, productBean, hashtable, this.support, this.installState);
                        }
                        --n;
                    }
                    productBean2 = productTreeIterator.getPrevious(productBean2);
                }
                if (System.getProperty("is.debug.order") != null) {
                    this.support.logEvent(this, "wrn", "Uninstalling Features:");
                }
                object = ProductTreeIteratorFactory.createFeatureIterator(this.tree.getRoot());
                ProductBean productBean3 = object.getPrevious(object.end());
                while (productBean3 != null && productBean3 != object.begin()) {
                    if (PureJavaProductServiceImpl.this.installStatusMet(productBean3, this.installState) && PureJavaProductServiceImpl.this.isActiveForUninstall(productBean3)) {
                        if (System.getProperty("is.debug.order") != null) {
                            this.support.logEvent(this, "wrn", "Uninstall:  id = " + productBean3.getBeanId() + " ; " + "name = " + productBean3.getDisplayName());
                        }
                        PureJavaProductServiceImpl.this.uninstallSoftwareObject(this.tree, productBean3, hashtable, this.support, this.installState);
                    }
                    productBean3 = object.getPrevious(productBean3);
                }
                if (System.getProperty("is.debug.order") != null) {
                    this.support.logEvent(this, "wrn", "Uninstalling Products:");
                }
                if (this.tree.getRoot() instanceof StaticSuite) {
                    boolean bl = true;
                    int n = this.tree.getChildCount(this.tree.getRoot());
                    int n2 = n - 1;
                    while (n2 >= 0) {
                        Product product = (Product)this.tree.getChild(this.tree.getRoot(), n2);
                        if (PureJavaProductServiceImpl.this.installStatusMet(product, 3)) {
                            if (this.canUninstallProduct(product)) {
                                if (System.getProperty("is.debug.order") != null) {
                                    this.support.logEvent(this, "wrn", "Uninstall:  id = " + product.getBeanId() + " ; " + "name = " + product.getDisplayName());
                                }
                                PureJavaProductServiceImpl.this.uninstallProductBean(product, this.tree, hashtable, this.support, this.installState);
                            } else {
                                bl = false;
                            }
                        }
                        --n2;
                    }
                    if (bl) {
                        if (System.getProperty("is.debug.order") != null) {
                            this.support.logEvent(this, "wrn", "Uninstall:  id = " + this.tree.getRoot().getBeanId() + " ; " + "name = " + this.tree.getRoot().getDisplayName());
                        }
                        PureJavaProductServiceImpl.this.uninstallProductBean(this.tree.getRoot(), this.tree, hashtable, this.support, this.installState);
                    }
                } else {
                    productBean = (Product)this.tree.getRoot();
                    if (PureJavaProductServiceImpl.this.installStatusMet(productBean, 3) && this.canUninstallProduct((Product)productBean)) {
                        if (System.getProperty("is.debug.order") != null) {
                            this.support.logEvent(this, "wrn", "Uninstall:  id = " + productBean.getBeanId() + " ; " + "name = " + productBean.getDisplayName());
                        }
                        PureJavaProductServiceImpl.this.uninstallProductBean(productBean, this.tree, hashtable, this.support, this.installState);
                    }
                }
                if (this.installState == 3) {
                    PureJavaProductServiceImpl.this.getRegistryService().finalizeRegistry();
                }
                PureJavaProductServiceImpl.this.postUninstallProduct(this.support, this.source);
                if (uninstallResources != null) {
                    if (this.installState == 3) {
                        uninstallResources.write();
                    }
                    uninstallResources.close();
                }
                if (this.installState == 3) {
                    UninstallerArchive uninstallerArchive = this.tree.getUninstallerArchive();
                    uninstallerArchive.setUninstallResources(string);
                    uninstallerArchive.uninstall(this.support);
                    if (((SoftwareObject)((Object)this.tree.getRoot())).getInstallStatus() == 4) {
                        if (this.tree.getUninstallerLauncher().isActive()) {
                            this.tree.getUninstallerLauncher().uninstall(this.support);
                        }
                        if (this.tree.getUninstallerJVMResolution().isActive()) {
                            this.tree.getUninstallerJVMResolution().uninstall(this.support);
                        }
                    }
                    PureJavaProductServiceImpl.this.unregisterUninstaller(this.tree);
                }
            }
            catch (Exception exception) {
                PureJavaProductServiceImpl.this.getServices().logEvent(this, "err", exception);
                logSummary.eventLogged(this, "err", exception.getMessage());
            }
        }
    }

    protected class DiskSpaceCheck
    extends InstallCheck {
        protected DiskSpaceCheck() {
        }

        public void execute(String string, WizardServices wizardServices, Log log) {
            try {
                FileService fileService = (FileService)wizardServices.getService("fileService");
                String string2 = ServiceFactory.getCurrentImplementorType(fileService);
                if (string2.endsWith("PureJavaFileServiceImpl")) {
                    log.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.DiskSpaceCheck.nativeSupportRequired"));
                    this.setPassed(true);
                } else {
                    boolean bl = false;
                    ProductBean productBean = null;
                    productBean = PureJavaProductServiceImpl.this.getProductBean(string, null);
                    if (productBean == null) {
                        bl = true;
                        log.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.DiskSpaceCheck.invalidProductSource", new String[]{string}));
                    } else {
                        String[] stringArray = fileService.getPartitionNames();
                        String string3 = fileService.getPartitionName(new File("").getAbsolutePath(), stringArray);
                        RequiredBytesTable requiredBytesTable = new RequiredBytes().getEstimatedRequiredBytes(productBean, PureJavaProductServiceImpl.this.getProductTree(string), new ProductTreeSource(PureJavaProductServiceImpl.this.getServices()), PureJavaProductServiceImpl.this.getRegistryService(), PureJavaProductServiceImpl.this);
                        requiredBytesTable = requiredBytesTable.consolidate(stringArray, string3, fileService);
                        Enumeration enumeration = requiredBytesTable.locations();
                        while (enumeration.hasMoreElements()) {
                            long l = 0L;
                            long l2 = 0L;
                            long l3 = 0L;
                            String string4 = (String)enumeration.nextElement();
                            l3 = requiredBytesTable.getBytes(string4);
                            if (l3 == 0L || (l = (l2 = fileService.getPartitionFreeSpace(string4, l3)) - l3) >= 0L) continue;
                            String string5 = FileUtils.formatSizeAsBytes(-l);
                            log.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.DiskSpaceCheck.insufficientSpace", new String[]{string4, string5}));
                            bl = true;
                        }
                        if (bl) {
                            this.setPassed(false);
                        } else {
                            this.setPassed(true);
                        }
                    }
                }
            }
            catch (ServiceException serviceException) {
                log.logEvent(this, "wrn", serviceException.getMessage());
                this.setPassed(true);
            }
        }

        public String getName() {
            return "diskspace";
        }
    }

    protected class DependenciesCheck
    extends InstallCheck {
        protected DependenciesCheck() {
        }

        private boolean checkDependenciesOnBean(ProductBean productBean, ProductTree productTree, Log log, WizardServices wizardServices) throws ServiceException {
            RegistryService registryService = (RegistryService)PureJavaProductServiceImpl.this.getServices().getService("registryService");
            boolean bl = true;
            ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createRequiredComponentIterator(productBean);
            ProductBean productBean2 = productTreeIterator.getNext(productTreeIterator.begin());
            while (productBean2 != productTreeIterator.end()) {
                if (productBean2 instanceof SoftwareObjectReference) {
                    SoftwareObjectReference softwareObjectReference = (SoftwareObjectReference)productBean2;
                    SoftwareObject softwareObject = productTree.resolveKey(softwareObjectReference.getKey());
                    if (softwareObject != null) {
                        bl = bl && this.checkDependenciesOnBean((ProductBean)((Object)softwareObject), productTree, log, wizardServices);
                    } else if (softwareObjectReference.getResolutionPreference() == 2) {
                        softwareObject = registryService.getSoftwareObject(softwareObjectReference.getKey());
                    }
                    if (softwareObject == null) {
                        boolean bl2 = false;
                        if (softwareObjectReference.getSources() != null) {
                            int n = 0;
                            while (!bl2 && n < softwareObjectReference.getSources().length) {
                                ++n;
                            }
                        }
                        if (!bl2) {
                            bl = false;
                            ProductBean productBean3 = productBean2.getProductTree().getParent(productBean2);
                            String string = new String();
                            string = productBean3 instanceof SoftwareObject ? PureJavaProductServiceImpl.this.getProductBeanDisplayName(productBean3) : (productBean3 instanceof SoftwareObjectReference ? PureJavaProductServiceImpl.this.getProductBeanDisplayName(productBean3) : LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.DependenciesCheck.parentNotFound"));
                            String string2 = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.DependenciesCheck.unresolvedDependency", new String[]{string, PureJavaProductServiceImpl.this.getProductBeanDisplayName(softwareObjectReference)});
                            log.logEvent(this, "err", string2);
                        }
                    }
                }
                productBean2 = productTreeIterator.getNext(productBean2);
            }
            return bl;
        }

        public void execute(String string, WizardServices wizardServices, Log log) {
            try {
                ProductTree productTree = PureJavaProductServiceImpl.this.getProductTree(string);
                this.setPassed(this.checkDependenciesOnBean(productTree.getRoot(), productTree, log, wizardServices));
            }
            catch (ServiceException serviceException) {
                log.logEvent(this, "err", serviceException.getMessage());
                this.invalidate();
            }
        }

        public String getName() {
            return "dependencies";
        }
    }

    protected class PatchCheck
    extends InstallCheck {
        protected PatchCheck() {
        }

        public void execute(String string, WizardServices wizardServices, Log log) {
            try {
                boolean bl = true;
                ProductTree productTree = PureJavaProductServiceImpl.this.getProductTree(string);
                Product product = (Product)productTree.getRoot();
                if (product.isPatch()) {
                    SoftwareVersion softwareVersion = product.getKey().getVersion();
                    bl = false;
                    SoftwareObject softwareObject = PureJavaProductServiceImpl.this.getRegistryService().getNewestSoftwareObject(product.getKey().getUID());
                    while (!bl && softwareObject != null) {
                        SoftwareVersion softwareVersion2 = softwareObject.getKey().getVersion();
                        if (softwareVersion2.compareTo(softwareVersion) <= 0) {
                            bl = true;
                        }
                        softwareObject = PureJavaProductServiceImpl.this.getRegistryService().getNextNewestSoftwareObject(softwareObject);
                    }
                }
                if (!bl) {
                    log.logEvent(this, "err", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.PatchCheck.noProductTargetForPatch", new String[]{PureJavaProductServiceImpl.this.getProductBeanDisplayName(product)}));
                }
                this.setPassed(bl);
            }
            catch (Exception exception) {
                log.logEvent(this, "err", exception.getMessage());
                this.invalidate();
            }
        }

        public String getName() {
            return "patch";
        }
    }

    protected class PatchTargetCheck
    extends InstallCheck {
        protected PatchTargetCheck() {
        }

        public void execute(String string, WizardServices wizardServices, Log log) {
            try {
                boolean bl = true;
                ProductTree productTree = PureJavaProductServiceImpl.this.getProductTree(string);
                Product product = (Product)productTree.getRoot();
                if (product.isPatch()) {
                    String string2 = product.getProductTree().getInstallLocation(product);
                    SoftwareObject softwareObject = PureJavaProductServiceImpl.this.getRegistryService().getSoftwareObject(product.getKey().getUID(), string2);
                    if (softwareObject == null) {
                        bl = false;
                        log.logEvent(this, "err", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.PatchTargetCheck.invalidProductTargetForPatch", new String[]{PureJavaProductServiceImpl.this.getProductBeanDisplayName(product), string2}));
                    }
                }
                this.setPassed(bl);
            }
            catch (Exception exception) {
                log.logEvent(this, "err", exception.getMessage());
                this.invalidate();
            }
        }

        public String getName() {
            return "patchtarget";
        }
    }

    protected class UpdateCheck
    extends InstallCheck {
        protected UpdateCheck() {
        }

        public void execute(String string, WizardServices wizardServices, Log log) {
            try {
                String string2;
                GenericSoftwareObject genericSoftwareObject;
                boolean bl;
                block6: {
                    bl = true;
                    ProductTree productTree = PureJavaProductServiceImpl.this.getProductTree(string);
                    genericSoftwareObject = (GenericSoftwareObject)productTree.getRoot();
                    String string3 = genericSoftwareObject.getKey().getUID();
                    String string4 = productTree.getInstallLocation(genericSoftwareObject);
                    string2 = "";
                    try {
                        SoftwareObject softwareObject = PureJavaProductServiceImpl.this.getRegistryService().getSoftwareObject(string3, string4);
                        if (softwareObject != null) {
                            boolean bl2 = bl = PureJavaProductServiceImpl.this.compareKeyVersions(genericSoftwareObject, softwareObject) >= 0;
                            string2 = softwareObject instanceof GenericSoftwareObject ? PureJavaProductServiceImpl.this.getProductBeanDisplayName((GenericSoftwareObject)softwareObject) : softwareObject.getDisplayName();
                        }
                    }
                    catch (Exception exception) {
                        if (productTree.getUninstallTree() == null) break block6;
                        SoftwareObject softwareObject = (SoftwareObject)((Object)productTree.getUninstallTree().getRoot());
                        bl = PureJavaProductServiceImpl.this.compareKeyVersions(genericSoftwareObject, softwareObject) >= 0;
                        string2 = softwareObject instanceof GenericSoftwareObject ? PureJavaProductServiceImpl.this.getProductBeanDisplayName((GenericSoftwareObject)softwareObject) : softwareObject.getDisplayName();
                    }
                }
                if (!bl) {
                    log.logEvent(this, "err", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.UpdateCheck.installingProductOlder", new String[]{PureJavaProductServiceImpl.this.getProductBeanDisplayName(genericSoftwareObject), string2}));
                }
                this.setPassed(bl);
            }
            catch (Exception exception) {
                log.logEvent(this, "err", exception.getMessage());
                this.invalidate();
            }
        }

        public String getName() {
            return "update";
        }
    }

    private class InstallProduct
    extends InstallableObjectVisitor {
        InstallProduct() {
        }

        boolean actionsFailed(Object object) {
            int n = (Integer)object;
            return n != 0;
        }

        boolean actionsReplaceFailed(Object object) {
            int n = (Integer)object;
            return n != 0;
        }

        private void addParentInVPD(ProductBean productBean, SoftwareObjectKey softwareObjectKey) throws ServiceException {
            ProductBean productBean2 = productBean.getProductTree().getParent(productBean);
            SoftwareObjectKey softwareObjectKey2 = null;
            if (productBean2 == null) {
                softwareObjectKey2 = softwareObjectKey;
            } else if (productBean2 instanceof SoftwareObject) {
                softwareObjectKey2 = ((SoftwareObject)((Object)productBean2)).getKey();
            } else if (productBean2 instanceof SoftwareObjectReference) {
                softwareObjectKey2 = ((SoftwareObjectReference)productBean2).getKey();
            }
            if (softwareObjectKey2 != null && (this.installing(productBean.getProductTree(), softwareObjectKey2) || this.replacing(productBean.getProductTree(), softwareObjectKey2) || this.installed(productBean.getProductTree(), softwareObjectKey2))) {
                PureJavaProductServiceImpl.this.getRegistryService().addParentSoftwareObjects(softwareObjectKey, new SoftwareObjectKey[]{softwareObjectKey2});
            }
        }

        private void addToVPD(GenericSoftwareObject genericSoftwareObject, SoftwareObject softwareObject) throws ServiceException {
            if (softwareObject == null) {
                SoftwareObjectKey softwareObjectKey = PureJavaProductServiceImpl.this.setSoftwareObject(genericSoftwareObject);
                SoftwareObjectUtils.updateKey(genericSoftwareObject.getKey(), softwareObjectKey);
                this.addParentInVPD(genericSoftwareObject, genericSoftwareObject.getKey());
                this.updateRequiredOnParent(genericSoftwareObject, genericSoftwareObject.getKey());
                this.updateParentOnChildren(genericSoftwareObject, genericSoftwareObject.getKey());
            } else {
                SoftwareObjectKey softwareObjectKey = PureJavaProductServiceImpl.this.getRegistryService().updateSoftwareObject(softwareObject, genericSoftwareObject);
                SoftwareObjectUtils.updateKey(genericSoftwareObject.getKey(), softwareObjectKey);
            }
        }

        private void appendBeanToUninstallTree(GenericSoftwareObject genericSoftwareObject, GenericSoftwareObject genericSoftwareObject2, ProductTree productTree) throws OperationRejectedException {
            productTree.add(genericSoftwareObject, genericSoftwareObject2);
            this.initializeBean(genericSoftwareObject2, genericSoftwareObject.getServices());
        }

        private int checkCanceled(ProductActionSupport productActionSupport) {
            if (productActionSupport.getOperationState().isCanceled()) {
                productActionSupport.logEvent(this, "err", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.installationCanceled"));
                PureJavaProductServiceImpl.this.getServices().logEvent(this, "err", "User cancelled installation.");
                return 3;
            }
            return 0;
        }

        boolean checkInstalledVersion(SoftwareObject softwareObject, SoftwareObject softwareObject2, ProductActionSupport productActionSupport, Log log) throws ServiceException {
            boolean bl = super.checkInstalledVersion(softwareObject, softwareObject2, productActionSupport, log);
            if (bl) {
                softwareObject2.setInstallStatus(3);
                SoftwareObjectUtils.updateKey(softwareObject2.getKey(), softwareObject.getKey());
            } else {
                GenericSoftwareObject genericSoftwareObject = (GenericSoftwareObject)softwareObject2;
                if (ProductTree.isReplaceInstall(genericSoftwareObject)) {
                    genericSoftwareObject.setInstallStatus(6);
                } else {
                    genericSoftwareObject.setInstallStatus(2);
                }
                this.addToVPD(genericSoftwareObject, softwareObject);
                ProductTree productTree = genericSoftwareObject.getProductTree().getUninstallTree();
                String string = genericSoftwareObject.getProductTree().getInstallLocation(genericSoftwareObject);
                if (ProductTree.isReplaceInstall(genericSoftwareObject)) {
                    SoftwareObject softwareObject3 = productTree.findSoftwareObject(genericSoftwareObject.getKey().getUID(), string);
                    if (softwareObject3 == null) {
                        this.processInsertSoftwareObject(genericSoftwareObject, productTree, productActionSupport);
                    } else {
                        this.processReplaceSoftwareObject(softwareObject3, genericSoftwareObject, productTree, productActionSupport);
                    }
                }
            }
            return bl;
        }

        private void checkUninstallerJVMResolution(ProductTree productTree, ProductTree productTree2, ProductActionSupport productActionSupport) throws ServiceException {
            boolean bl = productTree.getUninstallerJVMResolution().isActive() && productTree2.getUninstallerJVMResolution().isActive() ? (((SoftwareObject)((Object)productTree.getRoot())).getInstallStatus() == 3 ? productTree2.getUninstallerJVMResolution().getResolveOnReinstalls() : true) : false;
            if (bl) {
                try {
                    productTree.getUninstallerJVMResolution().install(productActionSupport);
                }
                catch (ProductException productException) {
                    throw new ServiceException(productException);
                }
            }
        }

        private GenericSoftwareObject clone(GenericSoftwareObject genericSoftwareObject) throws IOException {
            return (GenericSoftwareObject)ProductTree.copyBean(genericSoftwareObject);
        }

        private String[] createDirs(String string, FileService fileService) throws ServiceException, IOException {
            fileService.validateFileName(string);
            Stack<String> stack = new Stack<String>();
            String string2 = string;
            while (string2 != null && !fileService.fileExists(string2)) {
                stack.push(string2);
                string2 = fileService.getParent(string2);
            }
            Vector<String> vector = new Vector<String>();
            while (!stack.isEmpty()) {
                string2 = (String)stack.pop();
                if (fileService.fileExists(string2)) continue;
                try {
                    fileService.createDirectory(string2);
                    vector.addElement(string2);
                }
                catch (ServiceException serviceException) {
                    throw new IOException("Could not create directory " + string2);
                }
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }

        Object getDefaultResult() {
            return new Integer(0);
        }

        protected Object getReplaceValue(String string) {
            return PureJavaProductServiceImpl.this.getServices().getValue(string);
        }

        boolean getResolveProductReferences() {
            return false;
        }

        Object getResultForAppendProductAction(ProductAction productAction, SoftwareObject softwareObject, ProductTree productTree, ProductActionSupport productActionSupport) throws ServiceException {
            int n;
            if (System.getProperty("is.debug.order") != null) {
                productActionSupport.logEvent(this, "wrn", "Appending:  id = " + productAction.getBeanId() + " ; " + "name = " + productAction.getDisplayName());
            }
            if ((n = this.checkCanceled(productActionSupport)) == 0) {
                try {
                    productAction.setTransientInstallState(true);
                    PureJavaProductServiceImpl.this.installProductAction(productAction, productActionSupport);
                    ProductBean productBean = ProductTree.copyBean(productAction);
                    productTree.add((GenericSoftwareObject)softwareObject, productBean);
                    this.initializeBean(productBean, ((GenericSoftwareObject)softwareObject).getServices());
                    n = this.checkCanceled(productActionSupport);
                }
                catch (Throwable throwable) {
                    ProductComponent productComponent = productAction.getParentComponent();
                    n = productComponent.getProductTree().getReplaceFailureOption(productComponent);
                    String string = productComponent.getOnReplaceFailSummaryMessage();
                    string = string == null || string.length() == 0 ? LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.replaceFailed") : PureJavaProductServiceImpl.this.getServices().resolveString(string);
                    string = PureJavaProductServiceImpl.this.appendLogFileToMsg(string);
                    productActionSupport.logEvent(this, "err", string);
                    PureJavaProductServiceImpl.this.getServices().logEvent(productAction, "err", string);
                    PureJavaProductServiceImpl.this.getServices().logEvent(productAction, "err", throwable);
                }
            }
            return new Integer(n);
        }

        Object getResultForProductAction(ProductAction productAction, ProductActionSupport productActionSupport) throws ServiceException {
            int n;
            if (System.getProperty("is.debug.order") != null) {
                productActionSupport.logEvent(this, "wrn", "Install:  id = " + productAction.getBeanId() + " ; " + "name = " + productAction.getDisplayName());
            }
            if ((n = this.checkCanceled(productActionSupport)) == 0) {
                try {
                    productAction.setTransientInstallState(true);
                    PureJavaProductServiceImpl.this.installProductAction(productAction, productActionSupport);
                    n = this.checkCanceled(productActionSupport);
                }
                catch (Throwable throwable) {
                    ProductComponent productComponent = productAction.getParentComponent();
                    n = productComponent.getProductTree().getInstallFailureOption(productComponent);
                    String string = productComponent.getOnFailSummaryMessage();
                    string = string == null || string.length() == 0 ? LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.installationFailed") : PureJavaProductServiceImpl.this.getServices().resolveString(string);
                    string = PureJavaProductServiceImpl.this.appendLogFileToMsg(string);
                    productActionSupport.logEvent(this, "err", string);
                    PureJavaProductServiceImpl.this.getServices().logEvent(productAction, "err", string);
                    PureJavaProductServiceImpl.this.getServices().logEvent(productAction, "err", throwable);
                }
            }
            return new Integer(n);
        }

        Object getResultForRemoveProductAction(SoftwareObject softwareObject, UninstallProductAction uninstallProductAction, ProductTree productTree, ProductActionSupport productActionSupport) throws ServiceException {
            int n = this.checkCanceled(productActionSupport);
            if (n == 0) {
                try {
                    uninstallProductAction.setTransientInstallState(true);
                    ProductAction productAction = this.findAction((ProductComponent)softwareObject, uninstallProductAction.getTargetBeanId());
                    if (System.getProperty("is.debug.order") != null) {
                        productActionSupport.logEvent(this, "wrn", "Removing:  id = " + productAction.getBeanId() + " ; " + "name = " + productAction.getDisplayName());
                    }
                    PureJavaProductServiceImpl.this.uninstallProductAction(productAction, productActionSupport);
                    productTree.remove(productAction);
                    n = this.checkCanceled(productActionSupport);
                }
                catch (Throwable throwable) {
                    ProductComponent productComponent = uninstallProductAction.getParentComponent();
                    n = productComponent.getProductTree().getReplaceFailureOption(productComponent);
                    String string = productComponent.getOnReplaceFailSummaryMessage();
                    string = string == null || string.length() == 0 ? LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.replaceFailed") : PureJavaProductServiceImpl.this.getServices().resolveString(string);
                    string = PureJavaProductServiceImpl.this.appendLogFileToMsg(string);
                    productActionSupport.logEvent(this, "err", string);
                    PureJavaProductServiceImpl.this.getServices().logEvent(uninstallProductAction, "err", string);
                    PureJavaProductServiceImpl.this.getServices().logEvent(uninstallProductAction, "err", throwable);
                }
            }
            return new Integer(n);
        }

        Object getResultForReplaceProductAction(ProductAction productAction, ProductAction productAction2, SoftwareObject softwareObject, ProductTree productTree, ProductActionSupport productActionSupport) throws ServiceException {
            int n;
            if (System.getProperty("is.debug.order") != null) {
                productActionSupport.logEvent(this, "wrn", "Replacing:  id = " + productAction.getBeanId() + " ; " + "name = " + productAction.getDisplayName());
            }
            if ((n = this.checkCanceled(productActionSupport)) == 0) {
                try {
                    productAction2.setTransientInstallState(true);
                    if (softwareObject.getInstallStatus() == 3) {
                        PureJavaProductServiceImpl.this.replaceProductAction(productAction2, productAction, productActionSupport);
                    } else {
                        PureJavaProductServiceImpl.this.installProductAction(productAction2, productActionSupport);
                        ProductBean productBean = ProductTree.copyBean(productAction2);
                        int n2 = productTree.getChildIndex(productAction);
                        productTree.insert((GenericSoftwareObject)softwareObject, n2, productBean);
                        productTree.remove(productAction);
                        this.initializeBean(productBean, ((GenericSoftwareObject)softwareObject).getServices());
                    }
                    n = this.checkCanceled(productActionSupport);
                }
                catch (Throwable throwable) {
                    ProductComponent productComponent = productAction2.getParentComponent();
                    n = productComponent.getProductTree().getReplaceFailureOption(productComponent);
                    String string = productComponent.getOnReplaceFailSummaryMessage();
                    string = string == null || string.length() == 0 ? LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.replaceFailed") : PureJavaProductServiceImpl.this.getServices().resolveString(string);
                    string = PureJavaProductServiceImpl.this.appendLogFileToMsg(string);
                    productActionSupport.logEvent(this, "err", string);
                    PureJavaProductServiceImpl.this.getServices().logEvent(productAction2, "err", string);
                    PureJavaProductServiceImpl.this.getServices().logEvent(productAction2, "err", throwable);
                }
            }
            return new Integer(n);
        }

        private String[] getSelectedLocales(ProductBean productBean) {
            String[] stringArray = new String[]{};
            ProductTree productTree = productBean.getProductTree();
            if (productTree != null && productTree.getSelectedLocales() != null) {
                stringArray = LocaleUtils.parseLocales(productTree.getSelectedLocales());
            }
            return stringArray;
        }

        private void initializeBean(ProductBean productBean, WizardServices wizardServices) {
            ProductBean productBean2 = productBean.getProductTree().getFirstChild(productBean);
            while (productBean2 != null) {
                this.initializeBean(productBean2, wizardServices);
                productBean2 = productBean.getProductTree().getNextSibling(productBean2);
            }
            productBean.initialize(wizardServices);
            if (productBean instanceof SoftwareObject) {
                ((SoftwareObject)((Object)productBean)).setActiveForUninstall(true);
            }
        }

        int install(ProductTree productTree, AsynchronousOperation asynchronousOperation, LogSummary logSummary) throws IOException, ServiceException, ProductException {
            int n = (Integer)this.getDefaultResult();
            Product product = (Product)productTree.getRoot();
            if (product.isActive() && product.conditionsMet() && this.isLocaleMet(product)) {
                Object[] objectArray;
                Object object;
                Object object2;
                ProductTree productTree2;
                asynchronousOperation.setPercentComplete(0);
                String string = new String();
                String string2 = PureJavaProductServiceImpl.this.getProductBeanDisplayName(productTree.getRoot());
                WizardServices wizardServices = PureJavaProductServiceImpl.this.getServices();
                string = wizardServices.resolveString(string2);
                String[] stringArray = new String[]{string};
                asynchronousOperation.setStatusDescription(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.Installer.installing", stringArray));
                boolean bl = ProductTree.isReplaceInstall(productTree);
                if (!bl) {
                    PureJavaProductServiceImpl.this.configureUninstallerForCreation(productTree);
                    productTree2 = productTree;
                } else {
                    productTree2 = productTree.getUninstallTree();
                    object2 = productTree2.getUninstallerArchive();
                    object = productTree.getUninstallerArchive();
                    ((UninstallerArchive)object2).setClassUpdateExclusions(((UninstallerArchive)object).getClassUpdateExclusions());
                    ((UninstallerArchive)object2).setResourceExclusions(((UninstallerArchive)object).getResourceExclusions());
                }
                object2 = FileUtils.createTempFile();
                object = productTree2.getUninstallerArchive().getUninstallerResId();
                UninstallResources uninstallResources = new UninstallResources(null, (String)object2, (String)object);
                ProductActionSupport productActionSupport = PureJavaProductServiceImpl.this.createProductActionSupport(uninstallResources, asynchronousOperation, productTree2.getUninstallerArchive());
                productActionSupport.addLogListener(logSummary);
                PureJavaProductServiceImpl.this.preInstallProduct(productTree, productActionSupport);
                String string3 = ((Product)productTree.getRoot()).getAbsoluteInstallLocation();
                FileService fileService = (FileService)PureJavaProductServiceImpl.this.getServices().getService("fileService");
                if (!fileService.fileExists(string3)) {
                    objectArray = this.createDirs(string3, fileService);
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        productTree2.getUninstallerArchive().putInstalledFile(objectArray[n2]);
                        ++n2;
                    }
                }
                PureJavaProductServiceImpl.this.configureWizardLogForInstall(productTree);
                if (!bl) {
                    PureJavaProductServiceImpl.this.setProductUninstaller(productTree2);
                } else {
                    PureJavaProductServiceImpl.this.updateProductUninstaller(productTree, productTree2);
                }
                asynchronousOperation.setEstimatedTimeToComplete(Math.max(new TimeToInstall().getEstimatedTimeToInstall(productTree.getRoot(), productTree, new ProductTreeSource(PureJavaProductServiceImpl.this.getServices()), PureJavaProductServiceImpl.this.getRegistryService(), PureJavaProductServiceImpl.this), 0));
                objectArray = new RequiredResourceIndices().getRequiredResourceIndices(productTree.getRoot(), productTree, new ProductTreeSource(PureJavaProductServiceImpl.this.getServices()), PureJavaProductServiceImpl.this.getRegistryService(), PureJavaProductServiceImpl.this);
                WizardServicesImpl wizardServicesImpl = (WizardServicesImpl)productTree.getRoot().getServices();
                wizardServicesImpl.queueIndexedResources((ResourceIndexRange[])objectArray);
                try {
                    try {
                        this.checkUninstallerJVMResolution(productTree2, productTree, productActionSupport);
                        asynchronousOperation.setLastMessage("install.start");
                        if (System.getProperty("is.debug.order") != null) {
                            productActionSupport.logEvent(this, "wrn", "Installing:");
                        }
                        n = (Integer)this.visitProductBeans(productTree.getRoot(), new ProductTreeSource(PureJavaProductServiceImpl.this.getServices()), productActionSupport, PureJavaProductServiceImpl.this.getRegistryService(), PureJavaProductServiceImpl.this);
                        asynchronousOperation.setLastMessage("install.finish");
                        switch (n) {
                            case 0: 
                            case 1: {
                                PureJavaProductServiceImpl.this.markProductBeanInstalled(productTree.getRoot(), productTree, productActionSupport);
                                if (productTree.getRoot() instanceof Product && ((Product)productTree.getRoot()).getInstallStatus() == 3) {
                                    PureJavaProductServiceImpl.this.getRegistryService().finalizeRegistry();
                                    asynchronousOperation.setStatusDescription(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.Installer.createUninstaller"));
                                    break;
                                }
                                n = 2;
                                break;
                            }
                            case 3: {
                                PureJavaProductServiceImpl.this.setExitCode(2002);
                                this.rollbackProduct(productTree, productActionSupport);
                                PureJavaProductServiceImpl.this.markProductBeanInstalled(productTree.getRoot(), productTree, productActionSupport);
                                if (productTree.getUninstallTree() != null) {
                                    PureJavaProductServiceImpl.this.markProductBeanInstalled(productTree.getUninstallTree().getRoot(), productTree.getUninstallTree(), productActionSupport);
                                }
                                if (!bl) {
                                    this.rollbackUninstallerJVMResolution(productTree2, productActionSupport);
                                }
                                if (!bl) break;
                                PureJavaProductServiceImpl.this.getRegistryService().finalizeRegistry();
                                break;
                            }
                            case 2: {
                                PureJavaProductServiceImpl.this.setExitCode(2002);
                                PureJavaProductServiceImpl.this.markProductBeanInstalled(productTree.getRoot(), productTree, productActionSupport);
                                if (productTree.getUninstallTree() != null) {
                                    PureJavaProductServiceImpl.this.markProductBeanInstalled(productTree.getUninstallTree().getRoot(), productTree.getUninstallTree(), productActionSupport);
                                }
                                PureJavaProductServiceImpl.this.getRegistryService().finalizeRegistry();
                                break;
                            }
                        }
                        if (PureJavaProductServiceImpl.this.canContinueInstall(n)) {
                            PureJavaProductServiceImpl.this.postInstallProduct(productTree, productActionSupport);
                        }
                        if (PureJavaProductServiceImpl.this.canContinueInstall(n)) {
                            uninstallResources.write();
                        }
                        uninstallResources.close();
                        if (PureJavaProductServiceImpl.this.canContinueInstall(n) || bl) {
                            asynchronousOperation.setLastMessage("uninstall.create.start");
                            if (!bl && productTree2.getUninstallerLauncher().isActive()) {
                                productTree2.getUninstallerLauncher().install(productActionSupport);
                            }
                            UninstallerArchive uninstallerArchive = productTree2.getUninstallerArchive();
                            uninstallerArchive.setUninstallResources((String)object2);
                            uninstallerArchive.install(productActionSupport);
                            PureJavaProductServiceImpl.this.registerUninstaller(productTree2);
                            asynchronousOperation.setLastMessage("uninstall.create.finish");
                        }
                    }
                    catch (IOException iOException) {
                        PureJavaProductServiceImpl.this.setExitCode(2002);
                        throw iOException;
                    }
                    catch (ServiceException serviceException) {
                        PureJavaProductServiceImpl.this.setExitCode(2002);
                        throw serviceException;
                    }
                    catch (ProductException productException) {
                        PureJavaProductServiceImpl.this.setExitCode(2002);
                        throw productException;
                    }
                    Object var21_25 = null;
                    wizardServicesImpl.clearIndexedResourceQueue();
                }
                catch (Throwable throwable) {
                    Object var21_26 = null;
                    wizardServicesImpl.clearIndexedResourceQueue();
                    throw throwable;
                }
            }
            return n;
        }

        private boolean installed(ProductTree productTree, SoftwareObjectKey softwareObjectKey) {
            SoftwareObject softwareObject = productTree.resolveKey(softwareObjectKey);
            return this.isObjectInstalled(softwareObject);
        }

        private boolean installing(ProductTree productTree, SoftwareObjectKey softwareObjectKey) {
            SoftwareObject softwareObject = productTree.resolveKey(softwareObjectKey);
            return this.isObjectInstalling(softwareObject);
        }

        private boolean isLocaleMet(ProductBean productBean) {
            boolean bl = true;
            if (productBean instanceof SoftwareObject) {
                bl = false;
                String[] stringArray = this.getSelectedLocales(productBean);
                String string = ((SoftwareObject)((Object)productBean)).getLocale();
                if (string != null && string.length() > 0) {
                    int n = 0;
                    while (!bl && n < stringArray.length) {
                        bl = string.equals(stringArray[n]);
                        ++n;
                    }
                } else {
                    bl = true;
                }
            }
            return bl;
        }

        protected void logCantReplace(SoftwareObject softwareObject, SoftwareObject softwareObject2, ProductActionSupport productActionSupport, Log log) {
            String string = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.InstallProduct.couldNotReplaceSoftwareObject", new String[]{softwareObject.getDisplayName(), softwareObject2.getDisplayName()});
            if (log != null) {
                log.logEvent(this, "msg1", string);
            }
        }

        private String mapResponse(String string) {
            String string2 = PureJavaProductServiceImpl.YES_RESPONSE;
            if (string.equals(PureJavaProductServiceImpl.this.getServices().resolveString(PureJavaProductServiceImpl.YES))) {
                string2 = PureJavaProductServiceImpl.YES_RESPONSE;
            } else if (string.equals(this.resolveString(PureJavaProductServiceImpl.YES_TO_ALL))) {
                string2 = PureJavaProductServiceImpl.YES_TO_ALL_RESPONSE;
            } else if (string.equals(this.resolveString(PureJavaProductServiceImpl.NO))) {
                string2 = PureJavaProductServiceImpl.NO_RESPONSE;
            } else if (string.equals(this.resolveString(PureJavaProductServiceImpl.NO_TO_ALL))) {
                string2 = PureJavaProductServiceImpl.NO_TO_ALL_RESPONSE;
            }
            return string2;
        }

        void postVisitComponent(ProductBean productBean, ProductActionSupport productActionSupport) throws ServiceException {
            PureJavaProductServiceImpl.this.postInstallProductComponent(productBean, productActionSupport);
        }

        boolean preVisitComponent(ProductBean productBean, ProductActionSupport productActionSupport) throws ServiceException {
            return PureJavaProductServiceImpl.this.preInstallProductComponent(productBean, productActionSupport);
        }

        void processActionsFailed(ProductBean productBean, ProductActionSupport productActionSupport, ProductTreeIterator productTreeIterator) throws ServiceException {
            ProductBean productBean2 = productTreeIterator.getNext(productTreeIterator.begin());
            while (productBean2 != productTreeIterator.end()) {
                ProductAction productAction = (ProductAction)productBean2;
                if (productAction.getTransientInstallState()) {
                    try {
                        PureJavaProductServiceImpl.this.uninstallProductAction(productAction, productActionSupport);
                    }
                    catch (Throwable throwable) {
                        String string = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.uninstallationFailed");
                        string = PureJavaProductServiceImpl.this.appendLogFileToMsg(string);
                        productActionSupport.logEvent(this, "err", string);
                        PureJavaProductServiceImpl.this.getServices().logEvent(this, "err", string);
                        PureJavaProductServiceImpl.this.getServices().logEvent(productAction, "err", throwable);
                    }
                    productAction.setTransientInstallState(false);
                }
                productBean2 = productTreeIterator.getNext(productBean2);
            }
            PureJavaProductServiceImpl.this.rollbackProductComponent((ProductComponent)productBean);
            ((ProductComponent)productBean).setInstallStatus(0);
        }

        void processActionsReplaceFailed(ProductBean productBean, ProductActionSupport productActionSupport) throws ServiceException {
        }

        private void processInsertSoftwareObject(SoftwareObject softwareObject, ProductTree productTree, ProductActionSupport productActionSupport) throws ServiceException {
            block5: {
                if (!(softwareObject instanceof GenericSoftwareObject)) break block5;
                try {
                    GenericSoftwareObject genericSoftwareObject = (GenericSoftwareObject)softwareObject;
                    Vector<GenericSoftwareObject> vector = new Vector<GenericSoftwareObject>();
                    SoftwareObject softwareObject2 = null;
                    ProductBean productBean = genericSoftwareObject.getProductTree().getParent(genericSoftwareObject);
                    while (softwareObject2 == null && productBean != null) {
                        softwareObject2 = productTree.findSoftwareObject(((SoftwareObject)((Object)productBean)).getKey().getUID(), genericSoftwareObject.getProductTree().getInstallLocation(productBean));
                        if (softwareObject2 != null) continue;
                        vector.addElement(this.clone((GenericSoftwareObject)productBean));
                        productBean = genericSoftwareObject.getProductTree().getParent(productBean);
                    }
                    if (softwareObject2 == null) {
                        PureJavaProductServiceImpl.this.getServices().logEvent(this, "err", "could not add SoftwareObject " + softwareObject.getDisplayName() + " to existing product");
                        throw new Error();
                    }
                    int n = vector.size() - 1;
                    while (n >= 0) {
                        GenericSoftwareObject genericSoftwareObject2 = (GenericSoftwareObject)vector.elementAt(n);
                        this.appendBeanToUninstallTree((GenericSoftwareObject)softwareObject2, genericSoftwareObject2, productTree);
                        softwareObject2 = genericSoftwareObject2;
                        --n;
                    }
                    this.appendBeanToUninstallTree((GenericSoftwareObject)softwareObject2, this.clone((GenericSoftwareObject)softwareObject), productTree);
                }
                catch (Throwable throwable) {
                    String string = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.insertionFailed", new String[]{softwareObject.getDisplayName()});
                    productActionSupport.logEvent(this, "err", string);
                    PureJavaProductServiceImpl.this.getServices().logEvent(this, "err", string);
                    PureJavaProductServiceImpl.this.getServices().logEvent(this, "err", throwable);
                }
            }
        }

        Object processNewResult(Object object, Object object2) {
            return object2;
        }

        void processReplaceSoftwareObject(SoftwareObject softwareObject, SoftwareObject softwareObject2, ProductTree productTree, ProductActionSupport productActionSupport) throws ServiceException {
            StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(productTree, true);
            ProductBean productBean = standardProductTreeIterator.getNext(standardProductTreeIterator.begin());
            while (productBean != null && productBean != standardProductTreeIterator.end()) {
                SoftwareObjectReference softwareObjectReference;
                if (productBean instanceof SoftwareObjectReference && (softwareObjectReference = (SoftwareObjectReference)productBean).getKey().equals(softwareObject.getKey())) {
                    SoftwareObjectUtils.updateKey(softwareObjectReference.getKey(), softwareObject2.getKey());
                }
                productBean = standardProductTreeIterator.getNext(productBean);
            }
            SoftwareObjectUtils.updateKey(softwareObject.getKey(), softwareObject2.getKey());
            SoftwareObjectUtils.transferStaticProperties(softwareObject, softwareObject2);
        }

        boolean promptToReplace(SoftwareObject softwareObject, SoftwareObject softwareObject2, int n, ProductActionSupport productActionSupport) {
            try {
                if (this.getReplaceValue(PureJavaProductServiceImpl.REPLACE_EXISTING) == null) {
                    this.setReplaceValue(PureJavaProductServiceImpl.REPLACE_EXISTING, "unspecified");
                }
                if (this.getReplaceValue(PureJavaProductServiceImpl.REPLACE_NEWER) == null) {
                    this.setReplaceValue(PureJavaProductServiceImpl.REPLACE_NEWER, "unspecified");
                }
                if (n == 4) {
                    this.refreshReplaceNewerResponse(softwareObject);
                    String string = (String)this.getReplaceValue(PureJavaProductServiceImpl.REPLACE_NEWER);
                    return string.equals(PureJavaProductServiceImpl.YES_RESPONSE) || string.equals(PureJavaProductServiceImpl.YES_TO_ALL_RESPONSE);
                }
                if (n == 5) {
                    if (PureJavaProductServiceImpl.this.compareKeys(softwareObject2, softwareObject) < 0) {
                        this.refreshReplaceNewerResponse(softwareObject);
                        String string = (String)this.getReplaceValue(PureJavaProductServiceImpl.REPLACE_NEWER);
                        return string.equals(PureJavaProductServiceImpl.YES_RESPONSE) || string.equals(PureJavaProductServiceImpl.YES_TO_ALL_RESPONSE);
                    }
                    this.refreshReplaceExistingResponse(softwareObject, PureJavaProductServiceImpl.this.compareKeys(softwareObject2, softwareObject) > 0);
                    String string = (String)this.getReplaceValue(PureJavaProductServiceImpl.REPLACE_EXISTING);
                    return string.equals(PureJavaProductServiceImpl.YES_RESPONSE) || string.equals(PureJavaProductServiceImpl.YES_TO_ALL_RESPONSE);
                }
                productActionSupport.logEvent(this, "err", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.InstallProduct.illegalReplaceOption", new String[]{String.valueOf(n)}));
                return false;
            }
            catch (Exception exception) {
                productActionSupport.logEvent(this, "err", exception);
                return false;
            }
        }

        protected final void refreshReplaceExistingResponse(SoftwareObject softwareObject, boolean bl) throws ServiceException {
            String string = (String)this.getReplaceValue(PureJavaProductServiceImpl.REPLACE_EXISTING);
            if (!string.equals(PureJavaProductServiceImpl.YES_TO_ALL_RESPONSE) && !string.equals(PureJavaProductServiceImpl.NO_TO_ALL_RESPONSE)) {
                String string2 = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.InstallProduct.alreadyExists", new String[]{softwareObject.getDisplayName()});
                if (bl) {
                    string2 = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.InstallProduct.olderVersionExists", new String[]{softwareObject.getDisplayName()});
                }
                string = (String)PureJavaProductServiceImpl.this.getServices().getUserInput(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.InstallProduct.replaceExistingSO"), string2, new Object[]{this.resolveString(PureJavaProductServiceImpl.YES), this.resolveString(PureJavaProductServiceImpl.YES_TO_ALL), this.resolveString(PureJavaProductServiceImpl.NO), this.resolveString(PureJavaProductServiceImpl.NO_TO_ALL)}, this.resolveString(PureJavaProductServiceImpl.YES));
                string = this.mapResponse(string);
                this.setReplaceValue(PureJavaProductServiceImpl.REPLACE_EXISTING, string);
            }
        }

        protected final void refreshReplaceNewerResponse(SoftwareObject softwareObject) throws ServiceException {
            String string = (String)this.getReplaceValue(PureJavaProductServiceImpl.REPLACE_NEWER);
            if (!string.equals(PureJavaProductServiceImpl.YES_TO_ALL_RESPONSE) && !string.equals(PureJavaProductServiceImpl.NO_TO_ALL_RESPONSE)) {
                string = (String)PureJavaProductServiceImpl.this.getServices().getUserInput(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.InstallProduct.replaceExistingSO"), LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.InstallProduct.newerVersionExists", new String[]{softwareObject.getDisplayName()}), new Object[]{this.resolveString(PureJavaProductServiceImpl.YES), this.resolveString(PureJavaProductServiceImpl.YES_TO_ALL), this.resolveString(PureJavaProductServiceImpl.NO), this.resolveString(PureJavaProductServiceImpl.NO_TO_ALL)}, this.resolveString(PureJavaProductServiceImpl.NO));
                string = this.mapResponse(string);
                this.setReplaceValue(PureJavaProductServiceImpl.REPLACE_NEWER, string);
            }
        }

        private boolean replacing(ProductTree productTree, SoftwareObjectKey softwareObjectKey) {
            SoftwareObject softwareObject = productTree.resolveKey(softwareObjectKey);
            return this.isObjectReplacing(softwareObject);
        }

        private String resolveString(String string) {
            return PureJavaProductServiceImpl.this.getServices().resolveString(string);
        }

        private void rollbackProduct(ProductTree productTree, ProductActionSupport productActionSupport) throws ServiceException {
            OperationKey operationKey = PureJavaProductServiceImpl.this.uninstallProduct(productTree, productActionSupport);
            AsynchronousOperation asynchronousOperation = PureJavaProductServiceImpl.this.getOperation(operationKey);
            while (!asynchronousOperation.isEnded()) {
                AsynchronousOperation asynchronousOperation2 = asynchronousOperation;
                synchronized (asynchronousOperation2) {
                    try {
                        asynchronousOperation.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new Error();
                    }
                }
            }
        }

        private void rollbackUninstallerJVMResolution(ProductTree productTree, ProductActionSupport productActionSupport) throws ProductException {
            if (productTree.getUninstallerJVMResolution().isActive()) {
                productTree.getUninstallerJVMResolution().uninstall(productActionSupport);
            }
        }

        protected void setReplaceValue(String string, Object object) {
            PureJavaProductServiceImpl.this.getServices().setValue(string, object);
        }

        boolean shouldContinue(Object object) {
            int n = (Integer)object;
            return n == 0 || n == 1;
        }

        private void updateParentOnChildren(ProductBean productBean, SoftwareObjectKey softwareObjectKey) throws ServiceException {
            Object object;
            SoftwareObjectReference[] softwareObjectReferenceArray;
            int n = productBean.getProductTree().getChildCount(productBean);
            int n2 = 0;
            while (n2 < n) {
                softwareObjectReferenceArray = productBean.getProductTree().getChild(productBean, n2);
                SoftwareObjectKey softwareObjectKey2 = null;
                if (softwareObjectReferenceArray instanceof SoftwareObject) {
                    softwareObjectKey2 = ((SoftwareObject)softwareObjectReferenceArray).getKey();
                } else if (softwareObjectReferenceArray instanceof SoftwareObjectReference) {
                    softwareObjectKey2 = ((SoftwareObjectReference)softwareObjectReferenceArray).getKey();
                }
                if (softwareObjectKey2 != null && (this.installing(softwareObjectReferenceArray.getProductTree(), softwareObjectKey2) || this.replacing(softwareObjectReferenceArray.getProductTree(), softwareObjectKey2) || this.installed(softwareObjectReferenceArray.getProductTree(), softwareObjectKey2)) && (object = PureJavaProductServiceImpl.this.getRegistryService().getSoftwareObject(softwareObjectKey2)) != null) {
                    PureJavaProductServiceImpl.this.getRegistryService().updateParentSoftwareObject(softwareObjectKey2, softwareObjectKey);
                }
                ++n2;
            }
            if (productBean instanceof SoftwareObject) {
                softwareObjectReferenceArray = ((SoftwareObject)((Object)productBean)).getRequired();
                int n3 = 0;
                while (n3 < softwareObjectReferenceArray.length) {
                    if (softwareObjectReferenceArray[n3].getKey().getInstance() != 0) {
                        object = softwareObjectReferenceArray[n3].getKey();
                        SoftwareObject softwareObject = PureJavaProductServiceImpl.this.getRegistryService().getSoftwareObject((SoftwareObjectKey)object);
                        if (softwareObject != null) {
                            PureJavaProductServiceImpl.this.getRegistryService().updateParentSoftwareObject((SoftwareObjectKey)object, softwareObjectKey);
                        }
                    }
                    ++n3;
                }
            }
        }

        private void updateRequiredOnParent(ProductBean productBean, SoftwareObjectKey softwareObjectKey) throws ServiceException {
            ProductBean productBean2 = productBean.getProductTree().getParent(productBean);
            SoftwareObjectKey softwareObjectKey2 = null;
            if (productBean2 != null) {
                if (productBean2 instanceof SoftwareObject) {
                    softwareObjectKey2 = ((SoftwareObject)((Object)productBean2)).getKey();
                } else if (productBean2 instanceof SoftwareObjectReference) {
                    softwareObjectKey2 = ((SoftwareObjectReference)productBean2).getKey();
                }
            }
            if (softwareObjectKey2 != null && (this.installing(productBean.getProductTree(), softwareObjectKey2) || this.replacing(productBean.getProductTree(), softwareObjectKey2))) {
                Object object;
                SoftwareObject softwareObject = PureJavaProductServiceImpl.this.getRegistryService().getSoftwareObject(softwareObjectKey2);
                if (softwareObject != null) {
                    object = softwareObject.getRequired();
                    int n = 0;
                    while (n < ((Object)object).length) {
                        if (((SoftwareObjectReference)object[n]).getKey().getInstance() == 0 && ((SoftwareObjectReference)object[n]).getKey().equals(softwareObjectKey)) {
                            PureJavaProductServiceImpl.this.getRegistryService().updateRequiredSoftwareObject(softwareObject.getKey(), softwareObjectKey);
                        }
                        ++n;
                    }
                }
                if (productBean2 instanceof SoftwareObject) {
                    object = (SoftwareObject)((Object)productBean2);
                    SoftwareObjectReference[] softwareObjectReferenceArray = object.getRequired();
                    int n = 0;
                    while (n < softwareObjectReferenceArray.length) {
                        if (softwareObjectReferenceArray[n].getKey().getInstance() == 0 && softwareObjectReferenceArray[n].getKey().equals(softwareObjectKey)) {
                            softwareObjectReferenceArray[n].setKey(softwareObjectKey);
                        }
                        ++n;
                    }
                }
            }
        }

        void updateSoftwareObject(ProductBean productBean, SoftwareObjectKey softwareObjectKey) throws ServiceException {
            this.addParentInVPD(productBean, softwareObjectKey);
            this.updateRequiredOnParent(productBean, softwareObjectKey);
        }
    }

    private class UninstallResources
    extends ArchiveWriter {
        private ArchiveWriterZipOutputStream out;

        /* synthetic */ UninstallResources(1 var2_2, String string, String string2) throws IOException {
            this(string, string2);
        }

        private UninstallResources(String string, String string2) throws IOException {
            File file = new File(string);
            PureJavaProductServiceImpl pureJavaProductServiceImpl2 = PureJavaProductServiceImpl.this;
            pureJavaProductServiceImpl2.getClass();
            this.out = pureJavaProductServiceImpl2.new UninstallerArchiveWriterOutputStream(file.getParent(), file.getName());
            this.initialize(new StandardResourceReaderFactory(string2), new ArchiveResourceWriterFactory(this.out, string2));
        }

        void close() throws IOException {
            block2: {
                try {
                    this.out.finish();
                    this.out.close();
                }
                catch (ZipException zipException) {
                    if (zipException.getMessage().startsWith("ZIP file must have at least one entry")) break block2;
                    throw zipException;
                }
            }
        }
    }

    private class UninstallerArchiveWriterOutputStream
    extends ArchiveWriterZipOutputStream {
        public UninstallerArchiveWriterOutputStream(String string, String string2) {
            super(string, "disk", string2, "", null);
        }

        protected void closeExternalEntry(ArchiveWriterEntry archiveWriterEntry) throws IOException {
            throw new IOException("External entries not supported for UninstallerArchive.");
        }

        protected void closeInternalEntry(ArchiveWriterEntry archiveWriterEntry) throws IOException {
            int n = archiveWriterEntry.getEntryType();
            if (n != 1) {
                if (n == 2 || n == 3) {
                    throw new IOException("Indexed entries not supported for UninstallerArchive.");
                }
                throw new IOException("Unknown archive entry type: " + archiveWriterEntry.getId());
            }
            this.closeArchiveEntry(archiveWriterEntry);
        }

        public String getApplicationArchiveName() {
            return FileUtils.createFileName(super.getArchiveRootFolder(), super.getArchiveName());
        }

        protected void putNextExternalEntry(ArchiveWriterEntry archiveWriterEntry) throws IOException {
            throw new IOException("External entries not supported for UninstallerArchive.");
        }

        protected void putNextInternalEntry(ArchiveWriterEntry archiveWriterEntry) throws IOException {
            int n = archiveWriterEntry.getEntryType();
            if (n != 1) {
                if (n == 2 || n == 3) {
                    throw new IOException("Indexed entries not supported for UninstallerArchive.");
                }
                throw new IOException("Unknown archive entry type: " + archiveWriterEntry.getId());
            }
            this.putNextArchiveEntry(archiveWriterEntry);
        }

        protected boolean requireMediaInfs() {
            return false;
        }

        protected void writeToExternalArchive(byte[] byArray, int n, int n2) throws IOException {
            throw new IOException("External entries not supported for UninstallerArchive.");
        }
    }

    protected class UninstallerInfo {
        public final int NOT_AVAILABLE = 1;
        public final int AVAILABLE = 2;
        public final int OBTAINABLE = 3;
        private int uninstallerStatus = 1;
        private String productInstallLocation = "";
        private String installLocation = "";
        private String archiveFileName = "";
        private String dataFileName = "";
        private String launcherFileName = "";
        private String uninstallerResId = "";

        public void decodeRegistryValue(String string) {
            CommandLineTokenizer commandLineTokenizer = new CommandLineTokenizer(string);
            if (commandLineTokenizer.hasMoreElements()) {
                this.setInstallLocation((String)commandLineTokenizer.nextElement());
            } else {
                this.setInstallLocation("");
            }
            if (commandLineTokenizer.hasMoreElements()) {
                this.setArchiveFileName((String)commandLineTokenizer.nextElement());
            } else {
                this.setArchiveFileName("");
            }
            if (commandLineTokenizer.hasMoreElements()) {
                this.setDataFileName((String)commandLineTokenizer.nextElement());
            } else {
                this.setDataFileName("");
            }
            if (commandLineTokenizer.hasMoreElements()) {
                this.setLauncherFileName((String)commandLineTokenizer.nextElement());
            } else {
                this.setLauncherFileName("");
            }
        }

        public String encodeRegistryValue() {
            return CommandLineTokenizer.createSpaceDelimitedString(new String[]{this.installLocation, this.archiveFileName, this.dataFileName, this.launcherFileName});
        }

        public String getAbsoluteArchiveFileName() {
            String string = FileUtils.createFileName(this.productInstallLocation, FileUtils.createFileName(this.installLocation, this.archiveFileName));
            return string;
        }

        public String getAbsoluteDataFileName() {
            String string = FileUtils.createFileName(this.productInstallLocation, FileUtils.createFileName(this.installLocation, this.dataFileName));
            return string;
        }

        public String getAbsoluteDataResourceLocation() {
            return String.valueOf(this.getAbsoluteDataFileName()) + "+/" + this.uninstallerResId;
        }

        public String getArchiveFileName() {
            return this.archiveFileName;
        }

        public String getDataFileName() {
            return this.dataFileName;
        }

        public String getInstallLocation() {
            return this.installLocation;
        }

        public String getLauncherFileName() {
            return this.launcherFileName;
        }

        public String getProductInstallLocation() {
            return this.productInstallLocation;
        }

        public String getUninstallerResId() {
            return this.uninstallerResId;
        }

        public int getUninstallerStatus() {
            return this.uninstallerStatus;
        }

        public void setArchiveFileName(String string) {
            this.archiveFileName = string;
        }

        public void setDataFileName(String string) {
            this.dataFileName = string;
        }

        public void setInstallLocation(String string) {
            this.installLocation = string;
        }

        public void setLauncherFileName(String string) {
            this.launcherFileName = string;
        }

        public void setProductInstallLocation(String string) {
            this.productInstallLocation = string;
        }

        public void setUninstallerResId(String string) {
            this.uninstallerResId = string;
        }

        public void setUninstallerStatus(int n) {
            this.uninstallerStatus = n;
        }
    }

    public class ProductTreeSet {
        private ProductTree installTree;

        public ProductTreeSet(ProductTree productTree) {
            this(productTree, null);
        }

        public ProductTreeSet(ProductTree productTree, ProductTree productTree2) {
            this.installTree = productTree;
            this.setUninstallTree(productTree2);
        }

        public ProductTree getInstallTree() {
            return this.installTree;
        }

        public ProductTree getUninstallTree() {
            return this.installTree.getUninstallTree();
        }

        public void setInstallTree(ProductTree productTree) {
            this.installTree = productTree;
        }

        public void setUninstallTree(ProductTree productTree) {
            this.installTree.setUninstallTree(productTree);
        }
    }
}

