/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive;

import com.installshield.archive.ArchiveFilter;
import com.installshield.archive.ArchiveReader;
import com.installshield.archive.ClassResourceReader;
import com.installshield.archive.InputStreamResourceReader;
import com.installshield.archive.ObjectDefinitionResourceReader;
import com.installshield.archive.ResourceReader;
import com.installshield.archive.ResourceReaderFactory;
import com.installshield.archive.ResourceWriterFactory;
import com.installshield.archive.URLResourceReader;
import com.installshield.archive.UnknownResourceTypeException;
import com.installshield.util.ClassDependencyResolver;
import com.installshield.util.ClassLocator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class StandardResourceReaderFactory
implements ResourceReaderFactory {
    private ClassLocator classLocator;
    private ClassDependencyResolver dependencyResolver;
    private Vector readers = new Vector();

    public StandardResourceReaderFactory(String string) {
        this.classLocator = new ClassLocator(string);
        this.dependencyResolver = new ClassDependencyResolver(this.classLocator);
    }

    public Enumeration archiveEntries(String string, ArchiveFilter archiveFilter, ResourceWriterFactory resourceWriterFactory) throws IOException {
        ArchiveReader archiveReader = new ArchiveReader(string, this.classLocator.getClassPath());
        this.readers.addElement(archiveReader);
        return archiveReader.entries(archiveFilter, resourceWriterFactory);
    }

    public Enumeration classDependencies(String string) throws IOException {
        return this.dependencyResolver.dependencies(string);
    }

    public void close() throws IOException {
        Enumeration enumeration = this.readers.elements();
        while (enumeration.hasMoreElements()) {
            ArchiveReader archiveReader = (ArchiveReader)enumeration.nextElement();
            archiveReader.close();
        }
        this.readers.removeAllElements();
    }

    public ResourceReader createClassResourceReader(String string) throws IOException {
        return new ClassResourceReader(string, this.classLocator);
    }

    public ResourceReader createDefinitionReader(Object object, Class clazz) throws IOException {
        return new ObjectDefinitionResourceReader(object, clazz);
    }

    public ResourceReader createOtherReader(String string, Object object) throws IOException, UnknownResourceTypeException {
        throw new UnknownResourceTypeException(string);
    }

    public ResourceReader createResourceReader(InputStream inputStream) throws IOException {
        return new InputStreamResourceReader(inputStream);
    }

    public ResourceReader createResourceReader(URL uRL) throws IOException {
        return new URLResourceReader(uRL);
    }

    public Enumeration packageResources(String string, boolean bl) throws IOException {
        return this.classLocator.findPackageResources(string, bl);
    }
}

