/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.ActiveBox;
import ice.htmlbrowser.Box;
import ice.htmlbrowser.VisDocument;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;

class BoxTableCell {
    private Box boxListHead;
    private Box boxListTail;
    private int boxListCount;
    private VisDocument vis_doc = new VisDocument();
    private int width;
    private int height;
    int minWidth;
    int maxWidth;
    private int cellOriginX;
    private int cellOriginY;

    BoxTableCell() {
    }

    void activeShow() {
        Box box = this.boxListHead;
        while (box != null) {
            if (box instanceof ActiveBox) {
                ((ActiveBox)((Object)box)).activeShow();
            }
            box = box.getNext();
        }
    }

    void activeHide() {
        Box box = this.boxListHead;
        while (box != null) {
            if (box instanceof ActiveBox) {
                ((ActiveBox)((Object)box)).activeHide();
            }
            box = box.getNext();
        }
    }

    void activeInterrupt() {
        Box box = this.boxListHead;
        while (box != null) {
            if (box instanceof ActiveBox) {
                ((ActiveBox)((Object)box)).activeInterrupt();
            }
            box = box.getNext();
        }
    }

    void minMaxLayout() {
        Dimension dimension = this.vis_doc.minMaxLayout(this.boxListHead);
        this.minWidth = dimension.width;
        this.maxWidth = dimension.height;
    }

    void layout(int n, int n2) {
        this.translate(0, 0);
        this.vis_doc.doLayout(this.boxListHead, this.boxListCount, n, n2);
        this.width = this.vis_doc.docSize().width;
        this.height = this.vis_doc.docSize().height;
    }

    Dimension size() {
        return new Dimension(this.width, this.height);
    }

    void addBox(Box box) {
        if (this.boxListHead == null) {
            this.boxListHead = this.boxListTail = box;
        } else {
            this.boxListTail.setNext(box);
            this.boxListTail = box;
        }
        ++this.boxListCount;
    }

    void translate(int n, int n2) {
        Box box = this.boxListHead;
        while (box != null) {
            Point point = box.location();
            box.move(point.x - this.cellOriginX + n, point.y - this.cellOriginY + n2);
            box = box.getNext();
        }
        this.cellOriginX = n;
        this.cellOriginY = n2;
    }

    void paint(Graphics graphics) {
        this.vis_doc.paint(graphics, this.cellOriginX, this.cellOriginY);
    }

    Box mouseClicked(int n, int n2) {
        return this.vis_doc.mouseClicked(n + this.cellOriginX, n2 + this.cellOriginY, this.cellOriginY);
    }

    Box mouseMoved(int n, int n2) {
        return this.vis_doc.mouseMoved(n + this.cellOriginX, n2 + this.cellOriginY, this.cellOriginY);
    }

    void mouseDragged(int n, int n2) {
        this.vis_doc.mouseDragged(n + this.cellOriginX, n2 + this.cellOriginY, this.cellOriginY);
    }

    void setDragStart(boolean bl) {
        if (bl) {
            this.vis_doc.setDragStart(this.boxListHead);
            return;
        }
        this.vis_doc.setDragStart(this.boxListTail);
    }

    void setSelected(boolean bl) {
        Box box = this.boxListHead;
        while (box != null) {
            box.setSelected(bl);
            box = box.getNext();
        }
    }

    Box getAnchorBox(String string) {
        Box box = null;
        Box box2 = this.boxListHead;
        while (box2 != null && box == null) {
            box = box2.getAnchorBox(string);
            box2 = box2.getNext();
        }
        return box;
    }

    Box getBoxListHead() {
        return this.boxListHead;
    }

    boolean isEmpty() {
        return this.boxListHead == this.boxListTail;
    }
}

