/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.actions;

import com.installshield.util.FileUtils;
import com.installshield.util.OperationRejectedException;
import com.installshield.util.ProcessExec;
import com.installshield.wizard.AsynchronousWizardAction;
import com.installshield.wizard.UninstallerWizardBuilderSupport;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import java.io.File;
import java.io.IOException;

public class ExecWizardAction
extends AsynchronousWizardAction
implements Runnable {
    private String command = "";
    private String[] arguments = new String[0];
    private String stdoutDestination = "";
    private String stderrDestination = "";
    private boolean waitForCompletion = true;
    private String description = "";
    private boolean bundleExecutable = false;
    private ProcessExec processExec = null;
    private int secondsPerIncrement = 0;
    private int percentMilestone = 0;
    private long lastTime = 0L;

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        super.build(wizardBuilderSupport);
        try {
            if (this.bundleExecutable) {
                boolean bl = true;
                if (this.command.trim().length() == 0) {
                    wizardBuilderSupport.logEvent(this, "err", "Executable file name must be specified");
                    bl = false;
                } else {
                    this.command = this.resolveString(this.command, "command", wizardBuilderSupport);
                    if (this.command == null) {
                        bl = false;
                    }
                }
                if (bl) {
                    if (!new File(this.command).exists()) {
                        wizardBuilderSupport.logEvent(this, "err", "File not found " + this.command);
                        return;
                    }
                    String string = String.valueOf(this.getBeanId()) + File.separator + new File(FileUtils.normalizeFileName(this.command)).getName();
                    wizardBuilderSupport.putResource(this.command, string);
                    wizardBuilderSupport.putRequiredService("fileService");
                    if (wizardBuilderSupport instanceof UninstallerWizardBuilderSupport) {
                        UninstallerWizardBuilderSupport uninstallerWizardBuilderSupport = (UninstallerWizardBuilderSupport)wizardBuilderSupport;
                        if (uninstallerWizardBuilderSupport.getMode() == 0) {
                            ((UninstallerWizardBuilderSupport)wizardBuilderSupport).excludeUninstallerResource(string);
                        } else if (uninstallerWizardBuilderSupport.getMode() == 1) {
                            ((UninstallerWizardBuilderSupport)wizardBuilderSupport).removeUninstallerResourceExclusion(string);
                        }
                    }
                }
            }
            wizardBuilderSupport.putClass(this.getClass().getName());
        }
        catch (Exception exception) {
            wizardBuilderSupport.logEvent(this, "err", "Unable to build " + this.getClass().getName());
        }
    }

    public void cancel() throws OperationRejectedException {
        super.cancel();
        if (this.processExec != null) {
            this.processExec.destroy();
        }
    }

    protected ProcessExec createProcessExec() {
        try {
            String string = null;
            string = this.bundleExecutable ? this.getProcessRuntimeLocation() : this.resolveString(this.command);
            String[] stringArray = new String[this.arguments.length];
            int n = 0;
            while (n < this.arguments.length) {
                stringArray[n] = this.resolveString(this.arguments[n]);
                ++n;
            }
            this.processExec = this.waitForCompletion ? new ProcessExec(string, stringArray, this.resolveString(this.stdoutDestination), this.resolveString(this.stderrDestination)) : new ProcessExec(string, stringArray);
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
        return this.processExec;
    }

    /*
     * Unable to fully structure code
     */
    public void execute(WizardBeanEvent var1_1) {
        block7: {
            this.getState().setStatusDescription(this.resolveString(this.description));
            this.resetProgress();
            var2_2 = new Thread(this);
            var2_2.setPriority(5);
            var2_2.start();
            if (!this.waitForCompletion) ** GOTO lbl21
            while (this.processExec == null || this.processExec.getStatus() != 2 && this.processExec.getStatus() != 3) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException v0) {
                    throw new Error();
                }
                this.incrementProgress();
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                try {
                    Thread.sleep(250L);
                    continue;
                }
                catch (InterruptedException v1) {
                    throw new Error();
                }
lbl21:
                // 2 sources

                ** while (this.processExec == null || !this.processExec.getProcessStarted())
            }
        }
        if (!this.getState().isCanceled()) {
            this.getState().setPercentComplete(100);
        }
        this.processExec = null;
    }

    private void executeProcess() {
        try {
            this.processExec = this.createProcessExec();
            this.processExec.executeProcess();
        }
        catch (Exception exception) {
            this.logEvent(this, "err", exception);
        }
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public String getCommand() {
        return this.command;
    }

    public String getDescription() {
        return this.description;
    }

    private String getProcessRuntimeLocation() throws ServiceException {
        String string = null;
        String string2 = FileUtils.normalizeFileName(this.command);
        String string3 = new File(string2).getName();
        try {
            string = FileUtils.createTempFile(this.getResource(String.valueOf(this.getBeanId()) + File.separator + string3), FileUtils.getName(string3));
            FileService fileService = (FileService)this.getServices().getService("fileService");
            fileService.setFileExecutable(string);
        }
        catch (IOException iOException) {
            throw new ServiceException(315, "cannot extract executable " + string3 + ": " + iOException);
        }
        return string;
    }

    public int getReturnValue() {
        return this.processExec != null ? this.processExec.getExitCode() : 0;
    }

    public int getStatus() {
        return this.processExec != null ? this.processExec.getStatus() : 0;
    }

    public String getStderrDestination() {
        return this.stderrDestination;
    }

    public String getStdoutDestination() {
        return this.stdoutDestination;
    }

    private void incrementProgress() {
        if (this.getState().getPercentComplete() < 99) {
            if (this.getState().getPercentComplete() >= this.percentMilestone) {
                this.percentMilestone = (int)((double)this.percentMilestone + Math.floor((100 - this.percentMilestone) / 2));
                this.secondsPerIncrement *= 2;
            }
            if ((System.currentTimeMillis() - this.lastTime) / 1000L >= (long)this.secondsPerIncrement) {
                this.getState().incrementProgress(1);
                this.lastTime = System.currentTimeMillis();
            }
        }
    }

    public boolean isBundleExecutable() {
        return this.bundleExecutable;
    }

    public boolean isWaitForCompletion() {
        return this.waitForCompletion;
    }

    private void resetProgress() {
        this.secondsPerIncrement = 1;
        this.percentMilestone = 33;
        this.lastTime = System.currentTimeMillis();
        this.getState().setPercentComplete(0);
    }

    public void run() {
        this.executeProcess();
    }

    public void setArguments(String[] stringArray) {
        this.arguments = stringArray;
    }

    public void setBundleExecutable(boolean bl) {
        this.bundleExecutable = bl;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setStderrDestination(String string) {
        this.stderrDestination = string;
    }

    public void setStdoutDestination(String string) {
        this.stdoutDestination = string;
    }

    public void setWaitForCompletion(boolean bl) {
        this.waitForCompletion = bl;
    }
}

