/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.swing;

import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizard.awt.Spacing;
import com.installshield.wizard.swing.JFlowLabel;
import com.installshield.wizard.swing.SwingWizardPanelImpl;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;

public class DefaultSwingWizardPanelImpl
extends SwingWizardPanelImpl
implements FocusListener {
    private JPanel descPane = null;
    private JPanel contentPane = null;
    private JFlowLabel description = null;

    public void entering(WizardBeanEvent wizardBeanEvent) {
        this.refreshDescription();
    }

    public void focusGained(FocusEvent focusEvent) {
        Component component = (Component)focusEvent.getSource();
        int n = component.getLocation().y;
        int n2 = component.getLocation().x;
        Container container = ((Component)focusEvent.getSource()).getParent();
        while (container != null) {
            if (container instanceof JViewport) {
                Rectangle rectangle = new Rectangle(new Point(n2, n), component.getSize());
                ((JViewport)container).scrollRectToVisible(rectangle);
                n = 0;
                n2 = 0;
                component = container;
            }
            n += container.getLocation().y;
            n2 += container.getLocation().x;
            container = container.getParent();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    protected JComponent getContentPane() {
        if (this.descPane == null) {
            throw new IllegalStateException("content pane not initialized -- call super.initialize() first");
        }
        return this.contentPane;
    }

    protected JComponent getDescriptionPane() {
        return this.descPane;
    }

    public void initialize(WizardBeanEvent wizardBeanEvent) {
        super.initialize(wizardBeanEvent);
        this.setLayout(new ColumnLayout());
        this.descPane = new JPanel();
        this.add((Component)this.descPane, ColumnConstraints.createHorizontalFill());
        this.descPane.setLayout(new ColumnLayout());
        this.description = new JFlowLabel();
        this.refreshDescription();
        this.contentPane = new JPanel();
        this.add((Component)this.contentPane, ColumnConstraints.createBothFill());
    }

    public void propertyChanged(String string) {
        super.propertyChanged(string);
        if (string.equals("description")) {
            this.refreshDescription();
        }
    }

    private void refreshDescription() {
        this.descPane.removeAll();
        this.description.setText(this.resolveString(this.getPanel().getDescription()));
        if (this.description.getText().length() > 0) {
            this.descPane.add((Component)this.description, ColumnConstraints.createHorizontalFill());
            this.descPane.add(Spacing.createVerticalSpacing(6));
        }
        this.descPane.validate();
        this.descPane.repaint();
    }

    protected void registerFocusListener(FocusListener focusListener, Container container) {
        int n = 0;
        while (n < container.getComponentCount()) {
            if (container.getComponent(n) instanceof Container) {
                this.registerFocusListener(this, (Container)container.getComponent(n));
            }
            if (container.getComponent(n).isFocusTraversable()) {
                container.getComponent(n).addFocusListener(this);
            }
            ++n;
        }
    }

    protected void unregisterFocusListener(FocusListener focusListener, Container container) {
        int n = 0;
        while (n < container.getComponentCount()) {
            if (container.getComponent(n) instanceof Container) {
                this.unregisterFocusListener(this, (Container)container.getComponent(n));
            }
            if (container.getComponent(n).isFocusTraversable()) {
                container.getComponent(n).removeFocusListener(this);
            }
            ++n;
        }
    }
}

