/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32.environment;

import com.installshield.util.FileUtils;
import com.installshield.wizard.platform.common.environment.GenericEnvironmentVariableManager;
import com.installshield.wizard.platform.win32.Win32SystemUtilServiceImpl;
import com.installshield.wizard.platform.win32.environment.WindowsEnvironment;
import com.installshield.wizard.service.ServiceException;

public class WinMEEnvironmentVariableManager
extends GenericEnvironmentVariableManager {
    private Win32SystemUtilServiceImpl systemUtilSvc = null;
    private String winSystemDir = "";
    private static final String ENVIRONMENT_KEY = "System\\CurrentControlSet\\Control\\SessionManager\\Environment";

    public WinMEEnvironmentVariableManager(Win32SystemUtilServiceImpl win32SystemUtilServiceImpl, String string) {
        this.systemUtilSvc = win32SystemUtilServiceImpl;
        this.winSystemDir = string;
    }

    public void deleteVariable(String string) {
        try {
            WindowsEnvironment.winMESetEnvironmentVariable(string, null);
            this.systemUtilSvc.setRebootRequired(true);
        }
        catch (ServiceException serviceException) {}
    }

    public String getCommentString() {
        return "";
    }

    public String getEchoCommandString(String string) {
        return "";
    }

    public String getVariable(String string) {
        try {
            return WindowsEnvironment.winMEGetRawEnvironmentVariable(string);
        }
        catch (ServiceException serviceException) {
            return null;
        }
    }

    protected void initializeImpl() {
    }

    public void makeUpdatePersistent() {
        String string = String.valueOf(FileUtils.appendSeparator(this.winSystemDir)) + "regenv32 -" + this.winSystemDir.charAt(0) + "2";
        try {
            if (System.getProperty("is.debug") != null) {
                System.out.println("Executing " + string);
            }
            Process process = Runtime.getRuntime().exec(string);
            int n = process.waitFor();
            if (System.getProperty("is.debug") != null) {
                System.out.println("  Result = " + n);
            }
        }
        catch (Throwable throwable) {}
    }

    public void setVariable(String string, String string2) {
        try {
            WindowsEnvironment.winMESetEnvironmentVariable(string, string2);
            this.systemUtilSvc.setRebootRequired(true);
        }
        catch (ServiceException serviceException) {}
    }

    public boolean variableExists(String string) {
        try {
            return WindowsEnvironment.winMEGetRawEnvironmentVariable(string) != null;
        }
        catch (ServiceException serviceException) {
            return false;
        }
    }
}

