/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32;

import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.LockedFilesHandler;
import com.installshield.wizard.platform.common.environment.EnvironmentVariableManager;
import com.installshield.wizard.platform.common.environment.GenericEnvironmentVariableManager;
import com.installshield.wizard.platform.win32.Win32Platform;
import com.installshield.wizard.platform.win32.Win32Utils;
import com.installshield.wizard.platform.win32.environment.AutoexecEnvironmentVariableManager;
import com.installshield.wizard.platform.win32.environment.ProcessEnvironmentVariableManager;
import com.installshield.wizard.platform.win32.environment.WinMEEnvironmentVariableManager;
import com.installshield.wizard.platform.win32.environment.WinNTEnvironmentVariableManager;
import com.installshield.wizard.platform.win32.environment.WindowsEnvironment;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.system.PureJavaSystemUtilServiceImpl;
import com.installshield.wizard.service.system.SystemUtilServiceImplementor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;

public class Win32SystemUtilServiceImpl
extends PureJavaSystemUtilServiceImpl
implements SystemUtilServiceImplementor,
LockedFilesHandler {
    public static final String PLATFORM_ID = "win32ppk";
    String cleanupEXE = "";
    private WinNTEnvironmentVariableManager ntUserEnvVarManager;
    private WinNTEnvironmentVariableManager ntSystemEnvVarManager;
    private WinMEEnvironmentVariableManager meEnvVarManager;
    private static AutoexecEnvironmentVariableManager autoexecEnvVarManager;
    private static boolean autoexecCleanedUp;
    private ProcessEnvironmentVariableManager processEnvVarManager;

    static {
        autoexecCleanedUp = false;
    }

    public native void addSystemStartupCommand(String var1) throws ServiceException;

    public void appendEnvironmentVariable(String string, String string2, String string3, int n) throws ServiceException {
        this.verifyVariableName(string);
        EnvironmentVariableManager environmentVariableManager = this.getEnvVarManager(n);
        if (environmentVariableManager != null) {
            environmentVariableManager.appendVariable(string, string2, string3);
        }
        this.verifyRebootForEnvironment(environmentVariableManager);
        this.processEnvVarManager.appendVariable(string, string2, string3);
    }

    public void cleanup() throws ServiceException {
        try {
            if (this.ntUserEnvVarManager != null) {
                this.ntUserEnvVarManager.makeUpdatePersistent();
            }
            if (this.ntSystemEnvVarManager != null) {
                this.ntSystemEnvVarManager.makeUpdatePersistent();
            }
            if (this.meEnvVarManager != null) {
                this.meEnvVarManager.makeUpdatePersistent();
            }
            if (!autoexecCleanedUp) {
                if (autoexecEnvVarManager != null) {
                    autoexecEnvVarManager.makeUpdatePersistent();
                }
                autoexecCleanedUp = true;
            }
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException);
        }
    }

    public void deleteEnvironmentVariable(String string) throws ServiceException {
        this.deleteEnvironmentVariable(string, 2);
    }

    public void deleteEnvironmentVariable(String string, int n) throws ServiceException {
        this.verifyVariableName(string);
        EnvironmentVariableManager environmentVariableManager = this.getEnvVarManager(n);
        if (environmentVariableManager != null) {
            environmentVariableManager.deleteVariable(string);
        }
        this.verifyRebootForEnvironment(environmentVariableManager);
        this.processEnvVarManager.deleteVariable(string);
    }

    protected void deleteFilesAfterExit() {
        super.deleteFilesAfterExit();
        try {
            String string;
            this.nativeDeleteFilesAfterExit(this.filesToDeleteOnExit(), this.directoriesToRecursivelyDeleteOnExit(), this.getRebootOnExit(), this.cleanupEXE);
            Enumeration enumeration = this.filesToDeleteOnExit();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                super.removeFileToDeleteOnExit(string);
            }
            enumeration = this.directoriesToRecursivelyDeleteOnExit();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                super.removeDirectoryToRecursivelyDeleteOnExit(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getAutoexec() {
        return String.valueOf(FileUtils.appendSeparator(this.getBootDirectory())) + "autoexec.bat";
    }

    public native String getBootDirectory();

    private EnvironmentVariableManager getEnvVarManager(int n) throws ServiceException {
        GenericEnvironmentVariableManager genericEnvironmentVariableManager = null;
        if (this.processEnvVarManager == null) {
            this.processEnvVarManager = new ProcessEnvironmentVariableManager();
        }
        try {
            if (this.isWinNTor2K()) {
                if (n == 1) {
                    if (this.ntSystemEnvVarManager == null) {
                        this.ntSystemEnvVarManager = new WinNTEnvironmentVariableManager(true);
                        this.ntSystemEnvVarManager.initialize();
                    }
                    genericEnvironmentVariableManager = this.ntSystemEnvVarManager;
                } else {
                    if (this.ntUserEnvVarManager == null) {
                        this.ntUserEnvVarManager = new WinNTEnvironmentVariableManager(false);
                        this.ntUserEnvVarManager.initialize();
                    }
                    genericEnvironmentVariableManager = this.ntUserEnvVarManager;
                }
            } else if (this.isWinME()) {
                if (this.meEnvVarManager == null) {
                    this.meEnvVarManager = new WinMEEnvironmentVariableManager(this, this.getBootDirectory());
                    this.meEnvVarManager.initialize();
                }
                genericEnvironmentVariableManager = this.meEnvVarManager;
            } else {
                if (autoexecEnvVarManager == null) {
                    autoexecEnvVarManager = new AutoexecEnvironmentVariableManager(this, this.getAutoexec());
                    autoexecEnvVarManager.initialize();
                }
                genericEnvironmentVariableManager = autoexecEnvVarManager;
            }
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException);
        }
        return genericEnvironmentVariableManager;
    }

    public String getEnvironmentVariable(String string) throws ServiceException {
        return WindowsEnvironment.getProcessEnvironmentVariable(string);
    }

    public native String getOSServiceLevel() throws ServiceException;

    protected String getPlatformIdImpl() {
        return PLATFORM_ID;
    }

    public String getRawEnvironmentVariable(String string, int n) throws ServiceException {
        this.verifyVariableName(string);
        EnvironmentVariableManager environmentVariableManager = this.getEnvVarManager(n);
        if (environmentVariableManager != null) {
            return environmentVariableManager.getVariable(string);
        }
        return null;
    }

    public int getSystemCompatibility() {
        int n = 0;
        try {
            if (Win32Platform.isCompatibleWith(1, 1)) {
                n = 5;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    protected void initialized() {
        super.initialized();
        FileUtils.setLockedFilesHandler(this);
        try {
            Win32Utils.loadDLL(this.getResource(Win32Utils.getJNIDLLResourceName()), Win32Utils.getJNIDLLName());
            this.cleanupEXE = this.writeNativeCleanupEXE();
            FileUtils.clearTempFile(this.cleanupEXE);
        }
        catch (Exception exception) {
            System.out.println(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "serviceCannotLoadJniDll", new String[]{"systemUtilService", Win32Utils.getJNIDLLName()}));
            exception.printStackTrace();
        }
    }

    public native boolean isWinME();

    public native boolean isWinNTor2K();

    private native void nativeDeleteFilesAfterExit(Enumeration var1, Enumeration var2, boolean var3, String var4) throws ServiceException;

    public void prependEnvironmentVariable(String string, String string2, String string3, int n) throws ServiceException {
        this.verifyVariableName(string);
        EnvironmentVariableManager environmentVariableManager = this.getEnvVarManager(n);
        if (environmentVariableManager != null) {
            environmentVariableManager.prependVariable(string, string2, string3);
        }
        this.verifyRebootForEnvironment(environmentVariableManager);
        this.processEnvVarManager.prependVariable(string, string2, string3);
    }

    public native void removeSystemStartupCommand(String var1) throws ServiceException;

    public void setEnvironmentVariable(String string, String string2) throws ServiceException {
        this.setEnvironmentVariable(string, string2, 2);
    }

    public void setEnvironmentVariable(String string, String string2, int n) throws ServiceException {
        this.verifyVariableName(string);
        EnvironmentVariableManager environmentVariableManager = this.getEnvVarManager(n);
        environmentVariableManager.setVariable(string, string2);
        this.verifyRebootForEnvironment(environmentVariableManager);
        this.processEnvVarManager.setVariable(string, string2);
    }

    public native Enumeration systemStartupCommands() throws ServiceException;

    public void unAppendEnvironmentVariable(String string, String string2, String string3, int n) throws ServiceException {
        this.verifyVariableName(string);
        EnvironmentVariableManager environmentVariableManager = this.getEnvVarManager(n);
        if (environmentVariableManager != null) {
            environmentVariableManager.unAppendVariable(string, string2, string3);
        }
        this.verifyRebootForEnvironment(environmentVariableManager);
        this.processEnvVarManager.unAppendVariable(string, string2, string3);
    }

    public void unPrependEnvironmentVariable(String string, String string2, String string3, int n) throws ServiceException {
        this.verifyVariableName(string);
        EnvironmentVariableManager environmentVariableManager = this.getEnvVarManager(n);
        if (environmentVariableManager != null) {
            environmentVariableManager.unPrependVariable(string, string2, string3);
        }
        this.verifyRebootForEnvironment(environmentVariableManager);
        this.processEnvVarManager.unPrependVariable(string, string2, string3);
    }

    private void verifyRebootForEnvironment(EnvironmentVariableManager environmentVariableManager) throws ServiceException {
        if (environmentVariableManager != null && environmentVariableManager instanceof AutoexecEnvironmentVariableManager) {
            this.setRebootRequired(true);
        }
    }

    private void verifyVariableName(String string) throws ServiceException {
        if (string == null || string.length() == 0) {
            throw new ServiceException(399, LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "systemUtil.variableNameRequired"));
        }
    }

    private String writeNativeCleanupEXE() throws IOException {
        do {
            this.cleanupEXE = FileUtils.createFileName(FileUtils.getTempDir(), FileUtils.createTempFileName());
        } while (new File(this.cleanupEXE).exists());
        InputStream inputStream = this.getResource(Win32Utils.getPlatformCleanupResource()).openStream();
        FileOutputStream fileOutputStream = new FileOutputStream(this.cleanupEXE);
        FileUtils.copy(inputStream, fileOutputStream);
        inputStream.close();
        fileOutputStream.close();
        return this.cleanupEXE;
    }
}

