/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.commandline;

import com.installshield.wizard.CommandLineBean;
import com.installshield.wizard.CommandLineOption;
import com.installshield.wizard.Wizard;
import java.util.Hashtable;

public class MediaLocationOption
extends CommandLineBean {
    private static final String SEPARATOR = "=";

    public boolean execute(Wizard wizard, String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Invalid command line option: media must have at least one argument");
            wizard.setExitCode(1001);
            return false;
        }
        Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
        int n = 0;
        while (n < stringArray.length) {
            int n2 = this.getMediaNumber(stringArray[n]);
            String string = this.getMediaLocation(stringArray[n]);
            if (n2 >= 1 && string != null) {
                hashtable.put(new Integer(n2), string);
            } else {
                if (n2 < 1) {
                    System.err.println("Error processing argument [" + n + "] to media:  media number must be numeric and greater than zero.");
                }
                if (string == null) {
                    System.err.println("Error processing argument [" + n + "] to media:  media location must be indicated.");
                }
            }
            ++n;
        }
        wizard.addMediaLocations(hashtable);
        return true;
    }

    public boolean getEarlyExecution() {
        return true;
    }

    private String getMediaLocation(String string) {
        String string2;
        String string3 = null;
        int n = string.indexOf(SEPARATOR);
        if (n > 0 && (string2 = string.substring(string.indexOf(SEPARATOR) + 1)).trim().length() > 0) {
            string3 = string2;
        }
        return string3;
    }

    private int getMediaNumber(String string) {
        int n;
        block2: {
            n = -1;
            int n2 = string.indexOf(SEPARATOR);
            if (n2 <= 0) break block2;
            String string2 = string.substring(0, n2);
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        }
        return n;
    }

    public CommandLineOption getOption() {
        return new CommandLineOption("media");
    }

    public boolean isRepeatable() {
        return true;
    }
}

