/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.awt;

import com.installshield.wizard.awt.AWTTreeListener;
import com.installshield.wizard.awt.AWTTreeNode;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizard.awt.InsetsPanel;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class AWTTree
extends Panel {
    public static final int TYPE_LABEL = 1;
    public static final int TYPE_CHECKBOX = 2;
    private static final int BUTTON_OFF = 0;
    private static final int BUTTON_EXPANDED = 1;
    private static final int BUTTON_COLLAPSED = 2;
    private AWTTreeNode root;
    private Vector treeListeners = new Vector();

    public AWTTree() {
        this("AWTTree Root");
    }

    public AWTTree(String string) {
        this(string, 1);
    }

    public AWTTree(String string, int n) {
        this.setLayout(new BorderLayout());
        this.root = new AWTTreeNode(this, null);
        AWTTreeNodeView aWTTreeNodeView = this.createNodeView(this.root, n);
        this.add((Component)aWTTreeNodeView, "Center");
        this.root.setView(aWTTreeNodeView);
        this.root.setCaption(string);
    }

    public AWTTreeNode addCheckbox(AWTTreeNode aWTTreeNode, String string, boolean bl) {
        AWTTreeNode aWTTreeNode2 = new AWTTreeNode(this, aWTTreeNode);
        aWTTreeNode2.setCaption(string);
        aWTTreeNode2.setState(bl ? 1 : 0);
        aWTTreeNode.addChild(aWTTreeNode2);
        AWTTreeNodeView aWTTreeNodeView = this.createNodeView(aWTTreeNode2, 2);
        aWTTreeNode2.setView(aWTTreeNodeView);
        ((AWTTreeNodeView)aWTTreeNode.getView()).addChildView(aWTTreeNodeView);
        return aWTTreeNode2;
    }

    public AWTTreeNode addLabel(AWTTreeNode aWTTreeNode, String string) {
        AWTTreeNode aWTTreeNode2 = new AWTTreeNode(this, aWTTreeNode);
        aWTTreeNode2.setCaption(string);
        aWTTreeNode.addChild(aWTTreeNode2);
        AWTTreeNodeView aWTTreeNodeView = this.createNodeView(aWTTreeNode2, 1);
        aWTTreeNode2.setView(aWTTreeNodeView);
        ((AWTTreeNodeView)aWTTreeNode.getView()).addChildView(aWTTreeNodeView);
        return aWTTreeNode2;
    }

    public void addTreeListener(AWTTreeListener aWTTreeListener) {
        this.treeListeners.addElement(aWTTreeListener);
    }

    private AWTTreeNodeView createNodeView(AWTTreeNode aWTTreeNode, int n) {
        return new AWTTreeNodeView(aWTTreeNode, n, true);
    }

    public AWTTreeNode getChild(AWTTreeNode aWTTreeNode, int n) {
        return aWTTreeNode.getChild(n);
    }

    public int getChildCount(AWTTreeNode aWTTreeNode) {
        return aWTTreeNode.getChildCount();
    }

    public AWTTreeNode getNodeParent(AWTTreeNode aWTTreeNode) {
        return aWTTreeNode.getParent();
    }

    public AWTTreeNode getRoot() {
        return this.root;
    }

    void nodeChanged(AWTTreeNode aWTTreeNode) {
        if (aWTTreeNode.getView() instanceof AWTTreeNodeView) {
            ((AWTTreeNodeView)aWTTreeNode.getView()).nodeChanged();
            while (aWTTreeNode.getParent() != null) {
                if (aWTTreeNode.getParent().getView() instanceof AWTTreeNodeView) {
                    ((AWTTreeNodeView)aWTTreeNode.getParent().getView()).refreshButtonState();
                }
                aWTTreeNode = aWTTreeNode.getParent();
            }
        }
    }

    private void notifyTreeListeners(AWTTreeNode aWTTreeNode) {
        int n = 0;
        while (n < this.treeListeners.size()) {
            ((AWTTreeListener)this.treeListeners.elementAt(n)).nodeStateChanged(this, aWTTreeNode);
            ++n;
        }
    }

    public void removeChildren(AWTTreeNode aWTTreeNode) {
        aWTTreeNode.removeChildren();
        ((AWTTreeNodeView)aWTTreeNode.getView()).removeChildViews();
    }

    public void removeTreeListener(AWTTreeListener aWTTreeListener) {
        this.treeListeners.removeElement(aWTTreeListener);
    }

    class AWTTreeNodeView
    extends Panel
    implements ItemListener {
        private AWTTreeNode node;
        private AWTTreeButton button;
        private Component label;
        private Container children;

        AWTTreeNodeView(AWTTreeNode aWTTreeNode, int n, boolean bl) {
            this.node = aWTTreeNode;
            this.setLayout(new ColumnLayout());
            Panel panel = new Panel(new BorderLayout());
            this.add((Component)panel, ColumnConstraints.createHorizontalFill());
            AWTTree aWTTree2 = AWTTree.this;
            aWTTree2.getClass();
            this.button = aWTTree2.new AWTTreeButton(this, 0);
            panel.add((Component)this.button, "West");
            Panel panel2 = new Panel(new FlowLayout(0, 0, 0));
            panel.add((Component)panel2, "Center");
            if (n == 1) {
                this.label = new Label(aWTTreeNode.getCaption());
                panel2.add(this.label);
            } else if (n == 2) {
                Checkbox checkbox = new Checkbox(aWTTreeNode.getCaption());
                panel2.add(checkbox);
                checkbox.setState(aWTTreeNode.getState() == 1);
                checkbox.addItemListener(this);
                this.label = checkbox;
            } else {
                throw new Error();
            }
            this.children = new InsetsPanel(0, this.button.getPreferredSize().width, 0, 0);
            this.add((Component)this.children, ColumnConstraints.createHorizontalFill());
            this.children.setLayout(new ColumnLayout());
            this.setExpanded(bl);
        }

        void addChildView(Component component) {
            this.children.add(component, ColumnConstraints.createHorizontalFill());
            this.refreshButtonState();
        }

        void buttonClicked(AWTTreeButton aWTTreeButton) {
            this.setExpanded(aWTTreeButton.getState() == 2);
        }

        boolean isExpanded() {
            return this.children.isVisible();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.node.setState(itemEvent.getStateChange() == 1 ? 1 : 0);
            AWTTree.this.notifyTreeListeners(this.node);
        }

        void nodeChanged() {
            this.setVisible(this.node.isVisible());
            if (this.label instanceof Label) {
                ((Label)this.label).setText(this.node.getCaption());
                ((Label)this.label).setEnabled(this.node.isEnabled());
            } else if (this.label instanceof Checkbox) {
                ((Checkbox)this.label).setLabel(this.node.getCaption());
                ((Checkbox)this.label).setState(this.node.getState() == 1);
                ((Checkbox)this.label).setEnabled(this.node.isEnabled());
            } else {
                throw new Error();
            }
        }

        void refreshButtonState() {
            int n = 0;
            while (n < this.children.getComponentCount()) {
                if (this.children.getComponent(n).isVisible()) {
                    this.button.updateState(this.isExpanded() ? 1 : 2);
                    return;
                }
                ++n;
            }
            this.button.updateState(0);
        }

        void removeChildViews() {
            this.children.removeAll();
            this.refreshButtonState();
        }

        void setExpanded(boolean bl) {
            this.children.setVisible(bl);
            if (this.children.getComponentCount() > 0) {
                this.button.updateState(bl ? 1 : 2);
            } else {
                this.button.updateState(0);
            }
            Container container = this.getParent();
            while (container != null && !(container instanceof ScrollPane)) {
                container = container.getParent();
            }
            if (container instanceof ScrollPane) {
                container.validate();
            } else if (this.getParent() != null) {
                this.getParent().doLayout();
            }
        }
    }

    class AWTTreeButton
    extends Panel {
        private AWTTreeNodeView view;
        private int state;
        private Dimension buttonSize = new Dimension(11, 11);
        private Insets insets = new Insets(0, 4, 0, 6);

        AWTTreeButton(AWTTreeNodeView aWTTreeNodeView, int n) {
            this.view = aWTTreeNodeView;
            this.state = n;
            this.enableEvents(16L);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.buttonSize.width + this.insets.right + this.insets.left, this.buttonSize.height + this.insets.top + this.insets.bottom);
        }

        int getState() {
            return this.state;
        }

        private boolean inButton(int n, int n2) {
            int n3 = (this.getSize().width - this.buttonSize.width) / 2;
            int n4 = (this.getSize().height - this.buttonSize.height) / 2 - 1;
            int n5 = this.buttonSize.width;
            int n6 = this.buttonSize.height;
            int n7 = 2;
            return n >= n3 - n7 && n <= n3 + n5 + n7 && n2 >= n4 - n7 && n2 <= n4 + n6 + n7;
        }

        public void paint(Graphics graphics) {
            int n = (this.getSize().width - this.buttonSize.width) / 2;
            int n2 = (this.getSize().height - this.buttonSize.height) / 2 - 1;
            int n3 = this.buttonSize.width;
            int n4 = this.buttonSize.height;
            if (this.state != 0) {
                graphics.setColor(Color.white);
                graphics.fillRect(n, n2, n3 - 1, n4 - 1);
                graphics.setColor(Color.black);
                graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                int n5 = n2 + n4 / 2;
                graphics.drawLine(n + 2, n5, n + n3 - 3, n5);
                if (this.state == 2) {
                    int n6 = n + n3 / 2;
                    graphics.drawLine(n6, n2 + 2, n6, n2 + n4 - 3);
                }
            }
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            if (this.state != 0 && mouseEvent.getID() == 501 && (mouseEvent.getModifiers() & 0x10) != 0 && this.inButton(mouseEvent.getX(), mouseEvent.getY())) {
                this.view.buttonClicked(this);
            }
        }

        void updateState(int n) {
            this.state = n;
            this.repaint();
        }
    }
}

