/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard;

import com.installshield.archive.ArchiveBuilderSupport;
import com.installshield.archive.ArchiveWriter;
import com.installshield.wizard.Wizard;
import com.installshield.wizard.service.ServiceDef;
import com.installshield.wizard.service.ServiceImplementorDef;
import com.installshield.wizard.service.ServicesDefinition;
import com.installshield.wizard.service.StringResolverMethodDef;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class WizardBuilderSupport
extends ArchiveBuilderSupport {
    private Wizard wizard;
    private Hashtable services = new Hashtable();
    private Hashtable serviceImplementors = new Hashtable();
    private Hashtable serviceImpls = new Hashtable();
    private Hashtable requiredServices = new Hashtable();
    private Hashtable resolverMethods = new Hashtable();
    private ServicesDefinition defaultServices;

    public WizardBuilderSupport(ArchiveWriter archiveWriter, Locale[] localeArray, Wizard wizard, ServicesDefinition servicesDefinition) {
        super(archiveWriter, localeArray);
        this.wizard = wizard;
        this.defaultServices = servicesDefinition;
        if (servicesDefinition != null) {
            int n = 0;
            while (n < servicesDefinition.getStringResolverMethodCount()) {
                this.putStringResolverMethod(servicesDefinition.getStringResolverMethod(n));
                ++n;
            }
        }
    }

    public ServiceImplementorDef[] getAvailableServiceImplementors() {
        ServiceImplementorDef[] serviceImplementorDefArray;
        ServiceImplementorDef[] serviceImplementorDefArray2 = new ServiceImplementorDef[this.serviceImplementors.size()];
        int n = 0;
        Enumeration enumeration = this.serviceImplementors.elements();
        while (enumeration.hasMoreElements()) {
            serviceImplementorDefArray2[n++] = (ServiceImplementorDef)enumeration.nextElement();
        }
        if (this.defaultServices != null) {
            serviceImplementorDefArray = new ServiceImplementorDef[serviceImplementorDefArray2.length + this.defaultServices.getImplementorCount()];
            System.arraycopy(serviceImplementorDefArray2, 0, serviceImplementorDefArray, 0, serviceImplementorDefArray2.length);
            n = 0;
            while (n < this.defaultServices.getImplementorCount()) {
                serviceImplementorDefArray[n + serviceImplementorDefArray2.length] = this.defaultServices.getImplementor(n);
                ++n;
            }
        } else {
            serviceImplementorDefArray = serviceImplementorDefArray2;
        }
        n = 0;
        while (n < serviceImplementorDefArray.length) {
            ServiceImplementorDef serviceImplementorDef = serviceImplementorDefArray[n];
            Hashtable hashtable = (Hashtable)this.serviceImpls.get(serviceImplementorDef.getName());
            if (hashtable != null) {
                Enumeration enumeration2 = hashtable.keys();
                while (enumeration2.hasMoreElements()) {
                    serviceImplementorDef.addImpl((String)enumeration2.nextElement());
                }
            }
            ++n;
        }
        return serviceImplementorDefArray;
    }

    public ServiceDef[] getAvailableServices() {
        ServiceDef[] serviceDefArray;
        ServiceDef[] serviceDefArray2 = new ServiceDef[this.services.size()];
        int n = 0;
        Enumeration enumeration = this.services.elements();
        while (enumeration.hasMoreElements()) {
            serviceDefArray2[n++] = (ServiceDef)enumeration.nextElement();
        }
        if (this.defaultServices != null) {
            serviceDefArray = new ServiceDef[serviceDefArray2.length + this.defaultServices.getServiceCount()];
            System.arraycopy(serviceDefArray2, 0, serviceDefArray, 0, serviceDefArray2.length);
            n = 0;
            while (n < this.defaultServices.getServiceCount()) {
                serviceDefArray[n + serviceDefArray2.length] = this.defaultServices.getService(n);
                ++n;
            }
        } else {
            serviceDefArray = serviceDefArray2;
        }
        return serviceDefArray;
    }

    public String[] getRequiredServices() {
        String[] stringArray = new String[this.requiredServices.size()];
        int n = 0;
        Enumeration enumeration = this.requiredServices.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public StringResolverMethodDef[] getStringResolverMethods() {
        StringResolverMethodDef[] stringResolverMethodDefArray = new StringResolverMethodDef[this.resolverMethods.size()];
        int n = 0;
        Enumeration enumeration = this.resolverMethods.elements();
        while (enumeration.hasMoreElements()) {
            stringResolverMethodDefArray[n++] = (StringResolverMethodDef)enumeration.nextElement();
        }
        return stringResolverMethodDefArray;
    }

    public Wizard getWizard() {
        return this.wizard;
    }

    public void putAvailableService(ServiceDef serviceDef, ServiceImplementorDef serviceImplementorDef) {
        if (this.services.containsKey(serviceDef.getName())) {
            this.logEvent(this, "wrn", "Service \"" + serviceDef.getName() + "\" already exists " + "and is being overwritten by class " + serviceDef.getInterface());
        }
        this.services.put(serviceDef.getName(), serviceDef);
        this.serviceImplementors.put(serviceDef.getName(), serviceImplementorDef);
    }

    public void putAvailableServiceImpl(String string, String string2) {
        Hashtable<String, String> hashtable = (Hashtable<String, String>)this.serviceImpls.get(string);
        if (hashtable == null) {
            hashtable = new Hashtable<String, String>();
            this.serviceImpls.put(string, hashtable);
        }
        hashtable.put(string2, "");
    }

    public void putCustomService(String string, String string2) {
        ServiceDef serviceDef = new ServiceDef(string, "com.installshield.wizard.service.custom.CustomService", "com.installshield.wizard.service.custom.GenericCustomService");
        ServiceImplementorDef serviceImplementorDef = new ServiceImplementorDef(string, "com.installshield.wizard.service.custom.CustomServiceImplementor", string2);
        this.putAvailableService(serviceDef, serviceImplementorDef);
        this.putRequiredService(string);
    }

    public void putRequiredService(String string) {
        this.requiredServices.put(string, "");
    }

    public void putStringResolverMethod(StringResolverMethodDef stringResolverMethodDef) {
        StringResolverMethodDef stringResolverMethodDef2 = (StringResolverMethodDef)this.resolverMethods.get(stringResolverMethodDef.getClassName());
        if (stringResolverMethodDef2 != null) {
            if (stringResolverMethodDef2.getContext() != stringResolverMethodDef.getContext()) {
                stringResolverMethodDef2.setContext(3);
            }
        } else {
            this.resolverMethods.put(stringResolverMethodDef.getClassName(), stringResolverMethodDef);
        }
    }

    public void setWizard(Wizard wizard) {
        this.wizard = wizard;
    }
}

