/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util.jvm;

import com.installshield.util.FileUtils;
import com.installshield.util.jvm.ApplicationArchive;
import com.installshield.util.jvm.ExecutableFile;
import com.installshield.util.jvm.IndexEntry;
import com.installshield.util.jvm.Instructions;
import com.installshield.util.jvm.JARFile;
import com.installshield.util.jvm.JVMFile;
import com.installshield.util.jvm.JVMInstaller;
import com.installshield.util.jvm.LaunchScript;
import com.installshield.util.jvm.LauncherEntry;
import com.installshield.util.jvm.VerifyClass;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Vector;

public class LauncherWriter {
    public static final byte INSTALLER_LAUNCHER = 0;
    public static final byte PRODUCT_LAUNCHER = 1;
    public static final byte UNINSTALLER_LAUNCHER = 2;
    private Vector entries = new Vector();
    private Vector jvmFiles = new Vector();
    private Vector jarFiles = new Vector();
    private Vector exeFiles = new Vector();
    private Instructions instructions = null;
    private LaunchScript launchScript = null;
    private JVMInstaller jvmInstaller = null;
    private ApplicationArchive applicationArchive = null;
    private URL launcherStub = null;
    private VerifyClass verifyClass = null;
    private String fileName = null;
    private boolean isOuterLauncherWriter = false;
    private byte launcherPurpose = 0;

    public void addExecutableFile(ExecutableFile executableFile) {
        if (executableFile == null) {
            throw new IllegalArgumentException("exeFile cannot be null");
        }
        this.exeFiles.addElement(executableFile);
        this.refreshEntriesList();
    }

    public void addJARFile(JARFile jARFile) {
        if (jARFile == null) {
            throw new IllegalArgumentException("jarFile cannot be null");
        }
        this.jarFiles.addElement(jARFile);
        this.refreshEntriesList();
    }

    public void addJVMFile(JVMFile jVMFile) {
        if (jVMFile == null) {
            throw new IllegalArgumentException("jvmFile cannot be null");
        }
        this.jvmFiles.addElement(jVMFile);
        this.refreshEntriesList();
    }

    public long calculateSize() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        Object object;
        this.validate();
        long l = LauncherWriter.getInputStreamSize(this.launcherStub.openStream());
        Vector<IndexEntry> vector = new Vector<IndexEntry>();
        int n = 0;
        int n2 = 0;
        while (n2 < this.entries.size()) {
            object = (LauncherEntry)this.entries.elementAt(n2);
            long l2 = 0L;
            if (!(object instanceof ApplicationArchive)) {
                l2 = ((LauncherEntry)object).calculateSize();
            }
            l += l2;
            vector.addElement(new IndexEntry(((LauncherEntry)object).getType(), (int)l2, n, ((LauncherEntry)object).getName(), ((LauncherEntry)object).isCompressed(), (int)((LauncherEntry)object).getDecompressedFileCount(), (int)((LauncherEntry)object).calculateTotalDecompressedSize()));
            n += (int)l2;
            ++n2;
        }
        object = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            object = new DataOutputStream(byteArrayOutputStream);
            this.writeIndex(vector, 0, (DataOutputStream)object);
            ((DataOutputStream)object).flush();
        }
        finally {
            Object var8_9 = null;
            ((FilterOutputStream)object).close();
        }
        return l += (long)byteArrayOutputStream.toByteArray().length;
    }

    protected Vector getEntries() {
        return this.entries;
    }

    public String getFileName() {
        return this.fileName;
    }

    public static long getInputStreamSize(InputStream inputStream) throws IOException {
        long l = 0L;
        try {
            byte[] byArray = new byte[4096];
            int n = inputStream.read(byArray);
            while (n >= 0) {
                l += (long)n;
                n = inputStream.read(byArray);
            }
        }
        finally {
            Object var4_4 = null;
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return l;
    }

    protected Instructions getInstructions() {
        return this.instructions;
    }

    protected LaunchScript getLaunchScript() {
        return this.launchScript;
    }

    public int getLauncherEntryIndex(int n) {
        return this.getLauncherEntryIndex(n, 0);
    }

    public int getLauncherEntryIndex(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.entries.size()) {
            if (((LauncherEntry)this.entries.elementAt(n4)).getType() == n && n3++ == n2) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    public byte getLauncherPurpose() {
        return this.launcherPurpose;
    }

    protected URL getLauncherStub() {
        return this.launcherStub;
    }

    protected boolean isOuterLauncherWriter() {
        return this.isOuterLauncherWriter;
    }

    private void refreshEntriesList() {
        this.entries.removeAllElements();
        if (this.verifyClass != null) {
            this.entries.addElement(this.verifyClass);
        }
        if (this.instructions != null) {
            this.entries.addElement(this.instructions);
        }
        if (this.launchScript != null) {
            this.entries.addElement(this.launchScript);
        }
        int n = 0;
        while (n < this.jvmFiles.size()) {
            this.entries.addElement(this.jvmFiles.elementAt(n));
            ++n;
        }
        int n2 = 0;
        while (n2 < this.jarFiles.size()) {
            this.entries.addElement(this.jarFiles.elementAt(n2));
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.exeFiles.size()) {
            this.entries.addElement(this.exeFiles.elementAt(n3));
            ++n3;
        }
        if (this.jvmInstaller != null) {
            this.entries.addElement(this.jvmInstaller);
        }
        if (this.applicationArchive != null) {
            this.entries.addElement(this.applicationArchive);
        }
    }

    public void setApplicationArchive(ApplicationArchive applicationArchive) {
        this.applicationArchive = applicationArchive;
        this.refreshEntriesList();
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setInstructions(Instructions instructions) {
        this.instructions = instructions;
        this.refreshEntriesList();
    }

    public void setJVMInstaller(JVMInstaller jVMInstaller) {
        this.jvmInstaller = jVMInstaller;
        this.refreshEntriesList();
    }

    public void setLaunchScript(LaunchScript launchScript) {
        this.launchScript = launchScript;
        this.refreshEntriesList();
    }

    public void setLauncherPurpose(byte by) {
        this.launcherPurpose = by;
    }

    public void setLauncherStub(URL uRL) {
        this.launcherStub = uRL;
    }

    public void setOuterLauncherWriter(boolean bl) {
        this.isOuterLauncherWriter = bl;
    }

    public void setVerifyClass(URL uRL) {
        if (this.verifyClass == null) {
            this.verifyClass = new VerifyClass();
        }
        this.verifyClass.setClassResource(uRL);
        this.refreshEntriesList();
    }

    protected void validate() throws IOException {
        if (this.launcherStub == null) {
            throw new IOException("launchStub not specified -- cannot write");
        }
        if (this.instructions == null) {
            throw new IOException("instructions not specified -- cannot write");
        }
        if (this.isOuterLauncherWriter) {
            if (this.exeFiles.size() <= 0) {
                throw new IOException("inner launcher executable not specified -- cannot write");
            }
        } else {
            if (this.verifyClass == null || this.verifyClass.getClassResource() == null) {
                throw new IOException("verifyClass not specified -- cannot write");
            }
            if (this.launchScript == null) {
                throw new IOException("launchScript not specified -- cannot write");
            }
        }
    }

    public void write() throws IOException {
        this.validate();
        int n = 0;
        Vector vector = new Vector();
        FileOutputStream fileOutputStream = new FileOutputStream(this.fileName);
        try {
            LauncherEntry launcherEntry;
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            InputStream inputStream = this.launcherStub.openStream();
            n += FileUtils.copy(inputStream, dataOutputStream);
            inputStream.close();
            n += this.writeEntry(this.instructions, dataOutputStream, n, vector);
            if (this.verifyClass != null) {
                n += this.writeEntry(this.verifyClass, dataOutputStream, n, vector);
            }
            if (this.launchScript != null) {
                n += this.writeEntry(this.launchScript, dataOutputStream, n, vector);
            }
            int n2 = 0;
            while (n2 < this.jvmFiles.size()) {
                JVMFile jVMFile = (JVMFile)this.jvmFiles.elementAt(n2);
                n += this.writeEntry(jVMFile, dataOutputStream, n, vector);
                ++n2;
            }
            if (this.jarFiles.size() > 0) {
                int n3 = 0;
                while (n3 < this.jarFiles.size()) {
                    launcherEntry = (JARFile)this.jarFiles.elementAt(n3);
                    n += this.writeEntry(launcherEntry, dataOutputStream, n, vector);
                    ++n3;
                }
            }
            if (this.exeFiles.size() > 0) {
                int n4 = 0;
                while (n4 < this.exeFiles.size()) {
                    launcherEntry = (ExecutableFile)this.exeFiles.elementAt(n4);
                    n += this.writeEntry(launcherEntry, dataOutputStream, n, vector);
                    ++n4;
                }
            }
            if (this.jvmInstaller != null) {
                n += this.writeEntry(this.jvmInstaller, dataOutputStream, n, vector);
            }
            if (this.applicationArchive != null) {
                n += this.writeEntry(this.applicationArchive, dataOutputStream, n, vector);
            }
            this.writeIndex(vector, n, dataOutputStream);
            dataOutputStream.flush();
        }
        catch (Throwable throwable) {
            Object var5_12 = null;
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        Object var5_11 = null;
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {}
    }

    private int writeEntry(LauncherEntry launcherEntry, OutputStream outputStream, int n, Vector vector) throws IOException {
        int n2 = launcherEntry.write(outputStream);
        vector.addElement(new IndexEntry(launcherEntry.getType(), n2, n, launcherEntry.getName(), launcherEntry.isCompressed(), (int)launcherEntry.getDecompressedFileCount(), (int)launcherEntry.calculateTotalDecompressedSize()));
        return n2;
    }

    private void writeIndex(Vector vector, int n, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(vector.size());
        int n2 = 0;
        while (n2 < vector.size()) {
            IndexEntry indexEntry = (IndexEntry)vector.elementAt(n2);
            dataOutputStream.writeByte(indexEntry.fileType);
            dataOutputStream.writeInt(n2);
            dataOutputStream.writeInt(indexEntry.byteLength);
            dataOutputStream.writeInt(indexEntry.offset);
            dataOutputStream.writeUTF(indexEntry.fileNameOnly);
            dataOutputStream.writeByte(indexEntry.isCompressed ? 1 : 0);
            if (indexEntry.isCompressed) {
                dataOutputStream.writeInt(indexEntry.decompressedFileCount);
                dataOutputStream.writeInt(indexEntry.decompressedSize);
            }
            ++n2;
        }
        dataOutputStream.writeByte(this.launcherPurpose);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(-897398142);
    }
}

