/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.wizardbeans;

import com.installshield.product.Product;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductFeature;
import com.installshield.product.ProductTree;
import com.installshield.product.ProductTreeIterator;
import com.installshield.product.ProductTreeIteratorFactory;
import com.installshield.product.wizardbeans.FeaturePanel;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.awt.AWTTree;
import com.installshield.wizard.awt.AWTTreeListener;
import com.installshield.wizard.awt.AWTTreeNode;
import com.installshield.wizard.awt.DefaultAWTWizardPanelImpl;
import com.installshield.wizard.service.ServiceException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ScrollPane;

public class FeaturePanelAWTImpl
extends DefaultAWTWizardPanelImpl
implements AWTTreeListener {
    private AWTTree tree = null;

    private void buildTree(AWTTreeNode aWTTreeNode, ProductBean productBean) {
        ProductBean productBean2 = productBean.getProductTree().getRoot();
        ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createChildIterator(productBean);
        ProductBean productBean3 = productTreeIterator.getNext(productTreeIterator.begin());
        while (productBean3 != productTreeIterator.end()) {
            if (productBean3 instanceof ProductFeature || productBean3 instanceof Product && productBean3 != productBean2) {
                boolean bl = this.getFP().isBeanRequired(productBean3.getBeanId());
                String string = this.getNodeCaption(this.resolveString(productBean3.getDisplayName()), bl, this.getFP().isBeanInstalled(productBean3.getBeanId()));
                AWTTreeNode aWTTreeNode2 = this.tree.addCheckbox(aWTTreeNode, string, bl || this.getFP().isBeanActive(productBean3.getBeanId()));
                aWTTreeNode2.setUserData(productBean3.getBeanId());
                aWTTreeNode2.setEnabled(bl ^ true);
                aWTTreeNode2.setVisible(this.getFP().isBeanVisible(productBean3.getBeanId()));
                this.buildTree(aWTTreeNode2, productBean3);
            }
            productBean3 = productTreeIterator.getNext(productBean3);
        }
    }

    public void entering(WizardBeanEvent wizardBeanEvent) {
        try {
            this.tree.removeChildren(this.tree.getRoot());
            this.buildTree(this.tree.getRoot(), this.getFP().getProductTree().getRoot());
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
    }

    private FeaturePanel getFP() {
        return (FeaturePanel)this.getPanel();
    }

    protected String getNodeCaption(String string, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        if (bl) {
            stringBuffer.append(" ");
            stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "FeaturePanel.requiredLabel"));
        }
        if (bl2) {
            stringBuffer.append(" ");
            stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "FeaturePanel.installedLabel"));
        }
        return stringBuffer.toString();
    }

    public void initialize(WizardBeanEvent wizardBeanEvent) {
        super.initialize(wizardBeanEvent);
        ScrollPane scrollPane = new ScrollPane();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)scrollPane, "Center");
        this.tree = new AWTTree(this.resolveString(this.getFP().getRootDisplayName()), this.isRootSelectable() ? 2 : 1);
        this.tree.addTreeListener(this);
        scrollPane.add(this.tree);
    }

    protected boolean isRootSelectable() {
        return false;
    }

    public void nodeStateChanged(AWTTree aWTTree, AWTTreeNode aWTTreeNode) {
        this.getFP().setBeanActive((String)aWTTreeNode.getUserData(), aWTTreeNode.getState() == 1);
        try {
            this.refreshTree(this.getFP().getProductTree(), aWTTree.getRoot());
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
    }

    private void refreshTree(ProductTree productTree, AWTTreeNode aWTTreeNode) {
        ProductBean productBean = aWTTreeNode.getUserData() == null ? productTree.getRoot() : productTree.getBean((String)aWTTreeNode.getUserData());
        boolean bl = this.getFP().isBeanRequired(productBean.getBeanId());
        if (aWTTreeNode.getUserData() != null) {
            aWTTreeNode.setCaption(this.getNodeCaption(this.resolveString(productBean.getDisplayName()), bl, this.getFP().isBeanInstalled(productBean.getBeanId())));
            aWTTreeNode.setVisible(this.getFP().isBeanVisible(productBean.getBeanId()));
        }
        aWTTreeNode.setState(bl || this.getFP().isBeanActive(productBean.getBeanId()) ? 1 : 0);
        aWTTreeNode.setEnabled(bl ^ true);
        int n = 0;
        while (n < this.tree.getChildCount(aWTTreeNode)) {
            this.refreshTree(productTree, this.tree.getChild(aWTTreeNode, n));
            ++n;
        }
    }
}

