/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive;

import com.installshield.archive.AbstractArchiveWriterOutputStream;
import com.installshield.archive.ArchiveWriterEntry;
import com.installshield.archive.index.ArchiveIndexWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class ArchiveWriterZipOutputStream
extends AbstractArchiveWriterOutputStream {
    private String currentArchiveName = "";
    private FileOutputStream zipFileOut = null;
    private ZipOutputStream zipOut = null;
    private DeflaterOutputStream defOut = null;
    private ZipEntry currentZipEntry = null;
    private boolean compressed = false;

    public ArchiveWriterZipOutputStream(String string, String string2, String string3, String string4, ArchiveIndexWriter archiveIndexWriter) {
        super(string, string2, string3, string4, archiveIndexWriter);
    }

    protected void closeArchiveEntry(ArchiveWriterEntry archiveWriterEntry) throws IOException {
        long l;
        Object object;
        this.finishWriteOutputStream();
        if (this.getCurrentZipEntry() != null) {
            object = this.getArchiveStream();
            ((ZipOutputStream)object).closeEntry();
        }
        object = null;
        ZipEntry zipEntry = this.getCurrentZipEntry();
        if (zipEntry != null && (l = zipEntry.getTime()) >= 0L) {
            object = new Date(l);
        }
        archiveWriterEntry.setDate((Date)object);
        this.setCurrentZipEntry(null);
    }

    void closeInternalArchive() throws IOException {
        try {
            if (this.zipOut != null) {
                this.closeZipStream(this.zipOut);
                this.zipOut = null;
            }
            this.fireApplicationArchiveFinished();
        }
        catch (IOException iOException) {
            throw new IOException("Could not close ZipOutputStream: " + this.currentArchiveName);
        }
    }

    protected void closeInternalEntry(ArchiveWriterEntry archiveWriterEntry) throws IOException {
        int n = archiveWriterEntry.getEntryType();
        if (n != 1 && n != 2 && n != 3) {
            throw new IOException("Unknown archive entry type: " + archiveWriterEntry.getId());
        }
        this.closeArchiveEntry(archiveWriterEntry);
    }

    private void closeZipStream(ZipOutputStream zipOutputStream) throws IOException {
        block2: {
            try {
                zipOutputStream.finish();
                zipOutputStream.close();
            }
            catch (ZipException zipException) {
                if (zipException.getMessage().startsWith("ZIP file must have at least one entry")) break block2;
                throw zipException;
            }
        }
    }

    private void finishWriteOutputStream() throws IOException {
        block2: {
            try {
                if (!this.compressed || this.defOut == null) break block2;
                this.defOut.finish();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.defOut = null;
                this.resetDeflater();
                throw throwable;
            }
        }
        Object var2_1 = null;
        this.defOut = null;
        this.resetDeflater();
    }

    void flushInternalArchive() throws IOException {
        if (this.zipOut != null) {
            ((FilterOutputStream)this.zipOut).flush();
        }
    }

    public String getApplicationArchiveName() {
        return this.createArchiveFileName(this.getArchiveName(), 1);
    }

    public long getApplicationArchiveSize() throws IOException {
        return new File(this.getApplicationArchiveName()).length();
    }

    private ZipOutputStream getArchiveStream() throws IOException {
        if (this.zipOut == null) {
            this.currentArchiveName = this.getApplicationArchiveName();
            this.createDirsForArchive(this.currentArchiveName);
            this.createMediaInf(1);
            this.zipFileOut = new FileOutputStream(this.currentArchiveName);
            this.zipOut = new ZipOutputStream(this.zipFileOut);
        }
        return this.zipOut;
    }

    private ZipEntry getCurrentZipEntry() {
        return this.currentZipEntry;
    }

    private DeflaterOutputStream getDeflaterOutputStream() throws IOException {
        if (this.zipOut == null) {
            throw new IOException("ZipOutputStream has not been properly initialized");
        }
        if (this.defOut == null) {
            this.resetDeflater();
            this.defOut = new DeflaterOutputStream((OutputStream)this.zipOut, this.getDeflater());
        }
        return this.defOut;
    }

    private OutputStream getWriteOutputStream() throws IOException {
        DeflaterOutputStream deflaterOutputStream = this.compressed ? this.getDeflaterOutputStream() : this.getArchiveStream();
        return deflaterOutputStream;
    }

    private boolean isCompressed() {
        return this.compressed;
    }

    private String normalizeEntryName(String string) {
        String string2 = string;
        string2 = string.replace(File.separatorChar, '/');
        char[] cArray = new char[string2.length()];
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        while (n2 < cArray.length) {
            char c = string2.charAt(n2);
            if (bl |= c != '/') {
                cArray[n++] = c;
                while (n2 < cArray.length - 1 && c == '/' && string2.charAt(n2 + 1) == '/') {
                    ++n2;
                }
            }
            ++n2;
        }
        string2 = new String(cArray, 0, n);
        return string2;
    }

    protected void putNextArchiveEntry(ArchiveWriterEntry archiveWriterEntry) throws IOException {
        this.putNextArchiveEntry(archiveWriterEntry, false);
    }

    protected void putNextArchiveEntry(ArchiveWriterEntry archiveWriterEntry, boolean bl) throws IOException {
        if (this.getCurrentZipEntry() != null) {
            throw new IOException("Entry Error:  Previous archive entry has not been closed.");
        }
        String string = this.normalizeEntryName(archiveWriterEntry.getId());
        ZipOutputStream zipOutputStream = this.getArchiveStream();
        ZipEntry zipEntry = null;
        if (!string.endsWith("/")) {
            zipEntry = new ZipEntry(string);
            zipOutputStream.putNextEntry(zipEntry);
        }
        this.setCurrentZipEntry(zipEntry);
        this.setCompressed(bl);
    }

    protected void putNextInternalEntry(ArchiveWriterEntry archiveWriterEntry) throws IOException {
        int n = archiveWriterEntry.getEntryType();
        if (n == 1 || n == 2) {
            this.putNextArchiveEntry(archiveWriterEntry, false);
        } else if (n == 3) {
            this.putNextArchiveEntry(archiveWriterEntry, true);
        } else {
            throw new IOException("Unknown archive entry type: " + archiveWriterEntry.getId());
        }
    }

    private void setCompressed(boolean bl) {
        this.compressed = bl;
    }

    private void setCurrentZipEntry(ZipEntry zipEntry) {
        this.currentZipEntry = zipEntry;
    }

    void writeToInternalArchive(ArchiveWriterEntry archiveWriterEntry, byte[] byArray, int n, int n2) throws IOException {
        OutputStream outputStream = this.getWriteOutputStream();
        outputStream.write(byArray, n, n2);
    }
}

